/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.repository;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.callback.FeatureRefreshCallback;
import growthbook.sdk.java.exception.FeatureFetchException;
import growthbook.sdk.java.model.Feature;
import growthbook.sdk.java.model.FeatureResponseKey;
import growthbook.sdk.java.model.HttpHeaders;
import growthbook.sdk.java.model.RequestBodyForRemoteEval;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import growthbook.sdk.java.repository.FeatureRefreshStrategy;
import growthbook.sdk.java.repository.GBFeaturesRepositoryRequestInterceptor;
import growthbook.sdk.java.repository.IGBFeaturesRepository;
import growthbook.sdk.java.sandbox.CachingManager;
import growthbook.sdk.java.util.DecryptionUtils;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBFeaturesRepository
implements IGBFeaturesRepository {
    private static final Logger log = LoggerFactory.getLogger(GBFeaturesRepository.class);
    private static final String ENABLED = "enabled";
    private static final String FILE_NAME = "FEATURE_CACHE.json";
    public static final String FILE_PATH_FOR_CACHE = "src/main/resources";
    public static final String EMPTY_JSON_OBJECT_STRING = "{}";
    private final String featuresEndpoint;
    private final String eventsEndpoint;
    private FeatureRefreshStrategy refreshStrategy;
    @Nullable
    @Deprecated
    private final String encryptionKey;
    @Nullable
    private final String decryptionKey;
    private final Integer swrTtlSeconds;
    private Long expiresAt;
    private final OkHttpClient okHttpClient;
    @Nullable
    private OkHttpClient sseHttpClient;
    private final ArrayList<FeatureRefreshCallback> refreshCallbacks = new ArrayList();
    private Boolean initialized = false;
    private Boolean sseAllowed = false;
    @Nullable
    private Request sseRequest = null;
    @Nullable
    private EventSource sseEventSource = null;
    @Nullable
    private String savedGroupsJson = "{}";
    private String featuresJson = "{}";
    private Map<String, Feature<?>> parsedFeatures = new HashMap();
    private JsonObject parsedSavedGroups = new JsonObject();
    private CachingManager cachingManager;
    private final boolean isCacheDisabled;
    @Nullable
    private final RequestBodyForRemoteEval requestBodyForRemoteEval;
    private final String remoteEvalEndPoint;

    public void setCachingManager(CachingManager cachingManager) {
        if (Boolean.FALSE.equals(this.isCacheDisabled)) {
            this.cachingManager = cachingManager;
        }
    }

    @Deprecated
    public GBFeaturesRepository(@Nullable String apiHost, String clientKey, @Deprecated @Nullable String encryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds) {
        this(apiHost, clientKey, encryptionKey, refreshStrategy, swrTtlSeconds, null, null, null);
    }

    public GBFeaturesRepository(@Nullable String apiHost, String clientKey, @Deprecated @Nullable String encryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds, @Nullable RequestBodyForRemoteEval requestBodyForRemoteEval) {
        this(apiHost, clientKey, encryptionKey, refreshStrategy, swrTtlSeconds, null, null, null, requestBodyForRemoteEval);
    }

    public GBFeaturesRepository(@Nullable String apiHost, String clientKey, @Deprecated @Nullable String encryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds, @Nullable Boolean isCacheDisabled) {
        this(apiHost, clientKey, encryptionKey, refreshStrategy, swrTtlSeconds, null, null, isCacheDisabled, null);
    }

    public GBFeaturesRepository(@Nullable String apiHost, String clientKey, @Deprecated @Nullable String encryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds, @Nullable OkHttpClient okHttpClient, @Nullable String decryptionKey, @Nullable Boolean isCacheDisabled, @Nullable RequestBodyForRemoteEval requestBodyForRemoteEval) {
        this(apiHost, clientKey, decryptionKey != null ? decryptionKey : encryptionKey, refreshStrategy, swrTtlSeconds, okHttpClient, isCacheDisabled, requestBodyForRemoteEval != null ? requestBodyForRemoteEval : new RequestBodyForRemoteEval());
    }

    public GBFeaturesRepository(@Nullable String apiHost, String clientKey, @Nullable String decryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds, @Nullable OkHttpClient okHttpClient, @Nullable Boolean isCacheDisabled, @Nullable RequestBodyForRemoteEval requestBodyForRemoteEval) {
        boolean bl = this.isCacheDisabled = isCacheDisabled == null || isCacheDisabled != false;
        if (clientKey == null) {
            throw new IllegalArgumentException("clientKey cannot be null");
        }
        if (apiHost == null) {
            apiHost = "https://cdn.growthbook.io";
        }
        this.refreshStrategy = refreshStrategy == null ? FeatureRefreshStrategy.STALE_WHILE_REVALIDATE : refreshStrategy;
        this.featuresEndpoint = apiHost + "/api/features/" + clientKey;
        this.eventsEndpoint = apiHost + "/sub/" + clientKey;
        this.remoteEvalEndPoint = apiHost + "/api/eval/" + clientKey;
        this.encryptionKey = decryptionKey;
        this.decryptionKey = decryptionKey;
        this.swrTtlSeconds = swrTtlSeconds == null ? 60 : swrTtlSeconds;
        this.requestBodyForRemoteEval = requestBodyForRemoteEval != null ? requestBodyForRemoteEval : new RequestBodyForRemoteEval();
        this.refreshExpiresAt();
        this.okHttpClient = okHttpClient == null ? this.initializeHttpClient() : okHttpClient;
        if (Boolean.FALSE.equals(isCacheDisabled)) {
            this.cachingManager = new CachingManager(FILE_PATH_FOR_CACHE);
        }
    }

    @Deprecated
    @Nullable
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public String getFeaturesJson() {
        if (this.refreshStrategy == FeatureRefreshStrategy.STALE_WHILE_REVALIDATE && this.isCacheExpired().booleanValue()) {
            this.enqueueFeatureRefreshRequest();
            this.refreshExpiresAt();
        }
        return this.featuresJson;
    }

    public Map<String, Feature<?>> getParsedFeatures() {
        if (this.refreshStrategy == FeatureRefreshStrategy.STALE_WHILE_REVALIDATE && this.isCacheExpired().booleanValue()) {
            this.enqueueFeatureRefreshRequest();
            this.refreshExpiresAt();
        }
        return this.parsedFeatures;
    }

    @Override
    public void onFeaturesRefresh(FeatureRefreshCallback callback) {
        this.refreshCallbacks.add(callback);
    }

    @Override
    public void clearCallbacks() {
        this.refreshCallbacks.clear();
    }

    private void enqueueFeatureRefreshRequest() {
        final GBFeaturesRepository self = this;
        Request request = new Request.Builder().url(this.featuresEndpoint).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                self.onRefreshFailed(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    self.onSuccess(response);
                }
                catch (FeatureFetchException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    @Override
    public void initialize() throws FeatureFetchException {
        this.initialize(false);
    }

    @Override
    public void initialize(Boolean retryOnFailure) throws FeatureFetchException {
        if (this.initialized.booleanValue()) {
            return;
        }
        switch (this.refreshStrategy) {
            case STALE_WHILE_REVALIDATE: {
                this.fetchFeatures();
                break;
            }
            case SERVER_SENT_EVENTS: {
                this.fetchFeatures();
                this.initializeSSE(retryOnFailure);
                break;
            }
            case REMOTE_EVAL_STRATEGY: {
                this.fetchForRemoteEval(this.requestBodyForRemoteEval);
            }
        }
        this.initialized = true;
    }

    private void initializeSSE(Boolean retryOnFailure) {
        if (!this.sseAllowed.booleanValue()) {
            log.info("\nFalling back to stale-while-revalidate refresh strategy. 'X-Sse-Support: enabled' not present on resource returned at {}", (Object)this.featuresEndpoint);
            this.refreshStrategy = FeatureRefreshStrategy.STALE_WHILE_REVALIDATE;
        }
        this.createEventSourceListenerAndStartListening(retryOnFailure);
    }

    private void createEventSourceListenerAndStartListening(final Boolean retryOnFailure) {
        this.sseEventSource = null;
        this.sseRequest = null;
        if (this.sseHttpClient == null) {
            this.sseHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new GBFeaturesRepositoryRequestInterceptor()).retryOnConnectionFailure(true).connectTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).build();
        }
        this.sseRequest = new Request.Builder().url(this.eventsEndpoint).header(HttpHeaders.ACCEPT.getHeader(), HttpHeaders.APPLICATION_JSON.getHeader()).addHeader(HttpHeaders.ACCEPT.getHeader(), HttpHeaders.SSE_HEADER.getHeader()).build();
        GBEventSourceListener gbEventSourceListener = new GBEventSourceListener(new GBEventSourceHandler(){

            @Override
            public void onClose(EventSource eventSource) {
                eventSource.cancel();
                GBFeaturesRepository.this.createEventSourceListenerAndStartListening(retryOnFailure);
            }

            @Override
            public void onFeaturesResponse(String featuresJsonResponse) throws FeatureFetchException {
                GBFeaturesRepository.this.onResponseJson(featuresJsonResponse, false);
            }
        }){

            @Override
            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                super.onFailure(eventSource, t, response);
                if (retryOnFailure.booleanValue()) {
                    GBFeaturesRepository.this.createEventSourceListenerAndStartListening(true);
                    try {
                        GBFeaturesRepository.this.fetchFeatures();
                    }
                    catch (FeatureFetchException featureFetchException) {
                        java.util.logging.Logger.getAnonymousLogger().throwing("GBFeaturesRepository", "createEventSourceListenerAndStartListening()", featureFetchException);
                    }
                }
            }
        };
        this.sseEventSource = EventSources.createFactory((OkHttpClient)this.sseHttpClient).newEventSource(this.sseRequest, (EventSourceListener)gbEventSourceListener);
        this.sseHttpClient.newCall(this.sseRequest).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.error("SSE connection failed: {}", (Object)e.getMessage(), (Object)e);
                call.cancel();
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                response.close();
            }
        });
    }

    private OkHttpClient initializeHttpClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new GBFeaturesRepositoryRequestInterceptor()).retryOnConnectionFailure(true).build();
    }

    private void refreshExpiresAt() {
        this.expiresAt = Instant.now().getEpochSecond() + (long)this.swrTtlSeconds.intValue();
    }

    private Boolean isCacheExpired() {
        long now = Instant.now().getEpochSecond();
        return now >= this.expiresAt;
    }

    public void fetchFeatures() throws FeatureFetchException {
        block9: {
            if (this.featuresEndpoint == null) {
                throw new IllegalArgumentException("features endpoint cannot be null");
            }
            Request request = new Request.Builder().url(this.featuresEndpoint).build();
            try (Response response = this.okHttpClient.newCall(request).execute();){
                String sseSupportHeader = response.header(HttpHeaders.X_SSE_SUPPORT.getHeader());
                this.sseAllowed = Objects.equals(sseSupportHeader, ENABLED);
                this.onSuccess(response);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.isCacheDisabled) break block9;
                String cachedData = this.getCachedFeatures();
                this.onResponseJson(cachedData, true);
            }
        }
    }

    private void onResponseJson(String responseJsonString, boolean isFromCache) throws FeatureFetchException {
        try {
            String refreshedFeatures;
            if (!isFromCache && !this.isCacheDisabled) {
                this.cachingManager.saveContent(FILE_NAME, responseJsonString);
            }
            JsonObject jsonObject = (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(responseJsonString, JsonObject.class);
            String refreshedSavedGroups = "";
            if (this.decryptionKey != null) {
                JsonElement encryptedFeaturesJsonElement = jsonObject.get(FeatureResponseKey.ENCRYPTED_FEATURES_KEY.getKey());
                JsonElement encryptedSavedGroupsJsonElement = jsonObject.get(FeatureResponseKey.ENCRYPTED_SAVED_GROUPS_KEY.getKey());
                if (encryptedFeaturesJsonElement == null) {
                    log.error("FeatureFetchException: CONFIGURATION_ERROR feature fetch error code: encryptionKey provided but endpoint not encrypted");
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "encryptionKey provided but endpoint not encrypted");
                }
                String encryptedFeaturesJson = encryptedFeaturesJsonElement.getAsString();
                if (encryptedSavedGroupsJsonElement != null) {
                    String encryptedSavedGroupsJson = encryptedSavedGroupsJsonElement.getAsString();
                    refreshedSavedGroups = DecryptionUtils.decrypt(encryptedSavedGroupsJson, this.decryptionKey).trim();
                }
                refreshedFeatures = DecryptionUtils.decrypt(encryptedFeaturesJson, this.decryptionKey).trim();
            } else {
                JsonElement featuresJsonElement = jsonObject.get(FeatureResponseKey.FEATURE_KEY.getKey());
                JsonElement savedGroupsJsonElement = jsonObject.get(FeatureResponseKey.SAVED_GROUP_KEY.getKey());
                if (featuresJsonElement == null) {
                    log.error("FeatureFetchException: CONFIGURATION_ERROR feature fetch error code: No features found");
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "No features found");
                }
                if (savedGroupsJsonElement != null) {
                    refreshedSavedGroups = savedGroupsJsonElement.toString().trim();
                }
                refreshedFeatures = featuresJsonElement.toString().trim();
            }
            this.featuresJson = refreshedFeatures;
            this.savedGroupsJson = refreshedSavedGroups;
            this.parsedFeatures = TransformationUtil.transformFeatures(this.featuresJson);
            this.parsedSavedGroups = TransformationUtil.transformSavedGroups(this.savedGroupsJson);
            this.onRefreshSuccess(this.featuresJson);
        }
        catch (DecryptionUtils.DecryptionException e) {
            log.error("FeatureFetchException: UNKNOWN feature fetch error code {}", (Object)e.getMessage(), (Object)e);
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
        }
    }

    private void onRefreshSuccess(String featuresJson) {
        for (FeatureRefreshCallback callback : this.refreshCallbacks) {
            if (callback == null) continue;
            callback.onRefresh(featuresJson);
        }
    }

    private void onRefreshFailed(Throwable throwable) {
        for (FeatureRefreshCallback callback : this.refreshCallbacks) {
            if (callback == null) continue;
            callback.onError(throwable);
        }
    }

    private void onSuccess(Response response) throws FeatureFetchException {
        try {
            ResponseBody responseBody = response.body();
            if (response.code() != 200 || responseBody == null) {
                log.error("FeatureFetchException: {} with status {}, response: {}", new Object[]{responseBody == null ? FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR : FeatureFetchException.FeatureFetchErrorCode.HTTP_RESPONSE_ERROR, response.code(), responseBody != null ? responseBody.string() : "null"});
                if (this.isCacheDisabled) {
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.HTTP_RESPONSE_ERROR, "Failed to fetch data from server and cache is disabled");
                }
                log.info("Fetching data from cache...");
                String featuresFromCache = this.getCachedFeatures();
                if (featuresFromCache.isEmpty()) {
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR, "Failed to fetch data from cache");
                }
                this.onResponseJson(featuresFromCache, true);
                return;
            }
            this.onResponseJson(responseBody.string(), false);
        }
        catch (IOException e) {
            log.error("FeatureFetchException: UNKNOWN feature fetch error code {}", (Object)e.getMessage(), (Object)e);
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
        }
    }

    public void shutdown() {
        if (this.sseEventSource != null) {
            this.sseEventSource.cancel();
            this.sseEventSource = null;
            log.info("SseEventSource cancel");
        }
        if (this.sseHttpClient != null) {
            this.sseHttpClient.dispatcher().cancelAll();
            this.sseHttpClient.connectionPool().evictAll();
            if (this.sseHttpClient.cache() != null) {
                try {
                    this.sseHttpClient.cache().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.sseHttpClient = null;
            log.info("SseHttpClient shutdown");
        }
    }

    public void fetchForRemoteEval(RequestBodyForRemoteEval requestBodyForRemoteEval) throws FeatureFetchException {
        if (this.remoteEvalEndPoint == null) {
            throw new IllegalArgumentException("remote eval features endpoint cannot be null");
        }
        String jsonBody = GrowthBookJsonUtils.getInstance().gson.toJson((Object)requestBodyForRemoteEval);
        RequestBody requestBody = RequestBody.create((String)jsonBody, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(this.remoteEvalEndPoint).post(requestBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (response.isSuccessful() && response.code() == 200) {
                this.onSuccess(response);
            } else {
                this.onRefreshFailed(new Throwable("Response is not success, response code is:" + response.code() + ". And message is: " + response.message()));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR, e.getMessage());
        }
    }

    private String getCachedFeatures() throws FeatureFetchException {
        String cachedData = this.cachingManager.loadCache(FILE_NAME);
        if (cachedData == null) {
            log.error("FeatureFetchException: No Features from Cache");
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR);
        }
        return cachedData;
    }

    public static GBFeaturesRepositoryBuilder builder() {
        return new GBFeaturesRepositoryBuilder();
    }

    public String getFeaturesEndpoint() {
        return this.featuresEndpoint;
    }

    public String getEventsEndpoint() {
        return this.eventsEndpoint;
    }

    public FeatureRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    @Nullable
    public String getDecryptionKey() {
        return this.decryptionKey;
    }

    public Integer getSwrTtlSeconds() {
        return this.swrTtlSeconds;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public Boolean getInitialized() {
        return this.initialized;
    }

    @Nullable
    public String getSavedGroupsJson() {
        return this.savedGroupsJson;
    }

    public JsonObject getParsedSavedGroups() {
        return this.parsedSavedGroups;
    }

    public CachingManager getCachingManager() {
        return this.cachingManager;
    }

    @Nullable
    public RequestBodyForRemoteEval getRequestBodyForRemoteEval() {
        return this.requestBodyForRemoteEval;
    }

    public String getRemoteEvalEndPoint() {
        return this.remoteEvalEndPoint;
    }

    private static interface GBEventSourceHandler {
        public void onClose(EventSource var1);

        public void onFeaturesResponse(String var1) throws FeatureFetchException;
    }

    public static class GBFeaturesRepositoryBuilder {
        private String apiHost;
        private String clientKey;
        private String encryptionKey;
        private FeatureRefreshStrategy refreshStrategy;
        private Integer swrTtlSeconds;
        private OkHttpClient okHttpClient;
        private String decryptionKey;
        private Boolean isCacheDisabled;
        private RequestBodyForRemoteEval requestBodyForRemoteEval;

        GBFeaturesRepositoryBuilder() {
        }

        public GBFeaturesRepositoryBuilder apiHost(@Nullable String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public GBFeaturesRepositoryBuilder clientKey(String clientKey) {
            this.clientKey = clientKey;
            return this;
        }

        @Deprecated
        public GBFeaturesRepositoryBuilder encryptionKey(@Nullable String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public GBFeaturesRepositoryBuilder refreshStrategy(@Nullable FeatureRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        public GBFeaturesRepositoryBuilder swrTtlSeconds(@Nullable Integer swrTtlSeconds) {
            this.swrTtlSeconds = swrTtlSeconds;
            return this;
        }

        public GBFeaturesRepositoryBuilder okHttpClient(@Nullable OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public GBFeaturesRepositoryBuilder decryptionKey(@Nullable String decryptionKey) {
            this.decryptionKey = decryptionKey;
            return this;
        }

        public GBFeaturesRepositoryBuilder isCacheDisabled(@Nullable Boolean isCacheDisabled) {
            this.isCacheDisabled = isCacheDisabled;
            return this;
        }

        public GBFeaturesRepositoryBuilder requestBodyForRemoteEval(@Nullable RequestBodyForRemoteEval requestBodyForRemoteEval) {
            this.requestBodyForRemoteEval = requestBodyForRemoteEval;
            return this;
        }

        public GBFeaturesRepository build() {
            return new GBFeaturesRepository(this.apiHost, this.clientKey, this.encryptionKey, this.refreshStrategy, this.swrTtlSeconds, this.okHttpClient, this.decryptionKey, this.isCacheDisabled, this.requestBodyForRemoteEval);
        }

        public String toString() {
            return "GBFeaturesRepository.GBFeaturesRepositoryBuilder(apiHost=" + this.apiHost + ", clientKey=" + this.clientKey + ", encryptionKey=" + this.encryptionKey + ", refreshStrategy=" + (Object)((Object)this.refreshStrategy) + ", swrTtlSeconds=" + this.swrTtlSeconds + ", okHttpClient=" + this.okHttpClient + ", decryptionKey=" + this.decryptionKey + ", isCacheDisabled=" + this.isCacheDisabled + ", requestBodyForRemoteEval=" + this.requestBodyForRemoteEval + ")";
        }
    }

    private static class GBEventSourceListener
    extends EventSourceListener {
        private final GBEventSourceHandler handler;

        public GBEventSourceListener(GBEventSourceHandler handler) {
            this.handler = handler;
        }

        public void onClosed(@NotNull EventSource eventSource) {
            super.onClosed(eventSource);
            this.handler.onClose(eventSource);
        }

        public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
            super.onEvent(eventSource, id, type, data);
            if (data.trim().isEmpty()) {
                return;
            }
            try {
                this.handler.onFeaturesResponse(data);
            }
            catch (FeatureFetchException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
            super.onFailure(eventSource, t, response);
        }

        public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
            super.onOpen(eventSource, response);
        }
    }
}

