/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.internal.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.internal.services.ConditionEvaluator;
import growthbook.sdk.java.internal.services.ExperimentEvaluator;
import growthbook.sdk.java.internal.services.GrowthBookJsonUtils;
import growthbook.sdk.java.internal.services.GrowthBookUtils;
import growthbook.sdk.java.internal.services.IFeatureEvaluator;
import growthbook.sdk.java.models.Context;
import growthbook.sdk.java.models.Experiment;
import growthbook.sdk.java.models.ExperimentResult;
import growthbook.sdk.java.models.Feature;
import growthbook.sdk.java.models.FeatureResult;
import growthbook.sdk.java.models.FeatureResultSource;
import growthbook.sdk.java.models.FeatureRule;

public class FeatureEvaluator
implements IFeatureEvaluator {
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final ExperimentEvaluator experimentEvaluator = new ExperimentEvaluator();

    @Override
    public <ValueType> FeatureResult<ValueType> evaluateFeature(String key, Context context) throws ClassCastException {
        FeatureResult emptyFeature = FeatureResult.builder().value(null).source(FeatureResultSource.UNKNOWN_FEATURE).build();
        try {
            JsonObject attributes;
            JsonObject featuresJson = context.getFeatures();
            if (featuresJson == null || !featuresJson.has(key)) {
                return emptyFeature;
            }
            JsonElement featureJson = featuresJson.get(key);
            FeatureResult defaultValueFeature = FeatureResult.builder().value(null).source(FeatureResultSource.DEFAULT_VALUE).build();
            if (featureJson == null) {
                System.out.println("featureJson is null");
                return defaultValueFeature;
            }
            Feature feature = (Feature)this.jsonUtils.gson.fromJson(featureJson, Feature.class);
            if (feature == null) {
                return defaultValueFeature;
            }
            if (feature.getRules() == null || feature.getRules().isEmpty()) {
                Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
                return FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
            }
            String attributesJson = context.getAttributesJson();
            if (attributesJson == null) {
                attributesJson = "{}";
            }
            if ((attributes = context.getAttributes()) == null) {
                attributes = new JsonObject();
            }
            for (FeatureRule rule : feature.getRules()) {
                Experiment experiment;
                ExperimentResult result;
                if (rule.getCondition() != null && !this.conditionEvaluator.evaluateCondition(attributesJson, rule.getCondition().toString()).booleanValue()) continue;
                if (rule.getForce() != null) {
                    if (rule.getCoverage() != null) {
                        String attrValue;
                        Float hashFnv;
                        JsonElement attrValueElement;
                        String ruleKey = rule.getHashAttribute();
                        if (ruleKey == null) {
                            ruleKey = "id";
                        }
                        if ((attrValueElement = attributes.get(ruleKey)) == null || attrValueElement.isJsonNull()) continue;
                        boolean isEmpty = false;
                        if (attrValueElement.isJsonObject()) {
                            isEmpty = attrValueElement.getAsJsonObject().entrySet().size() == 0;
                        } else if (attrValueElement.isJsonArray()) {
                            isEmpty = attrValueElement.getAsJsonArray().size() == 0;
                        } else if (attrValueElement.isJsonPrimitive() && attrValueElement.getAsJsonPrimitive().isString()) {
                            isEmpty = attrValueElement.getAsString().isEmpty();
                        }
                        if (isEmpty || (hashFnv = GrowthBookUtils.hash((attrValue = attrValueElement.getAsString()) + key)).floatValue() > rule.getCoverage().floatValue()) continue;
                    }
                    Object value = GrowthBookJsonUtils.unwrap(rule.getForce());
                    return FeatureResult.builder().value(value).source(FeatureResultSource.FORCE).build();
                }
                String experimentKey = rule.getKey();
                if (experimentKey == null) {
                    experimentKey = key;
                }
                if (!(result = this.experimentEvaluator.evaluateExperiment(experiment = Experiment.builder().key(experimentKey).coverage(rule.getCoverage()).weights(rule.getWeights()).hashAttribute(rule.getHashAttribute()).namespace(rule.getNamespace()).variations(rule.getVariations()).build(), context, key)).getInExperiment().booleanValue()) continue;
                Object value = GrowthBookJsonUtils.unwrap(result.getValue());
                return FeatureResult.builder().value(value).source(FeatureResultSource.EXPERIMENT).experiment(experiment).experimentResult(result).build();
            }
            Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
            return FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return emptyFeature;
        }
    }
}

