/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import growthbook.sdk.java.IGrowthBook;
import growthbook.sdk.java.internal.services.ConditionEvaluator;
import growthbook.sdk.java.internal.services.ExperimentEvaluator;
import growthbook.sdk.java.internal.services.FeatureEvaluator;
import growthbook.sdk.java.internal.services.GrowthBookJsonUtils;
import growthbook.sdk.java.models.Context;
import growthbook.sdk.java.models.Experiment;
import growthbook.sdk.java.models.ExperimentResult;
import growthbook.sdk.java.models.ExperimentRunCallback;
import growthbook.sdk.java.models.FeatureResult;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class GrowthBook
implements IGrowthBook {
    private final Context context;
    private final FeatureEvaluator featureEvaluator;
    private final ConditionEvaluator conditionEvaluator;
    private final ExperimentEvaluator experimentEvaluatorEvaluator;
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private ArrayList<ExperimentRunCallback> callbacks = new ArrayList();

    public GrowthBook(Context context) {
        this.context = context;
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
    }

    public GrowthBook() {
        this.context = Context.builder().build();
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
    }

    GrowthBook(Context context, FeatureEvaluator featureEvaluator, ConditionEvaluator conditionEvaluator, ExperimentEvaluator experimentEvaluator) {
        this.featureEvaluator = featureEvaluator;
        this.conditionEvaluator = conditionEvaluator;
        this.experimentEvaluatorEvaluator = experimentEvaluator;
        this.context = context;
    }

    @Override
    @Nullable
    public <ValueType> FeatureResult<ValueType> evalFeature(String key) {
        return this.featureEvaluator.evaluateFeature(key, this.context);
    }

    @Override
    public void setFeatures(String featuresJsonString) {
        this.context.setFeaturesJson(featuresJsonString);
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> run(Experiment<ValueType> experiment) {
        ExperimentResult result = this.experimentEvaluatorEvaluator.evaluateExperiment(experiment, this.context, null);
        this.callbacks.forEach(callback -> callback.onRun(result));
        return result;
    }

    @Override
    public Boolean isOn(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context).isOn();
    }

    @Override
    public Boolean isOff(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context).isOff();
    }

    @Override
    public Boolean getFeatureValue(String featureKey, Boolean defaultValue) {
        try {
            return (Boolean)this.featureEvaluator.evaluateFeature(featureKey, this.context).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public String getFeatureValue(String featureKey, String defaultValue) {
        try {
            return (String)this.featureEvaluator.evaluateFeature(featureKey, this.context).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Float getFeatureValue(String featureKey, Float defaultValue) {
        try {
            Double value = this.getFeatureValue(featureKey, Double.valueOf(defaultValue.floatValue()));
            return Float.valueOf(value.floatValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Integer getFeatureValue(String featureKey, Integer defaultValue) {
        try {
            Double value = this.getFeatureValue(featureKey, (double)defaultValue);
            return value.intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Object getFeatureValue(String featureKey, Object defaultValue) {
        try {
            return this.featureEvaluator.evaluateFeature(featureKey, this.context).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public <ValueType> ValueType getFeatureValue(String featureKey, ValueType defaultValue, Class<ValueType> gsonDeserializableClass) {
        try {
            Object value = this.featureEvaluator.evaluateFeature(featureKey, this.context).getValue();
            String stringValue = this.jsonUtils.gson.toJson(value);
            return (ValueType)this.jsonUtils.gson.fromJson(stringValue, gsonDeserializableClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Boolean evaluateCondition(String attributesJsonString, String conditionJsonString) {
        return this.conditionEvaluator.evaluateCondition(attributesJsonString, conditionJsonString);
    }

    @Override
    public Double getFeatureValue(String featureKey, Double defaultValue) {
        try {
            return (Double)this.featureEvaluator.evaluateFeature(featureKey, this.context).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public void destroy() {
        this.callbacks = new ArrayList();
    }

    @Override
    public void subscribe(ExperimentRunCallback callback) {
        this.callbacks.add(callback);
    }
}

