/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player.util;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.pubnative.player.util.VASTLog;

public class HttpTools {
    private static Handler mainHandler = new Handler(Looper.getMainLooper());
    private static final String TAG = HttpTools.class.getName();

    public static void httpGetURL(final String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection conn = null;
                    try {
                        VASTLog.v(TAG, "connection to URL:" + url);
                        URL httpUrl = new URL(url);
                        HttpURLConnection.setFollowRedirects(true);
                        conn = (HttpURLConnection)httpUrl.openConnection();
                        conn.setConnectTimeout(5000);
                        conn.setRequestProperty("Connection", "close");
                        conn.setRequestMethod("GET");
                        conn.connect();
                        int code = conn.getResponseCode();
                        VASTLog.v(TAG, "response code:" + code + ", for URL:" + url);
                        conn.getInputStream().close();
                        conn.getOutputStream().close();
                    }
                    catch (Exception e) {
                        VASTLog.w(TAG, url + ": " + e.getMessage() + ":" + e.toString());
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }.start();
        } else {
            VASTLog.w(TAG, "url is null or empty");
        }
    }

    public static void downloadFile(final String url, final File outFile, final NetworkRequestListener listener) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection conn = null;
                    try {
                        VASTLog.v(TAG, "connection to URL:" + url);
                        URL httpUrl = new URL(url);
                        HttpURLConnection.setFollowRedirects(true);
                        conn = (HttpURLConnection)httpUrl.openConnection();
                        conn.setRequestMethod("GET");
                        FileOutputStream outputStream = new FileOutputStream(outFile);
                        InputStream inputStream = conn.getInputStream();
                        byte[] buffer = new byte[1024];
                        int bufferLength = 0;
                        while ((bufferLength = inputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, bufferLength);
                        }
                        outputStream.close();
                        int code = conn.getResponseCode();
                        VASTLog.v(TAG, "response code:" + code + ", for URL:" + url);
                        conn.getInputStream().close();
                        mainHandler.post(() -> listener.onRequestSuccess());
                    }
                    catch (Exception e) {
                        VASTLog.w(TAG, url + ": " + e.getMessage() + ":" + e.toString());
                        mainHandler.post(() -> listener.onRequestFailed(e));
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }.start();
        } else {
            VASTLog.w(TAG, "url is null or empty");
        }
    }

    static interface NetworkRequestListener {
        public void onRequestSuccess();

        public void onRequestFailed(Throwable var1);
    }
}

