/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player.processor;

import android.text.TextUtils;
import java.util.List;
import net.pubnative.player.model.VASTMediaFile;
import net.pubnative.player.model.VASTModel;
import net.pubnative.player.processor.VASTMediaPicker;
import net.pubnative.player.util.VASTLog;

public class VASTModelPostValidator {
    private static final String TAG = VASTModelPostValidator.class.getName();

    public static boolean validate(VASTModel model, VASTMediaPicker mediaPicker) {
        VASTLog.d(TAG, "validate");
        if (!VASTModelPostValidator.validateModel(model)) {
            VASTLog.d(TAG, "Validator returns: not valid (invalid model)");
            return false;
        }
        boolean isValid = false;
        if (mediaPicker != null) {
            String url;
            List<VASTMediaFile> mediaFiles = model.getMediaFiles();
            VASTMediaFile mediaFile = mediaPicker.pickVideo(mediaFiles);
            if (mediaFile != null && !TextUtils.isEmpty((CharSequence)(url = mediaFile.getValue()))) {
                isValid = true;
                model.setPickedMediaFileURL(url);
                VASTLog.d(TAG, "mediaPicker selected mediaFile with URL " + url);
            }
        } else {
            VASTLog.w(TAG, "mediaPicker: We don't have a compatible media file to play.");
        }
        VASTLog.d(TAG, "Validator returns: " + (isValid ? "valid" : "not valid (no media file)"));
        return isValid;
    }

    private static boolean validateModel(VASTModel model) {
        List<VASTMediaFile> mediaFiles;
        VASTLog.d(TAG, "validateModel");
        boolean isValid = true;
        List<String> impressions = model.getImpressions();
        if (impressions == null || impressions.size() == 0) {
            isValid = false;
        }
        if ((mediaFiles = model.getMediaFiles()) == null || mediaFiles.size() == 0) {
            VASTLog.d(TAG, "Validator error: mediaFile list invalid");
            isValid = false;
        }
        return isValid;
    }
}

