/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.pubnative.player.R;
import net.pubnative.player.model.TRACKING_EVENTS_TYPE;
import net.pubnative.player.model.VASTModel;
import net.pubnative.player.util.CacheManager;
import net.pubnative.player.util.HttpTools;
import net.pubnative.player.util.VASTLog;
import net.pubnative.player.widget.CountDownView;

public class VASTPlayer
extends RelativeLayout
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
View.OnClickListener {
    private static final String TAG = VASTPlayer.class.getName();
    private static final String TEXT_BUFFERING = "Buffering...";
    private Listener mListener = null;
    private Timer mLayoutTimer;
    private Timer mProgressTimer;
    private Timer mTrackingEventsTimer;
    private static final long TIMER_TRACKING_INTERVAL = 250L;
    private static final long TIMER_PROGRESS_INTERVAL = 50L;
    private static final long TIMER_LAYOUT_INTERVAL = 50L;
    private static final int MAX_PROGRESS_TRACKING_POINTS = 20;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private VASTModel mVastModel;
    private String mSkipName;
    private int mSkipDelay;
    private MediaPlayer mMediaPlayer;
    private View mRoot;
    private View mOpen;
    private View mLoader;
    private TextView mLoaderText;
    private View mPlayer;
    private SurfaceView mSurface;
    private RelativeLayout mSurfaceHolder;
    private TextView mSkip;
    private ImageView mMute;
    private CountDownView mCountDown;
    private Handler mMainHandler = null;
    private int mVideoHeight = 0;
    private int mVideoWidth = 0;
    private boolean mIsVideoMute = true;
    private boolean mIsBufferingShown = false;
    private boolean mIsDataSourceSet = false;
    private int mQuartile = 0;
    private CampaignType mCampaignType = CampaignType.CPM;
    private PlayerState mPlayerState = PlayerState.Empty;
    private List<Integer> mProgressTracker = null;
    private double mTargetAspect = -1.0;
    private LifecycleState mLifecycleState;

    public VASTPlayer(Context context) {
        super(context);
        this.mMainHandler = new Handler(this.getContext().getMainLooper());
        this.createLayout();
        this.setEmptyState();
    }

    public VASTPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mMainHandler = new Handler(this.getContext().getMainLooper());
        this.createLayout();
        this.setEmptyState();
    }

    public void setLifecycleState(LifecycleState lifecycleState) {
        this.mLifecycleState = lifecycleState;
    }

    public void mute() {
        if (!this.mIsVideoMute) {
            this.onMuteClick();
        }
    }

    public void unmute() {
        if (this.mIsVideoMute) {
            this.onMuteClick();
        }
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0) {
            throw new IllegalArgumentException();
        }
        Log.d((String)TAG, (String)("Setting aspect ratio to " + aspectRatio + " (was " + this.mTargetAspect + ")"));
        if (this.mTargetAspect != aspectRatio) {
            this.mTargetAspect = aspectRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mTargetAspect > 0.0) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDiff = this.mTargetAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) < 0.01) {
                Log.v((String)TAG, (String)("aspect ratio is good (target=" + this.mTargetAspect + ", view=" + initialWidth + "x" + initialHeight + ")"));
            } else {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mTargetAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mTargetAspect);
                }
                Log.v((String)TAG, (String)("new size=" + initialWidth + "x" + initialHeight + " + padding " + horizPadding + "x" + vertPadding));
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private boolean canSetState(PlayerState playerState) {
        boolean result = false;
        switch (playerState) {
            case Empty: {
                result = true;
                break;
            }
            case Loading: {
                result = true;
                break;
            }
            case Ready: {
                result = PlayerState.Loading == this.mPlayerState;
                break;
            }
            case Playing: {
                result = this.mPlayerState == PlayerState.Ready || this.mPlayerState == PlayerState.Pause;
                result = result && this.mLifecycleState == LifecycleState.OnResume;
                break;
            }
            case Pause: {
                result = true;
            }
        }
        return result;
    }

    private void setState(PlayerState playerState) {
        Log.v((String)TAG, (String)("setState: " + playerState.name()));
        if (this.canSetState(playerState)) {
            switch (playerState) {
                case Empty: {
                    this.setEmptyState();
                    break;
                }
                case Loading: {
                    this.setLoadingState();
                    break;
                }
                case Ready: {
                    this.setReadyState();
                    break;
                }
                case Playing: {
                    this.setPlayingState();
                    break;
                }
                case Pause: {
                    this.setPauseState();
                }
            }
            this.mPlayerState = playerState;
        }
    }

    private void setEmptyState() {
        Log.v((String)TAG, (String)"setEmptyState");
        this.hideSurface();
        this.hidePlayerLayout();
        this.hideOpen();
        this.hideLoader();
        this.stopTimers();
        this.cleanMediaPlayer();
        this.mIsDataSourceSet = false;
        this.mVastModel = null;
        this.mQuartile = 0;
        this.mTrackingEventMap = null;
        this.mProgressTracker = null;
    }

    private void setLoadingState() {
        Log.v((String)TAG, (String)"setLoadingState");
        this.hidePlayerLayout();
        this.showSurface();
        this.showLoader("");
        this.mTrackingEventMap = this.mVastModel.getTrackingUrls();
        this.createMediaPlayer();
        this.turnVolumeOff();
        this.startCaching();
    }

    private void setReadyState() {
        Log.v((String)TAG, (String)"setReadyState");
        this.hideLoader();
        this.hidePlayerLayout();
        this.showOpen();
        this.showSurface();
        this.turnVolumeOff();
    }

    private void setPlayingState() {
        Surface surface;
        Log.v((String)TAG, (String)"setPlayingState");
        this.hideLoader();
        this.showOpen();
        this.showSurface();
        this.showPlayerLayout();
        if (this.mSurface != null && this.mSurface.getHolder() != null && (surface = this.mSurface.getHolder().getSurface()).isValid()) {
            this.mMediaPlayer.setDisplay(this.mSurface.getHolder());
        }
        this.calculateAspectRatio();
        this.refreshVolume();
        this.mMediaPlayer.start();
        this.startTimers();
    }

    private void setPauseState() {
        Log.v((String)TAG, (String)"setPauseState");
        this.hideLoader();
        this.hidePlayerLayout();
        this.showOpen();
        this.showSurface();
        this.turnVolumeOff();
        this.refreshVolume();
    }

    public VASTPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mMainHandler = new Handler(this.getContext().getMainLooper());
        this.createLayout();
        this.setEmptyState();
    }

    public void setListener(Listener listener) {
        Log.v((String)TAG, (String)"setListener");
        this.mListener = listener;
    }

    public void setCampaignType(CampaignType campaignType) {
        Log.v((String)TAG, (String)"setCampaignType");
        this.mCampaignType = campaignType;
    }

    public void setSkip(String name, int delay) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            Log.w((String)TAG, (String)"Skip name set to empty value, this will disable the button");
        } else if (delay < 0) {
            Log.w((String)TAG, (String)"Skip time set to negative value, this will disable the button");
        }
        this.mSkipName = name;
        this.mSkipDelay = delay;
    }

    @Deprecated
    public void setSkipName(String skipName) {
    }

    @Deprecated
    public void setSkipTime(int skipTime) {
    }

    public void load(VASTModel model) {
        VASTLog.v(TAG, "load");
        this.setState(PlayerState.Empty);
        this.mVastModel = model;
        this.mIsDataSourceSet = false;
        this.setState(PlayerState.Loading);
    }

    public void play() {
        VASTLog.v(TAG, "play");
        if (this.canSetState(PlayerState.Playing)) {
            this.setState(PlayerState.Playing);
        } else if (this.mPlayerState == PlayerState.Empty) {
            this.setState(PlayerState.Ready);
        } else {
            VASTLog.e(TAG, "ERROR, player in wrong state: " + this.mPlayerState.name());
        }
    }

    public void stop() {
        VASTLog.v(TAG, "stop");
        if (this.canSetState(PlayerState.Loading) && this.mIsDataSourceSet) {
            this.stopTimers();
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.stop();
                this.mMediaPlayer.reset();
                this.mIsDataSourceSet = false;
            }
            this.setState(PlayerState.Loading);
        } else {
            VASTLog.e(TAG, "ERROR, player in wrong state: " + this.mPlayerState.name());
        }
    }

    public void pause() {
        VASTLog.v(TAG, "pause");
        if (this.canSetState(PlayerState.Pause) && this.mIsDataSourceSet) {
            if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.seekTo(0);
                this.mMediaPlayer.pause();
            }
            this.setState(PlayerState.Pause);
        } else {
            VASTLog.e(TAG, "ERROR, player in wrong state: " + this.mPlayerState.name());
        }
    }

    public void destroy() {
        VASTLog.v(TAG, "clear");
        this.setState(PlayerState.Empty);
    }

    public void onMuteClick() {
        VASTLog.v(TAG, "onMuteClick");
        if (this.mMediaPlayer != null) {
            this.processEvent(this.mIsVideoMute ? TRACKING_EVENTS_TYPE.unmute : TRACKING_EVENTS_TYPE.mute);
            this.mIsVideoMute = !this.mIsVideoMute;
            this.refreshVolume();
        }
    }

    public void onSkipClick() {
        VASTLog.v(TAG, "onSkipClick");
        this.processEvent(TRACKING_EVENTS_TYPE.close);
        this.stop();
    }

    public void onOpenClick() {
        VASTLog.v(TAG, "onOpenClick");
        this.load(this.mVastModel);
        this.openOffer();
    }

    private void openOffer() {
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        VASTLog.d(TAG, "openOffer - clickThrough url: " + clickThroughUrl);
        List<String> urls = this.mVastModel.getVideoClicks().getClickTracking();
        this.fireUrls(urls);
        try {
            Uri uri = Uri.parse((String)clickThroughUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo resolvable = this.getContext().getPackageManager().resolveActivity(intent, 65536);
            if (resolvable == null) {
                VASTLog.e(TAG, "openOffer -clickthrough error occured, uri unresolvable");
                return;
            }
            this.invokeOnPlayerOpenOffer();
            this.getContext().startActivity(intent);
        }
        catch (NullPointerException e) {
            VASTLog.e(TAG, e.getMessage(), e);
        }
    }

    private void createLayout() {
        VASTLog.v(TAG, "createLayout");
        if (this.mRoot == null) {
            this.mRoot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pubnative_player, null);
            this.mPlayer = this.mRoot.findViewById(R.id.player);
            this.mSurface = (SurfaceView)this.mPlayer.findViewById(R.id.surface);
            this.mSurface.getHolder().addCallback(new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    boolean invalidSurface;
                    Log.v((String)TAG, (String)"surfaceCreated");
                    Surface surface = holder.getSurface();
                    if (surface == null) {
                        return;
                    }
                    boolean bl = invalidSurface = !surface.isValid();
                    if (invalidSurface) {
                        return;
                    }
                    VASTPlayer.this.createMediaPlayer();
                    VASTPlayer.this.mMediaPlayer.setDisplay(holder);
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                    Log.v((String)TAG, (String)"surfaceChanged");
                    VASTPlayer.this.calculateAspectRatio();
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    Log.v((String)TAG, (String)"surfaceDestroyed");
                }
            });
            this.mMute = (ImageView)this.mPlayer.findViewById(R.id.mute);
            this.mMute.setVisibility(4);
            this.mMute.setOnClickListener((View.OnClickListener)this);
            this.mCountDown = (CountDownView)this.mPlayer.findViewById(R.id.count_down);
            this.mCountDown.setVisibility(4);
            this.mSkip = (TextView)this.mPlayer.findViewById(R.id.skip);
            this.mSkip.setVisibility(4);
            this.mSkip.setOnClickListener((View.OnClickListener)this);
            this.mLoader = this.mRoot.findViewById(R.id.loader);
            this.mLoaderText = (TextView)this.mRoot.findViewById(R.id.loader_text);
            this.mLoaderText.setVisibility(8);
            this.mOpen = this.mRoot.findViewById(R.id.open);
            this.mOpen.setVisibility(4);
            this.mOpen.setOnClickListener((View.OnClickListener)this);
            this.addView(this.mRoot);
        }
    }

    private void showLoader(String message) {
        if (this.mPlayerState != PlayerState.Pause) {
            this.mLoader.setVisibility(0);
            this.mLoaderText.setText((CharSequence)message);
            this.mLoaderText.setVisibility(TextUtils.isEmpty((CharSequence)message) ? 8 : 0);
        }
    }

    private void hideLoader() {
        this.mLoader.setVisibility(4);
    }

    private void hideOpen() {
        this.mOpen.setVisibility(4);
    }

    private void showOpen() {
        this.mOpen.setVisibility(0);
    }

    private void hideSurface() {
        this.mSurface.setVisibility(4);
    }

    private void showSurface() {
        this.mSurface.setVisibility(0);
    }

    private void hidePlayerLayout() {
        this.mSkip.setVisibility(4);
        this.mMute.setVisibility(4);
        this.mCountDown.setVisibility(4);
    }

    private void showPlayerLayout() {
        this.mSkip.setVisibility(TextUtils.isEmpty((CharSequence)this.mSkipName) ? 4 : 0);
        this.mMute.setVisibility(0);
        this.mCountDown.setVisibility(0);
    }

    private void createMediaPlayer() {
        VASTLog.v(TAG, "createMediaPlayer");
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.mMediaPlayer.setAudioStreamType(3);
        }
    }

    private void cleanMediaPlayer() {
        VASTLog.v(TAG, "cleanUpMediaPlayer");
        if (this.mMediaPlayer != null) {
            this.turnVolumeOff();
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public void refreshVolume() {
        if (this.mIsVideoMute) {
            this.turnVolumeOff();
            this.mMute.setImageResource(R.drawable.pubnative_btn_unmute);
        } else {
            this.turnVolumeOn();
            this.mMute.setImageResource(R.drawable.pubnative_btn_mute);
        }
    }

    public void turnVolumeOff() {
        this.mMediaPlayer.setVolume(0.0f, 0.0f);
    }

    public void turnVolumeOn() {
        this.mMediaPlayer.setVolume(1.0f, 1.0f);
    }

    protected void calculateAspectRatio() {
        VASTLog.v(TAG, "calculateAspectRatio");
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            VASTLog.w(TAG, "calculateAspectRatio - video source width or height is 0, skipping...");
            return;
        }
        double widthRatio = 1.0 * (double)this.getWidth() / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.getHeight() / (double)this.mVideoHeight;
        double scale = Math.max(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        VASTLog.i(TAG, " view size:     " + this.getWidth() + "x" + this.getHeight());
        VASTLog.i(TAG, " video size:    " + this.mVideoWidth + "x" + this.mVideoHeight);
        VASTLog.i(TAG, " surface size:  " + surfaceWidth + "x" + surfaceHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurface.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurface.getHolder().setFixedSize(surfaceWidth, surfaceHeight);
        this.updateLayout();
        this.setAspectRatio((double)this.mVideoWidth / (double)this.mVideoHeight);
    }

    private void updateLayout() {
        VASTLog.v(TAG, "updateLayout");
        RelativeLayout.LayoutParams muteParams = (RelativeLayout.LayoutParams)this.mMute.getLayoutParams();
        muteParams.addRule(6, R.id.surface);
        muteParams.addRule(5, R.id.surface);
        this.mMute.setLayoutParams((ViewGroup.LayoutParams)muteParams);
        RelativeLayout.LayoutParams openParams = (RelativeLayout.LayoutParams)this.mOpen.getLayoutParams();
        openParams.addRule(6, R.id.surface);
        openParams.addRule(7, R.id.surface);
        this.mOpen.setLayoutParams((ViewGroup.LayoutParams)openParams);
        RelativeLayout.LayoutParams countDownParams = (RelativeLayout.LayoutParams)this.mCountDown.getLayoutParams();
        countDownParams.addRule(8, R.id.surface);
        countDownParams.addRule(5, R.id.surface);
        this.mCountDown.setLayoutParams((ViewGroup.LayoutParams)countDownParams);
        RelativeLayout.LayoutParams skipParams = (RelativeLayout.LayoutParams)this.mSkip.getLayoutParams();
        skipParams.addRule(8, R.id.surface);
        skipParams.addRule(7, R.id.surface);
        this.mSkip.setLayoutParams((ViewGroup.LayoutParams)skipParams);
    }

    private void startCaching() {
        VASTLog.v(TAG, "startCaching");
        try {
            if (!this.mIsDataSourceSet) {
                this.mIsDataSourceSet = true;
                String videoURL = this.mVastModel.getPickedMediaFileURL();
                File cachedFile = CacheManager.get(this.getContext(), videoURL);
                if (cachedFile == null) {
                    this.mMediaPlayer.setDataSource(videoURL);
                } else {
                    this.mMediaPlayer.setDataSource(cachedFile.getAbsolutePath());
                }
            }
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)"Failed to set video source", (Throwable)exception);
            this.invokeOnFail(exception);
            this.destroy();
        }
    }

    private void processEvent(TRACKING_EVENTS_TYPE eventName) {
        VASTLog.v(TAG, "processEvent: " + (Object)((Object)eventName));
        if (this.mTrackingEventMap != null) {
            List<String> urls = this.mTrackingEventMap.get((Object)eventName);
            this.fireUrls(urls);
        }
    }

    private void processImpressions() {
        VASTLog.v(TAG, "processImpressions");
        List<String> impressions = this.mVastModel.getImpressions();
        this.fireUrls(impressions);
    }

    private void processErrorEvent() {
        VASTLog.v(TAG, "processErrorEvent");
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    private void fireUrls(List<String> urls) {
        VASTLog.v(TAG, "fireUrls");
        if (urls != null) {
            for (String url : urls) {
                VASTLog.v(TAG, "\tfiring url:" + url);
                HttpTools.httpGetURL(url);
            }
        } else {
            VASTLog.d(TAG, "\turl list is null");
        }
    }

    private void stopTimers() {
        VASTLog.v(TAG, "stopTimers");
        this.stopQuartileTimer();
        this.stopLayoutTimer();
        this.stopVideoProgressTimer();
        this.mMainHandler.removeMessages(0);
    }

    private void startTimers() {
        VASTLog.v(TAG, "startTimers");
        this.stopTimers();
        this.startQuartileTimer();
        this.startLayoutTimer();
        this.startVideoProgressTimer();
    }

    private void startVideoProgressTimer() {
        VASTLog.d(TAG, "startVideoProgressTimer");
        this.mProgressTimer = new Timer();
        this.mProgressTracker = new ArrayList<Integer>();
        this.mProgressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (VASTPlayer.this.mProgressTracker.size() > 20) {
                    int firstPosition = (Integer)VASTPlayer.this.mProgressTracker.get(0);
                    int lastPosition = (Integer)VASTPlayer.this.mProgressTracker.get(VASTPlayer.this.mProgressTracker.size() - 1);
                    if (lastPosition > firstPosition) {
                        if (VASTPlayer.this.mIsBufferingShown) {
                            VASTPlayer.this.mIsBufferingShown = false;
                            VASTPlayer.this.mMainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    VASTPlayer.this.hideLoader();
                                }
                            });
                        }
                    } else if (!VASTPlayer.this.mIsBufferingShown) {
                        VASTPlayer.this.mIsBufferingShown = true;
                        VASTPlayer.this.mMainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                VASTPlayer.this.showLoader(VASTPlayer.TEXT_BUFFERING);
                            }
                        });
                    }
                    VASTPlayer.this.mProgressTracker.remove(0);
                }
                VASTPlayer.this.mProgressTracker.add(VASTPlayer.this.mMediaPlayer.getCurrentPosition());
            }
        }, 0L, 50L);
    }

    private void stopVideoProgressTimer() {
        VASTLog.d(TAG, "stopVideoProgressTimer");
        if (this.mProgressTimer != null) {
            this.mProgressTimer.cancel();
            this.mProgressTimer = null;
        }
    }

    private void startQuartileTimer() {
        VASTLog.v(TAG, "startQuartileTimer");
        this.mQuartile = 0;
        this.mTrackingEventsTimer = new Timer();
        this.mTrackingEventsTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int percentage = 0;
                try {
                    if (VASTPlayer.this.mMediaPlayer.getCurrentPosition() == 0) {
                        return;
                    }
                    percentage = 100 * VASTPlayer.this.mMediaPlayer.getCurrentPosition() / VASTPlayer.this.mMediaPlayer.getDuration();
                }
                catch (Exception e) {
                    VASTLog.e(TAG, "QuartileTimer error: " + e.getMessage());
                    this.cancel();
                    return;
                }
                if (percentage >= 25 * VASTPlayer.this.mQuartile) {
                    if (VASTPlayer.this.mQuartile == 0) {
                        VASTLog.i(TAG, "Video at start: (" + percentage + "%)");
                        VASTPlayer.this.processImpressions();
                        VASTPlayer.this.processEvent(TRACKING_EVENTS_TYPE.start);
                        VASTPlayer.this.invokeOnPlayerPlaybackStart();
                    } else if (VASTPlayer.this.mQuartile == 1) {
                        VASTLog.i(TAG, "Video at first quartile: (" + percentage + "%)");
                        VASTPlayer.this.processEvent(TRACKING_EVENTS_TYPE.firstQuartile);
                    } else if (VASTPlayer.this.mQuartile == 2) {
                        VASTLog.i(TAG, "Video at midpoint: (" + percentage + "%)");
                        VASTPlayer.this.processEvent(TRACKING_EVENTS_TYPE.midpoint);
                    } else if (VASTPlayer.this.mQuartile == 3) {
                        VASTLog.i(TAG, "Video at third quartile: (" + percentage + "%)");
                        VASTPlayer.this.processEvent(TRACKING_EVENTS_TYPE.thirdQuartile);
                        VASTPlayer.this.stopQuartileTimer();
                    }
                    VASTPlayer.this.mQuartile++;
                }
            }
        }, 0L, 250L);
    }

    private void stopQuartileTimer() {
        VASTLog.v(TAG, "stopQuartileTimer");
        if (this.mTrackingEventsTimer != null) {
            this.mTrackingEventsTimer.cancel();
            this.mTrackingEventsTimer = null;
        }
    }

    private void startLayoutTimer() {
        VASTLog.v(TAG, "startLayoutTimer");
        this.mLayoutTimer = new Timer();
        this.mLayoutTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (VASTPlayer.this.mMediaPlayer == null) {
                    this.cancel();
                    return;
                }
                VASTPlayer.this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (VASTPlayer.this.mMediaPlayer != null && VASTPlayer.this.mMediaPlayer.isPlaying()) {
                                int currentPosition = VASTPlayer.this.mMediaPlayer.getCurrentPosition();
                                VASTPlayer.this.mCountDown.setProgress(currentPosition, VASTPlayer.this.mMediaPlayer.getDuration());
                                if (!TextUtils.isEmpty((CharSequence)VASTPlayer.this.mSkipName) && VASTPlayer.this.mSkipDelay > currentPosition) {
                                    VASTPlayer.this.mSkip.setText((CharSequence)VASTPlayer.this.mSkipName);
                                    VASTPlayer.this.mSkip.setVisibility(0);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)("Layout timer error: " + e));
                            this.cancel();
                            return;
                        }
                    }
                });
            }
        }, 0L, 50L);
    }

    private void stopLayoutTimer() {
        VASTLog.d(TAG, "stopLayoutTimer");
        if (this.mLayoutTimer != null) {
            this.mLayoutTimer.cancel();
            this.mLayoutTimer = null;
        }
    }

    private void invokeOnPlayerOpenOffer() {
        VASTLog.v(TAG, "invokeOnPlayerClick");
        if (this.mListener != null) {
            this.mListener.onVASTPlayerOpenOffer();
        }
    }

    private void invokeOnPlayerLoadFinish() {
        VASTLog.v(TAG, "invokeOnPlayerLoadFinish");
        if (this.mListener != null) {
            this.mListener.onVASTPlayerLoadFinish();
        }
    }

    private void invokeOnFail(Exception exception) {
        VASTLog.v(TAG, "invokeOnFail");
        if (this.mListener != null) {
            this.mListener.onVASTPlayerFail(exception);
        }
    }

    private void invokeOnPlayerPlaybackStart() {
        VASTLog.v(TAG, "invokeOnPlayerPlaybackStart");
        if (this.mListener != null) {
            this.mListener.onVASTPlayerPlaybackStart();
        }
    }

    private void invokeOnPlayerPlaybackFinish() {
        VASTLog.v(TAG, "invokeOnPlayerPlaybackFinish");
        if (this.mListener != null) {
            this.mListener.onVASTPlayerPlaybackFinish();
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        VASTLog.v(TAG, "onCompletion -- (MediaPlayer callback)");
        if (this.mQuartile > 3) {
            this.processEvent(TRACKING_EVENTS_TYPE.complete);
            this.invokeOnPlayerPlaybackFinish();
        }
        this.stop();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        String exceptionMessage;
        VASTLog.v(TAG, "onError -- (MediaPlayer callback)");
        this.processErrorEvent();
        switch (what) {
            case 100: {
                exceptionMessage = "server died: ";
                break;
            }
            default: {
                exceptionMessage = "unknown: ";
            }
        }
        switch (extra) {
            case -1004: {
                exceptionMessage = exceptionMessage + "MEDIA_ERROR_IO";
                break;
            }
            case -1007: {
                exceptionMessage = exceptionMessage + "MEDIA_ERROR_MALFORMED";
                break;
            }
            case -1010: {
                exceptionMessage = exceptionMessage + "MEDIA_ERROR_UNSUPPORTED";
                break;
            }
            case -110: {
                exceptionMessage = exceptionMessage + "MEDIA_ERROR_TIMED_OUT";
                break;
            }
            default: {
                exceptionMessage = exceptionMessage + "low-level system error";
            }
        }
        this.invokeOnFail(new Exception("VASTPlayer error: " + exceptionMessage));
        this.destroy();
        return true;
    }

    public void onPrepared(MediaPlayer mp) {
        VASTLog.v(TAG, "onPrepared --(MediaPlayer callback) ....about to play");
        this.setState(PlayerState.Ready);
        this.invokeOnPlayerLoadFinish();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        VASTLog.v(TAG, "onVideoSizeChanged -- " + width + " x " + height);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public void onClick(View view) {
        VASTLog.v(TAG, "onClick -- (View.OnClickListener callback)");
        if (this.mOpen == view) {
            this.onOpenClick();
        } else if (this.mSkip == view) {
            this.onSkipClick();
        } else if (this.mMute == view) {
            this.onMuteClick();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Log.v((String)TAG, (String)"onSizeChanged");
        super.onSizeChanged(w, h, oldw, oldh);
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                VASTPlayer.this.calculateAspectRatio();
            }
        });
    }

    private static enum PlayerState {
        Empty,
        Loading,
        Ready,
        Playing,
        Pause;

    }

    public static enum LifecycleState {
        OnResume,
        OnPause;

    }

    public static interface Listener {
        public void onVASTPlayerLoadFinish();

        public void onVASTPlayerFail(Exception var1);

        public void onVASTPlayerPlaybackStart();

        public void onVASTPlayerPlaybackFinish();

        public void onVASTPlayerOpenOffer();
    }

    public static enum CampaignType {
        CPC,
        CPM;

    }
}

