/*
 * Decompiled with CFR 0.152.
 */
package com.agik.swipe_button.View;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.agik.swipe_button.Controller.OnSwipeCompleteListener;
import com.agik.swipe_button.Controller.Swipe_Button_Controller;
import com.agik.swipe_button.R;
import com.agik.swipe_button.Util.Dimension_Util;
import com.agik.swipe_button.Util.Drawable_Color_Util;

public class Swipe_Button_View
extends RelativeLayout
implements SeekBar.OnSeekBarChangeListener {
    protected Swipe_Button_Controller swipe_button_controller;
    protected Drawable swipe_bg_drawable;
    protected Drawable thumb_bg_drawable;
    protected Drawable thumbImage;
    protected TextView swipeTextView;
    protected LayerDrawable swipeLayers;
    protected int strokeColor;
    public boolean swipe_reverse = false;
    public boolean swipe_both_direction = false;
    protected float swipeTextSize = Dimension_Util.spToPx(16, this.getContext());
    protected String swipeText;
    protected ColorStateList swipeTextColor;
    protected boolean animateSwipeText;
    protected int ThumbImageId;
    protected int swipe_thumb_bg_color;
    protected int swipe_bg_color;

    public Swipe_Button_View(Context context) {
        super(context);
        this.set_default(null, 0);
    }

    public Swipe_Button_View(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.set_default(attrs, 0);
    }

    public Swipe_Button_View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.set_default(attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public Swipe_Button_View(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.set_default(attrs, defStyleAttr);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (this.animateSwipeText) {
            this.swipeTextView.setAlpha(1.0f - (float)progress / 100.0f);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_default(AttributeSet attrs, int defStyle) {
        Swipe_Button_View.inflate((Context)this.getContext(), (int)R.layout.sb_swipe_view, (ViewGroup)this);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sb_swipe_view_bg));
        } else {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sb_swipe_view_bg));
        }
        this.swipeTextView = (TextView)this.findViewById(R.id.sb_text);
        this.swipe_button_controller = (Swipe_Button_Controller)this.findViewById(R.id.sb_swipe);
        this.swipe_button_controller.setOnSeekBarChangeListener(this);
        this.swipe_bg_drawable = this.getBackground();
        this.swipeLayers = (LayerDrawable)this.swipe_button_controller.getThumb();
        this.thumb_bg_drawable = this.swipeLayers.findDrawableByLayerId(R.id.thumb_background);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeButtonView, defStyle, defStyle);
        try {
            this.getAttributes(attributes);
        }
        finally {
            attributes.recycle();
        }
    }

    private void getAttributes(TypedArray attributes) {
        this.swipe_reverse = attributes.getBoolean(R.styleable.SwipeButtonView_sb_swipe_reverse, false);
        this.swipe_both_direction = attributes.getBoolean(R.styleable.SwipeButtonView_sb_swipe_both_direction, false);
        this.swipeText = attributes.getString(R.styleable.SwipeButtonView_sb_swipe_text);
        this.swipeTextColor = attributes.getColorStateList(R.styleable.SwipeButtonView_sb_swipe_text_color);
        this.animateSwipeText = attributes.getBoolean(R.styleable.SwipeButtonView_sb_swipe_animate_text, true);
        this.swipeTextSize = attributes.getDimension(R.styleable.SwipeButtonView_sb_swipe_text_size, this.swipeTextSize);
        this.swipeTextView.setTextSize(0, this.swipeTextSize);
        this.setText(this.swipeText);
        this.setTextColor(this.swipeTextColor == null ? this.swipeTextView.getTextColors() : this.swipeTextColor);
        this.ThumbImageId = attributes.getResourceId(R.styleable.SwipeButtonView_sb_thumb_image, R.drawable.ic_forward);
        this.setThumbImage(ContextCompat.getDrawable((Context)this.getContext(), (int)this.ThumbImageId));
        this.swipe_thumb_bg_color = attributes.getColor(R.styleable.SwipeButtonView_sb_thumb_bg_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sb_thumb_button_color_default));
        this.setThumbBackgroundColor(this.swipe_thumb_bg_color);
        this.swipe_bg_color = attributes.getColor(R.styleable.SwipeButtonView_sb_swipe_bg_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sb_swipe_bg_color_default));
        this.setSwipeBackgroundColor(this.swipe_bg_color);
        this.strokeColor = attributes.getColor(R.styleable.SwipeButtonView_sb_stroke_bg_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.sb_stroke_color_default));
        if (attributes.hasValue(R.styleable.SwipeButtonView_sb_stroke_bg_color)) {
            Drawable_Color_Util.setDrawableStroke(this.swipe_bg_drawable, this.strokeColor);
        }
        if (this.swipe_reverse) {
            this.setreverse_180();
        }
    }

    public void setreverse_180() {
        this.swipe_button_controller.setRotation(180.0f);
        this.set_text_position();
    }

    public void setreverse_0() {
        this.swipe_button_controller.setRotation(0.0f);
        this.set_text_position();
    }

    private void set_text_position() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.swipeTextView.getLayoutParams();
        params.addRule(11, 0);
        params.addRule(9);
        if (Build.VERSION.SDK_INT >= 17) {
            params.addRule(21, 0);
            params.addRule(20);
        }
        this.swipeTextView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setTextColor(@ColorInt int color2) {
        this.swipeTextView.setTextColor(color2);
    }

    public void setTextColor(ColorStateList colors) {
        this.swipeTextView.setTextColor(colors);
    }

    public void setText(CharSequence text) {
        this.swipeTextView.setText(text);
    }

    public void setTextSize(int size) {
        this.swipeTextView.setTextSize((float)size);
    }

    public TextView getTextView() {
        return this.swipeTextView;
    }

    public void setThumbImage(Drawable image) {
        this.swipeLayers.setDrawableByLayerId(R.id.thumb_image, image);
    }

    public void setThumbBackgroundColor(int color2) {
        Drawable_Color_Util.setDrawableColor(this.thumb_bg_drawable, color2);
    }

    public void setSwipeBackgroundColor(int color2) {
        Drawable_Color_Util.setDrawableColor(this.swipe_bg_drawable, color2);
    }

    public Swipe_Button_Controller getSlider() {
        return this.swipe_button_controller;
    }

    public void setOnSwipeCompleteListener_forward_reverse(OnSwipeCompleteListener listener_forward_reverse) {
        this.swipe_button_controller.setOnSwipeCompleteListener_forward_reverse(listener_forward_reverse, this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setEnabled(enabled);
        }
        this.swipeLayers.setDrawableByLayerId(R.id.thumb_image, ContextCompat.getDrawable((Context)this.getContext(), (int)this.ThumbImageId));
        Drawable_Color_Util.setDrawableColor(this.thumb_bg_drawable, this.swipe_thumb_bg_color);
        Drawable_Color_Util.setDrawableColor(this.swipe_bg_drawable, this.swipe_bg_color);
    }
}

