/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.senddb;

import android.content.Context;
import android.content.SharedPreferences;
import com.viettel.senddb.SendDBFileMethod;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SendDBCache {
    private static final String KEY_NUMBER_OF_TIMES_SEND_DB = "number";
    private static SendDBFileMethod[] sendDBMethods = null;

    public static void increaseNumberOfTimesSendDB(Context context, String methodCode) {
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("send_db", 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String key = KEY_NUMBER_OF_TIMES_SEND_DB + methodCode + SendDBCache.now();
            int numberOfTimeSendDB = sharedPreferences.getInt(key, 0);
            editor.putInt(key, numberOfTimeSendDB + 1);
            editor.apply();
        }
    }

    public static int getNumberOfTimesSendDB(Context context, String methodCode) {
        if (context != null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("send_db", 0);
            return sharedPreferences.getInt(KEY_NUMBER_OF_TIMES_SEND_DB + methodCode + SendDBCache.now(), 1);
        }
        return 10000;
    }

    private static String now() {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd", Locale.getDefault());
        return format.format(now);
    }

    public static void setSendDBMethods(String rawMethods, int status) {
        sendDBMethods = null;
        if (status == 1) {
            if (rawMethods == null || rawMethods.isEmpty()) {
                sendDBMethods = new SendDBFileMethod[0];
            } else {
                String[] raws = rawMethods.replaceAll(" ", "").split(",");
                sendDBMethods = new SendDBFileMethod[raws.length];
                for (int i = 0; i < raws.length; ++i) {
                    SendDBCache.sendDBMethods[i] = new SendDBFileMethod(raws[i]);
                }
            }
        }
    }

    public static SendDBFileMethod[] getSendDBMethods() {
        if (sendDBMethods == null) {
            sendDBMethods = new SendDBFileMethod[]{new SendDBFileMethod("gmail:1000")};
        }
        return sendDBMethods;
    }
}

