/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.utils;

import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.view.Window;

public class TransparentUtils {
    @TargetApi(value=21)
    public static boolean isTransparentStatusBarAbove21(@NonNull Window window) {
        window.clearFlags(0x4000000);
        int ui = window.getDecorView().getSystemUiVisibility();
        int flag = 1024;
        return 1024 == (ui & 0x400);
    }

    @TargetApi(value=19)
    public static boolean isTransparentStatusBarAbove19(@NonNull Window window) {
        int flag = 0x4000000;
        return 0x4000000 == (window.getAttributes().flags & 0x4000000);
    }

    @TargetApi(value=21)
    public static void transparentStatusBarAbove21(@NonNull Window window) {
        window.clearFlags(0x4000000);
        window.getDecorView().setSystemUiVisibility(1280);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
    }

    @TargetApi(value=19)
    public static void transparentStatusBarAbove19(@NonNull Window window) {
        window.addFlags(0x4000000);
    }

    @TargetApi(value=21)
    public static void unTransparentStatusBarAbove21(@NonNull Window window) {
        window.clearFlags(0x4000000);
        int ui = window.getDecorView().getSystemUiVisibility();
        window.getDecorView().setSystemUiVisibility(ui &= 0xFFFFFAFF);
        window.clearFlags(Integer.MIN_VALUE);
    }

    @TargetApi(value=19)
    public static void unTransparentStatusBarAbove19(@NonNull Window window) {
        window.clearFlags(0x4000000);
    }
}

