/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.utils;

import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class OsUtils {
    private static final String ROM_MIUI = "MIUI";
    private static final String ROM_EMUI = "EMUI";
    private static final String ROM_FLYME = "FLYME";
    private static final String ROM_OPPO = "OPPO";
    private static final String ROM_SMARTISAN = "SMARTISAN";
    private static final String ROM_VIVO = "VIVO";
    private static final String ROM_QIKU = "QIKU";
    private static final String KEY_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";
    private static final String KEY_VERSION_OPPO = "ro.build.version.opporom";
    private static final String KEY_VERSION_SMARTISAN = "ro.smartisan.version";
    private static final String KEY_VERSION_VIVO = "ro.vivo.os.version";
    private static String sName;
    private static String sVersion;

    public static boolean isEmui() {
        return OsUtils.check(ROM_EMUI);
    }

    public static boolean isMiui() {
        return OsUtils.check(ROM_MIUI);
    }

    public static boolean isVivo() {
        return OsUtils.check(ROM_VIVO);
    }

    public static boolean isOppo() {
        return OsUtils.check(ROM_OPPO);
    }

    public static boolean isFlyme() {
        return OsUtils.check(ROM_FLYME);
    }

    public static boolean is360() {
        return OsUtils.check(ROM_QIKU) || OsUtils.check("360");
    }

    public static boolean isSmartisan() {
        return OsUtils.check(ROM_SMARTISAN);
    }

    public static String getName() {
        if (sName == null) {
            OsUtils.check("");
        }
        return sName;
    }

    public static String getVersion() {
        if (sVersion == null) {
            OsUtils.check("");
        }
        return sVersion;
    }

    private static boolean check(String rom) {
        if (sName != null) {
            return sName.equals(rom);
        }
        sVersion = OsUtils.getProp(KEY_VERSION_MIUI);
        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
            sName = ROM_MIUI;
        } else {
            sVersion = OsUtils.getProp(KEY_VERSION_EMUI);
            if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                sName = ROM_EMUI;
            } else {
                sVersion = OsUtils.getProp(KEY_VERSION_OPPO);
                if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                    sName = ROM_OPPO;
                } else {
                    sVersion = OsUtils.getProp(KEY_VERSION_VIVO);
                    if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                        sName = ROM_VIVO;
                    } else {
                        sVersion = OsUtils.getProp(KEY_VERSION_SMARTISAN);
                        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                            sName = ROM_SMARTISAN;
                        } else {
                            sVersion = Build.DISPLAY;
                            if (sVersion.toUpperCase().contains(ROM_FLYME)) {
                                sName = ROM_FLYME;
                            } else {
                                sVersion = "unknown";
                                sName = Build.MANUFACTURER.toUpperCase();
                            }
                        }
                    }
                }
            }
        }
        return sName.equals(rom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProp(String name) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + name);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }
}

