/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import per.goweii.statusbarcompat.OsCompatHolder;
import per.goweii.statusbarcompat.utils.ContextUtils;
import per.goweii.statusbarcompat.utils.LuminanceUtils;
import per.goweii.statusbarcompat.utils.TransparentUtils;

public class StatusBarCompat {
    public static int getHeight(@NonNull Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        try {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void setColor(@NonNull Fragment fragment, @ColorInt int color) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        StatusBarCompat.setColor((Activity)activity, color);
    }

    public static void setColor(@NonNull Context context, @ColorInt int color) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        StatusBarCompat.setColor(activity, color);
    }

    public static void setColor(@NonNull Activity activity, @ColorInt int color) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        StatusBarCompat.setColor(window, color);
    }

    public static void setColor(@NonNull Window window, @ColorInt int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color);
        }
    }

    public static boolean isBgLight(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return false;
        }
        return StatusBarCompat.isBgLight((Activity)activity);
    }

    public static boolean isBgLight(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return false;
        }
        return StatusBarCompat.isBgLight(activity);
    }

    public static boolean isBgLight(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return false;
        }
        return StatusBarCompat.isBgLight(window);
    }

    public static boolean isBgLight(@NonNull Window window) {
        return LuminanceUtils.isLight(StatusBarCompat.calcBgLuminance(window));
    }

    public static double calcBgLuminance(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return 0.0;
        }
        return StatusBarCompat.calcBgLuminance((Activity)activity);
    }

    public static double calcBgLuminance(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return 0.0;
        }
        return StatusBarCompat.calcBgLuminance(activity);
    }

    public static double calcBgLuminance(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return 0.0;
        }
        return StatusBarCompat.calcBgLuminance(window);
    }

    public static double calcBgLuminance(@NonNull Window window) {
        if (StatusBarCompat.isTransparent(window)) {
            return LuminanceUtils.calcLuminanceByCapture(window);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return LuminanceUtils.calcLuminance(window.getStatusBarColor());
        }
        return 0.0;
    }

    public static boolean isIconDark(@NonNull Fragment fragment) {
        return OsCompatHolder.get().isDarkIconMode(fragment);
    }

    public static boolean isIconDark(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return false;
        }
        return OsCompatHolder.get().isDarkIconMode(activity);
    }

    public static boolean isIconDark(@NonNull Activity activity) {
        return OsCompatHolder.get().isDarkIconMode(activity);
    }

    public static boolean isIconDark(@NonNull Window window) {
        return OsCompatHolder.get().isDarkIconMode(window);
    }

    public static void registerToAutoChangeIconMode(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        StatusBarCompat.registerToAutoChangeIconMode((Activity)activity);
    }

    public static void registerToAutoChangeIconMode(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        StatusBarCompat.registerToAutoChangeIconMode(activity);
    }

    public static void registerToAutoChangeIconMode(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        StatusBarCompat.registerToAutoChangeIconMode(window);
    }

    public static void registerToAutoChangeIconMode(final @NonNull Window window) {
        ViewTreeObserver.OnPreDrawListener onPreDrawListener;
        final View decorView = window.getDecorView();
        Object tag = decorView.getTag();
        if (tag instanceof ViewTreeObserver.OnPreDrawListener) {
            onPreDrawListener = (ViewTreeObserver.OnPreDrawListener)tag;
            decorView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
            decorView.setTag(null);
        }
        onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                StatusBarCompat.setIconModeAuto(window);
                return true;
            }
        };
        decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                decorView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                decorView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
            }
        });
        decorView.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);
        decorView.setTag((Object)onPreDrawListener);
    }

    public static void unregisterToAutoChangeIconMode(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        StatusBarCompat.unregisterToAutoChangeIconMode((Activity)activity);
    }

    public static void unregisterToAutoChangeIconMode(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        StatusBarCompat.unregisterToAutoChangeIconMode(activity);
    }

    public static void unregisterToAutoChangeIconMode(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        StatusBarCompat.unregisterToAutoChangeIconMode(window);
    }

    public static void unregisterToAutoChangeIconMode(@NonNull Window window) {
        View decorView = window.getDecorView();
        Object tag = decorView.getTag();
        if (tag instanceof ViewTreeObserver.OnPreDrawListener) {
            ViewTreeObserver.OnPreDrawListener onPreDrawListener = (ViewTreeObserver.OnPreDrawListener)tag;
            decorView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
            decorView.setTag(null);
        }
    }

    public static void setIconModeAuto(@NonNull Fragment fragment) {
        StatusBarCompat.setIconMode(fragment, StatusBarCompat.isBgLight(fragment));
    }

    public static void setIconModeAuto(@NonNull Context context) {
        StatusBarCompat.setIconMode(context, StatusBarCompat.isBgLight(context));
    }

    public static void setIconModeAuto(@NonNull Activity activity) {
        StatusBarCompat.setIconMode(activity, StatusBarCompat.isBgLight(activity));
    }

    public static void setIconModeAuto(@NonNull Window window) {
        StatusBarCompat.setIconMode(window, StatusBarCompat.isBgLight(window));
    }

    public static void setIconMode(@NonNull Fragment fragment, boolean darkIconMode) {
        OsCompatHolder.get().setDarkIconMode(fragment, darkIconMode);
    }

    public static void setIconMode(@NonNull Context context, boolean darkIconMode) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        OsCompatHolder.get().setDarkIconMode(activity, darkIconMode);
    }

    public static void setIconMode(@NonNull Activity activity, boolean darkIconMode) {
        OsCompatHolder.get().setDarkIconMode(activity, darkIconMode);
    }

    public static void setIconMode(@NonNull Window window, boolean darkIconMode) {
        OsCompatHolder.get().setDarkIconMode(window, darkIconMode);
    }

    public static void setIconDark(@NonNull Fragment fragment) {
        StatusBarCompat.setIconMode(fragment, true);
    }

    public static void setIconDark(@NonNull Context context) {
        StatusBarCompat.setIconMode(context, true);
    }

    public static void setIconDark(@NonNull Activity activity) {
        StatusBarCompat.setIconMode(activity, true);
    }

    public static void setIconDark(@NonNull Window window) {
        StatusBarCompat.setIconMode(window, true);
    }

    public static void setIconLight(@NonNull Fragment fragment) {
        StatusBarCompat.setIconMode(fragment, false);
    }

    public static void setIconLight(@NonNull Context context) {
        StatusBarCompat.setIconMode(context, false);
    }

    public static void setIconLight(@NonNull Activity activity) {
        StatusBarCompat.setIconMode(activity, false);
    }

    public static void setIconLight(@NonNull Window window) {
        StatusBarCompat.setIconMode(window, false);
    }

    public static boolean isTransparent(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return false;
        }
        return StatusBarCompat.isTransparent((Activity)activity);
    }

    public static boolean isTransparent(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return false;
        }
        return StatusBarCompat.isTransparent(activity);
    }

    public static boolean isTransparent(@NonNull Activity activity) {
        return StatusBarCompat.isTransparent(activity.getWindow());
    }

    public static boolean isTransparent(@NonNull Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            return TransparentUtils.isTransparentStatusBarAbove21(window);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return TransparentUtils.isTransparentStatusBarAbove19(window);
        }
        return false;
    }

    public static void transparent(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        StatusBarCompat.transparent((Activity)activity);
    }

    public static void transparent(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        StatusBarCompat.transparent(activity);
    }

    public static void transparent(@NonNull Activity activity) {
        StatusBarCompat.transparent(activity.getWindow());
    }

    public static void transparent(@NonNull Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            TransparentUtils.transparentStatusBarAbove21(window);
        } else if (Build.VERSION.SDK_INT >= 19) {
            TransparentUtils.transparentStatusBarAbove19(window);
        }
    }

    public static void unTransparent(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        StatusBarCompat.unTransparent((Activity)activity);
    }

    public static void unTransparent(@NonNull Context context) {
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return;
        }
        StatusBarCompat.unTransparent(activity);
    }

    public static void unTransparent(@NonNull Activity activity) {
        StatusBarCompat.unTransparent(activity.getWindow());
    }

    public static void unTransparent(@NonNull Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            TransparentUtils.unTransparentStatusBarAbove21(window);
        } else if (Build.VERSION.SDK_INT >= 19) {
            TransparentUtils.unTransparentStatusBarAbove19(window);
        }
    }
}

