/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.burred;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

class Utils {
    Utils() {
    }

    static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    static <T> T requireNonNull(T obj) {
        return Utils.requireNonNull(obj, "");
    }

    static Bitmap snapshot(View view, float scale) {
        return Utils.snapshot(view, 0, scale);
    }

    static Bitmap snapshot(View view, int bgColor) {
        return Utils.snapshot(view, bgColor, 1.0f);
    }

    static Bitmap snapshot(View view, int bgColor, float scale) {
        return Utils.snapshot(view, bgColor, 0, scale);
    }

    static Bitmap snapshot(View from, int bgColor, int fgColor, float scale) {
        float newScale = scale > 0.0f ? scale : 1.0f;
        int w = (int)((float)from.getWidth() * newScale);
        int h = (int)((float)from.getHeight() * newScale);
        Bitmap output = Bitmap.createBitmap((int)(w <= 0 ? 1 : w), (int)(h <= 0 ? 1 : h), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.save();
        canvas.scale(newScale, newScale);
        if (bgColor != 0) {
            canvas.drawColor(bgColor);
        }
        from.draw(canvas);
        if (fgColor != 0) {
            canvas.drawColor(fgColor);
        }
        canvas.restore();
        return output;
    }

    static Bitmap clip(Bitmap bitmap, View from, ImageView into) {
        int[] lf = new int[2];
        from.getLocationOnScreen(lf);
        int[] lt = new int[2];
        into.getLocationOnScreen(lt);
        int bw = bitmap.getWidth();
        int bh = bitmap.getHeight();
        float sx = (float)bw / (float)from.getWidth();
        float sh = (float)bh / (float)from.getHeight();
        Bitmap output = Bitmap.createBitmap((int)into.getWidth(), (int)into.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Rect rf = new Rect((int)((float)(lt[0] - lf[0]) * sx), (int)((float)(lt[1] - lf[1]) * sh), (int)((float)(lt[0] - lf[0]) * sx + (float)into.getWidth() * sx), (int)((float)(lt[1] - lf[1]) * sh + (float)into.getHeight() * sh));
        Rect rt = new Rect(0, 0, into.getWidth(), into.getHeight());
        canvas.drawBitmap(bitmap, rf, rt, null);
        return output;
    }

    private static void draw(Canvas canvas, View from, ImageView into) throws StopDrawException {
        if (into == null) {
            from.draw(canvas);
        }
        if (from == into) {
            throw new StopDrawException();
        }
        if (from instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)from;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View view = viewGroup.getChildAt(i);
                Utils.draw(canvas, view, into);
            }
        } else {
            from.draw(canvas);
        }
    }

    static Bitmap scaleBitmap(Bitmap bitmap, float scale) {
        int iw = bitmap.getWidth();
        int ih = bitmap.getHeight();
        int ow = (int)((float)iw * scale);
        int oh = (int)((float)ih * scale);
        return Utils.scaleBitmap(bitmap, ow, oh);
    }

    static Bitmap scaleBitmap(Bitmap bitmap, int w, int h) {
        Bitmap.Config newConfig;
        Bitmap.Config config = bitmap.getConfig();
        switch (config) {
            case RGB_565: {
                newConfig = Bitmap.Config.RGB_565;
                break;
            }
            case ALPHA_8: {
                newConfig = Bitmap.Config.ALPHA_8;
                break;
            }
            default: {
                newConfig = Bitmap.Config.ARGB_8888;
            }
        }
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)newConfig);
        Canvas canvas = new Canvas(output);
        canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(0, 0, w, h), null);
        return output;
    }

    private static class StopDrawException
    extends Exception {
        private StopDrawException() {
        }
    }
}

