/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.burred;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import per.goweii.burred.IBlur;
import per.goweii.burred.Utils;

public final class GaussianBlur
implements IBlur {
    private static GaussianBlur INSTANCE = null;
    private boolean mRealTimeMode = false;
    private final RenderScript renderScript;
    private final ScriptIntrinsicBlur gaussianBlur;
    private Allocation mInput = null;
    private Allocation mOutput = null;

    private GaussianBlur(Context context) {
        Utils.requireNonNull(context);
        if (Build.VERSION.SDK_INT < 17) {
            throw new RuntimeException("Call requires API level 17 (current min is " + Build.VERSION.SDK_INT + ")");
        }
        this.renderScript = RenderScript.create((Context)context.getApplicationContext());
        this.gaussianBlur = ScriptIntrinsicBlur.create((RenderScript)this.renderScript, (Element)Element.U8_4((RenderScript)this.renderScript));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GaussianBlur get(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<GaussianBlur> clazz = GaussianBlur.class;
        synchronized (GaussianBlur.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GaussianBlur(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public GaussianBlur realTimeMode(boolean realTimeMode) {
        this.mRealTimeMode = realTimeMode;
        if (!this.mRealTimeMode) {
            this.destroyAllocations();
        }
        return this;
    }

    @Override
    public Bitmap process(Bitmap originalBitmap, float radius, float scale, boolean keepSize, boolean recycleOriginal) {
        float newScale;
        Utils.requireNonNull(originalBitmap, "\u5f85\u6a21\u7ccaBitmap\u4e0d\u80fd\u4e3a\u7a7a");
        float newRadius = radius < 0.0f ? 0.0f : radius;
        float f = newScale = scale <= 0.0f ? 1.0f : scale;
        if (newRadius == 0.0f) {
            if (newScale == 1.0f) {
                return originalBitmap;
            }
            Bitmap scaleBitmap = Utils.scaleBitmap(originalBitmap, newScale);
            if (recycleOriginal) {
                originalBitmap.recycle();
            }
            return scaleBitmap;
        }
        if (newRadius > 25.0f) {
            newScale /= newRadius / 25.0f;
            newRadius = 25.0f;
        }
        if (newScale == 1.0f) {
            Bitmap output = this.blurIn25(originalBitmap, newRadius);
            if (recycleOriginal) {
                originalBitmap.recycle();
            }
            return output;
        }
        int width = originalBitmap.getWidth();
        int height = originalBitmap.getHeight();
        Bitmap input = Utils.scaleBitmap(originalBitmap, newScale);
        if (recycleOriginal) {
            originalBitmap.recycle();
        }
        Bitmap output = this.blurIn25(input, newRadius);
        input.recycle();
        if (!keepSize) {
            return output;
        }
        Bitmap outputScaled = Utils.scaleBitmap(output, width, height);
        output.recycle();
        return outputScaled;
    }

    @Override
    public void recycle() {
        this.gaussianBlur.destroy();
        this.renderScript.destroy();
        this.destroyAllocations();
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap blurIn25(Bitmap input, float radius) {
        Utils.requireNonNull(input, "\u5f85\u6a21\u7ccaBitmap\u4e0d\u80fd\u4e3a\u7a7a");
        if (Build.VERSION.SDK_INT < 17) {
            throw new RuntimeException("Call requires API level 17 (current min is " + Build.VERSION.SDK_INT + ")");
        }
        float newRadius = radius < 0.0f ? 0.0f : (radius > 25.0f ? 25.0f : radius);
        if (this.mRealTimeMode) {
            this.tryReuseAllocation(input);
        } else {
            this.createAllocation(input);
        }
        try {
            this.gaussianBlur.setRadius(newRadius);
            this.gaussianBlur.setInput(this.mInput);
            this.gaussianBlur.forEach(this.mOutput);
            Bitmap output = Bitmap.createBitmap((int)input.getWidth(), (int)input.getHeight(), (Bitmap.Config)input.getConfig());
            this.mOutput.copyTo(output);
            Bitmap bitmap = output;
            return bitmap;
        }
        finally {
            if (!this.mRealTimeMode) {
                this.destroyAllocations();
            }
        }
    }

    private void destroyAllocations() {
        if (this.mInput != null) {
            try {
                this.mInput.destroy();
                this.mInput = null;
            }
            catch (RSInvalidStateException rSInvalidStateException) {
                // empty catch block
            }
        }
        if (this.mOutput != null) {
            try {
                this.mOutput.destroy();
                this.mOutput = null;
            }
            catch (RSInvalidStateException rSInvalidStateException) {
                // empty catch block
            }
        }
    }

    private void tryReuseAllocation(Bitmap bitmap) {
        if (this.mInput == null) {
            this.createAllocation(bitmap);
        }
        if (this.mInput.getType().getX() != bitmap.getWidth() || this.mInput.getType().getY() != bitmap.getHeight()) {
            this.createAllocation(bitmap);
        }
        try {
            this.mInput.copyFrom(bitmap);
        }
        catch (RSIllegalArgumentException ignore) {
            this.destroyAllocations();
            this.createAllocation(bitmap);
        }
    }

    private void createAllocation(Bitmap bitmap) {
        this.destroyAllocations();
        this.mInput = Allocation.createFromBitmap((RenderScript)this.renderScript, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
        this.mOutput = Allocation.createTyped((RenderScript)this.renderScript, (Type)this.mInput.getType());
    }
}

