/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.adk.tools.mcp.McpTool;
import com.google.adk.tools.mcp.SseServerParameters;
import com.google.common.collect.ImmutableList;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpToolset
implements BaseToolset {
    private static final Logger logger = LoggerFactory.getLogger(McpToolset.class);
    private final McpSessionManager mcpSessionManager;
    private McpSyncClient mcpSession;
    private final ObjectMapper objectMapper;
    private final Optional<Object> toolFilter;
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_DELAY_MILLIS = 100L;

    public McpToolset(SseServerParameters connectionParams, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
        this.toolFilter = toolFilter;
    }

    public McpToolset(SseServerParameters connectionParams, ObjectMapper objectMapper) {
        this(connectionParams, objectMapper, Optional.empty());
    }

    public McpToolset(ServerParameters connectionParams, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
        this.toolFilter = toolFilter;
    }

    public McpToolset(ServerParameters connectionParams, ObjectMapper objectMapper) {
        this(connectionParams, objectMapper, Optional.empty());
    }

    public McpToolset(SseServerParameters connectionParams, Optional<Object> toolFilter) {
        this(connectionParams, JsonBaseModel.getMapper(), toolFilter);
    }

    public McpToolset(SseServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper(), Optional.empty());
    }

    public McpToolset(ServerParameters connectionParams, Optional<Object> toolFilter) {
        this(connectionParams, JsonBaseModel.getMapper(), toolFilter);
    }

    public McpToolset(ServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper(), Optional.empty());
    }

    public McpToolset(McpSessionManager mcpSessionManager, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(mcpSessionManager);
        Objects.requireNonNull(objectMapper);
        this.mcpSessionManager = mcpSessionManager;
        this.objectMapper = objectMapper;
        this.toolFilter = toolFilter;
    }

    @Override
    public Flowable<BaseTool> getTools(ReadonlyContext readonlyContext) {
        return Flowable.fromCallable(() -> {
            for (int i = 0; i < 3; ++i) {
                try {
                    if (this.mcpSession == null) {
                        logger.info("MCP session is null or closed, initializing (attempt {}).", (Object)(i + 1));
                        this.mcpSession = this.mcpSessionManager.createSession();
                    }
                    McpSchema.ListToolsResult toolsResponse = this.mcpSession.listTools();
                    return (ImmutableList)toolsResponse.tools().stream().map(tool -> new McpTool((McpSchema.Tool)tool, this.mcpSession, this.mcpSessionManager, this.objectMapper)).filter(tool -> this.isToolSelected((BaseTool)tool, this.toolFilter, Optional.ofNullable(readonlyContext))).collect(ImmutableList.toImmutableList());
                }
                catch (IllegalArgumentException e) {
                    logger.error("Invalid argument encountered during tool loading.", (Throwable)e);
                    throw new McpToolLoadingException("Invalid argument encountered during tool loading.", e);
                }
                catch (RuntimeException e) {
                    logger.error("Unexpected error during tool loading, retry attempt " + (i + 1), (Throwable)e);
                    if (i < 2) {
                        try {
                            logger.info("Reinitializing MCP session before next retry for unexpected error.");
                            this.mcpSession = this.mcpSessionManager.createSession();
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            logger.error("Interrupted during retry delay for loadTools (unexpected error).", (Throwable)ie);
                            throw new McpToolLoadingException("Interrupted during retry delay (unexpected error)", ie);
                        }
                        catch (RuntimeException reinitE) {
                            logger.error("Failed to reinitialize session during retry (unexpected error).", (Throwable)reinitE);
                            throw new McpInitializationException("Failed to reinitialize session during tool loading retry (unexpected error).", reinitE);
                        }
                    }
                    logger.error("Failed to load tools after multiple retries due to unexpected error.", (Throwable)e);
                    throw new McpToolLoadingException("Failed to load tools after multiple retries due to unexpected error.", e);
                }
            }
            throw new IllegalStateException("Unexpected state in getTools retry loop");
        }).flatMapIterable(tools -> tools);
    }

    @Override
    public void close() {
        if (this.mcpSession != null) {
            try {
                this.mcpSession.close();
                logger.debug("MCP session closed successfully.");
            }
            catch (RuntimeException e) {
                logger.error("Failed to close MCP session", (Throwable)e);
            }
            finally {
                this.mcpSession = null;
            }
        }
    }

    public static class McpToolLoadingException
    extends McpToolsetException {
        public McpToolLoadingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class McpInitializationException
    extends McpToolsetException {
        public McpInitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class McpToolsetException
    extends RuntimeException {
        public McpToolsetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

