/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.adk.tools.mcp.McpTool;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpAsyncTool
extends BaseTool {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncTool.class);
    McpSchema.Tool mcpTool;
    volatile McpAsyncClient mcpSession;
    McpSessionManager mcpSessionManager;
    ObjectMapper objectMapper;

    public McpAsyncTool(McpSchema.Tool mcpTool, McpAsyncClient mcpSession, McpSessionManager mcpSessionManager) {
        this(mcpTool, mcpSession, mcpSessionManager, JsonBaseModel.getMapper());
    }

    public McpAsyncTool(McpSchema.Tool mcpTool, McpAsyncClient mcpSession, McpSessionManager mcpSessionManager, ObjectMapper objectMapper) {
        super(mcpTool == null ? "" : mcpTool.name(), mcpTool == null ? "" : (mcpTool.description().isEmpty() ? "" : mcpTool.description()));
        if (mcpTool == null) {
            throw new IllegalArgumentException("mcpTool cannot be null");
        }
        if (mcpSession == null) {
            throw new IllegalArgumentException("mcpSession cannot be null");
        }
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper cannot be null");
        }
        this.mcpTool = mcpTool;
        this.mcpSession = mcpSession;
        this.mcpSessionManager = mcpSessionManager;
        this.objectMapper = objectMapper;
    }

    public McpAsyncClient getMcpSession() {
        return this.mcpSession;
    }

    public Schema toGeminiSchema(McpSchema.JsonSchema openApiSchema) {
        return Schema.fromJson((String)this.objectMapper.valueToTree((Object)openApiSchema).toString());
    }

    private Single<McpSchema.InitializeResult> reintializeSession() {
        McpAsyncClient client = this.mcpSessionManager.createAsyncSession();
        return Single.fromCompletionStage((CompletionStage)client.initialize().doOnSuccess(initResult -> logger.debug("Initialize McpAsyncClient Result: {}", initResult)).doOnError(e -> logger.error("Initialize McpAsyncClient Failed: {}", (Object)e.getMessage(), e)).doOnNext(_initResult -> {
            this.mcpSession = client;
        }).toFuture());
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        return Optional.of(FunctionDeclaration.builder().name(this.name()).description(this.description()).parameters(this.toGeminiSchema(this.mcpTool.inputSchema())).build());
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        return Single.defer(() -> Maybe.fromCompletionStage((CompletionStage)this.mcpSession.callTool(new McpSchema.CallToolRequest(this.name(), (Map)ImmutableMap.copyOf((Map)args))).toFuture()).map(callResult -> McpTool.wrapCallResult(this.objectMapper, this.name(), callResult)).switchIfEmpty((SingleSource)Single.fromCallable(() -> McpTool.wrapCallResult(this.objectMapper, this.name(), null)))).retryWhen(errors -> errors.delay(100L, TimeUnit.MILLISECONDS).take(3L).doOnNext(error -> logger.error("Retrying callTool due to: {}", (Object)error.getMessage(), error)).flatMapSingle(_ignore -> this.reintializeSession()));
    }
}

