/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.EventActions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Optional;

public class ToolContext
extends CallbackContext {
    private Optional<String> functionCallId = Optional.empty();

    private ToolContext(InvocationContext invocationContext, EventActions eventActions, Optional<String> functionCallId) {
        super(invocationContext, eventActions);
        this.functionCallId = functionCallId;
    }

    public EventActions actions() {
        return this.eventActions;
    }

    public void setActions(EventActions actions) {
        this.eventActions = actions;
    }

    public Optional<String> functionCallId() {
        return this.functionCallId;
    }

    public void functionCallId(String functionCallId) {
        this.functionCallId = Optional.ofNullable(functionCallId);
    }

    private void requestCredential() {
        throw new UnsupportedOperationException("Credential request not implemented yet.");
    }

    private void getAuthResponse() {
        throw new UnsupportedOperationException("Auth response retrieval not implemented yet.");
    }

    private void searchMemory() {
        throw new UnsupportedOperationException("Search memory not implemented yet.");
    }

    public static Builder builder(InvocationContext invocationContext) {
        return new Builder(invocationContext);
    }

    public Builder toBuilder() {
        return new Builder(this.invocationContext).actions(this.eventActions).functionCallId(this.functionCallId.orElse(null));
    }

    public static final class Builder {
        private final InvocationContext invocationContext;
        private EventActions eventActions = EventActions.builder().build();
        private Optional<String> functionCallId = Optional.empty();

        private Builder(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
        }

        @CanIgnoreReturnValue
        public Builder actions(EventActions actions) {
            this.eventActions = actions;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder functionCallId(String functionCallId) {
            this.functionCallId = Optional.ofNullable(functionCallId);
            return this;
        }

        public ToolContext build() {
            return new ToolContext(this.invocationContext, this.eventActions, this.functionCallId);
        }
    }
}

