/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.Annotations;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionCallingUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(FunctionCallingUtils.class);

    public static FunctionDeclaration buildFunctionDeclaration(Method func, List<String> ignoreParams) {
        String name = func.isAnnotationPresent(Annotations.Schema.class) && !func.getAnnotation(Annotations.Schema.class).name().isEmpty() ? func.getAnnotation(Annotations.Schema.class).name() : func.getName();
        FunctionDeclaration.Builder builder = FunctionDeclaration.builder().name(name);
        if (func.isAnnotationPresent(Annotations.Schema.class) && !func.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            builder.description(func.getAnnotation(Annotations.Schema.class).description());
        }
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        for (Parameter param : func.getParameters()) {
            String paramName;
            String string = paramName = param.isAnnotationPresent(Annotations.Schema.class) && !param.getAnnotation(Annotations.Schema.class).name().isEmpty() ? param.getAnnotation(Annotations.Schema.class).name() : param.getName();
            if (ignoreParams.contains(paramName)) continue;
            required.add(paramName);
            properties.put(paramName, FunctionCallingUtils.buildSchemaFromParameter(param));
        }
        builder.parameters(Schema.builder().required(required).properties(properties).type("OBJECT").build());
        Type returnType = func.getGenericReturnType();
        if (returnType != Void.TYPE) {
            ParameterizedType parameterizedReturnType;
            String rawTypeName;
            Type actualReturnType = returnType;
            if (returnType instanceof ParameterizedType && ((rawTypeName = ((Class)(parameterizedReturnType = (ParameterizedType)returnType).getRawType()).getName()).equals("io.reactivex.rxjava3.core.Maybe") || rawTypeName.equals("io.reactivex.rxjava3.core.Single") || rawTypeName.equals("io.reactivex.rxjava3.core.Flowable"))) {
                actualReturnType = parameterizedReturnType.getActualTypeArguments()[0];
            }
            builder.response(FunctionCallingUtils.buildSchemaFromType(actualReturnType));
        }
        return builder.build();
    }

    static FunctionDeclaration buildFunctionDeclaration(JsonBaseModel func, String description) {
        String jsonString = func.toJson();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jsonString) ? 1 : 0) != 0, (Object)"Input String can't be null or empty.");
        FunctionDeclaration declaration = FunctionDeclaration.fromJson((String)jsonString);
        declaration = declaration.toBuilder().description(description).build();
        if (declaration.name().isEmpty() || ((String)declaration.name().get()).isEmpty()) {
            throw new IllegalArgumentException("name field must be present.");
        }
        return declaration;
    }

    private static Schema buildSchemaFromParameter(Parameter param) {
        Schema schema = FunctionCallingUtils.buildSchemaFromType(param.getParameterizedType());
        if (param.isAnnotationPresent(Annotations.Schema.class) && !param.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            return schema.toBuilder().description(param.getAnnotation(Annotations.Schema.class).description()).build();
        }
        return schema;
    }

    public static Schema buildSchemaFromType(Type type) {
        return FunctionCallingUtils.buildSchemaRecursive(type, new SchemaGenerationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Schema buildSchemaRecursive(Type type, SchemaGenerationContext context) {
        Schema resultSchema;
        String definitionName = FunctionCallingUtils.getTypeKey(type);
        if (definitionName != null) {
            if (context.isProcessing(type)) {
                logger.warn("Type {} is recursive. Omitting from schema.", (Object)type);
                return Schema.builder().type("OBJECT").description("Recursive reference to " + definitionName + " omitted.").build();
            }
            Optional<Schema> cachedSchema = context.getDefinition(definitionName);
            if (cachedSchema.isPresent()) {
                return cachedSchema.get();
            }
        }
        context.startProcessing(type);
        try {
            Schema.Builder builder = Schema.builder();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawClass = (Class)parameterizedType.getRawType();
                if (List.class.isAssignableFrom(rawClass)) {
                    Schema itemSchema = FunctionCallingUtils.buildSchemaRecursive(parameterizedType.getActualTypeArguments()[0], context);
                    builder.type("ARRAY").items(itemSchema);
                } else {
                    if (!Map.class.isAssignableFrom(rawClass)) {
                        Schema itemSchema = FunctionCallingUtils.buildSchemaRecursive(rawClass, context);
                        return itemSchema;
                    }
                    builder.type("OBJECT");
                }
            } else if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isEnum()) {
                    builder.type("STRING");
                    ArrayList<String> enumValues = new ArrayList<String>();
                    for (Object enumConstant : clazz.getEnumConstants()) {
                        enumValues.add(enumConstant.toString());
                    }
                    builder.enum_(enumValues);
                } else if (String.class.equals((Object)clazz)) {
                    builder.type("STRING");
                } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                    builder.type("BOOLEAN");
                } else if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
                    builder.type("INTEGER");
                } else if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz) || Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz) || Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
                    builder.type("NUMBER");
                } else if (Map.class.isAssignableFrom(clazz)) {
                    builder.type("OBJECT");
                } else {
                    if (!OBJECT_MAPPER.canSerialize(clazz)) {
                        throw new IllegalArgumentException("Unsupported type: " + clazz.getName() + ". The type must be a Jackson-serializable POJO or a registered primitive. Opaque types like Protobuf models are not supported directly.");
                    }
                    BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(OBJECT_MAPPER.constructType(type));
                    LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                    for (BeanPropertyDefinition property : beanDescription.findProperties()) {
                        Class propertyType = property.getRawPrimaryType();
                        if (propertyType == null) continue;
                        properties.put(property.getName(), FunctionCallingUtils.buildSchemaRecursive(propertyType, context));
                    }
                    builder.type("OBJECT").properties(properties);
                }
            }
            resultSchema = builder.build();
        }
        finally {
            context.finishProcessing(type);
        }
        if (definitionName == null) return resultSchema;
        context.addDefinition(definitionName, resultSchema);
        return resultSchema;
    }

    @Nullable
    private static String getTypeKey(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || clazz.isEnum() || clazz.getName().startsWith("java.")) {
                return null;
            }
            return clazz.getCanonicalName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return FunctionCallingUtils.getTypeKey(pType.getRawType());
        }
        return null;
    }

    private FunctionCallingUtils() {
    }

    private static class SchemaGenerationContext {
        private final Map<String, Schema> definitions = new LinkedHashMap<String, Schema>();
        private final Set<Type> processingStack = new HashSet<Type>();

        private SchemaGenerationContext() {
        }

        boolean isProcessing(Type type) {
            return this.processingStack.contains(type);
        }

        void startProcessing(Type type) {
            this.processingStack.add(type);
        }

        void finishProcessing(Type type) {
            this.processingStack.remove(type);
        }

        Optional<Schema> getDefinition(String name) {
            return Optional.ofNullable(this.definitions.get(name));
        }

        void addDefinition(String name, Schema schema) {
            this.definitions.put(name, schema);
        }
    }
}

