/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.google.adk.sessions.ApiClient;
import com.google.adk.sessions.ApiResponse;
import com.google.adk.sessions.HttpApiResponse;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpApiClient
extends ApiClient {
    public static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    HttpApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions) {
        super(apiKey, httpOptions);
    }

    HttpApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        super(project, location, credentials, httpOptions);
    }

    @Override
    public ApiResponse request(String httpMethod, String path, String requestJson) {
        boolean queryBaseModel;
        boolean bl = queryBaseModel = Ascii.equalsIgnoreCase((CharSequence)httpMethod, (CharSequence)"GET") && ((String)path).startsWith("publishers/google/models/");
        if (this.vertexAI() && !((String)path).startsWith("projects/") && !queryBaseModel) {
            path = String.format("projects/%s/locations/%s/", this.project.get(), this.location.get()) + (String)path;
        }
        String requestUrl = String.format("%s/%s/%s", this.httpOptions.baseUrl().get(), this.httpOptions.apiVersion().get(), path);
        Request.Builder requestBuilder = new Request.Builder().url(requestUrl);
        this.setHeaders(requestBuilder);
        if (Ascii.equalsIgnoreCase((CharSequence)httpMethod, (CharSequence)"POST")) {
            requestBuilder.post(RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)requestJson));
        } else if (Ascii.equalsIgnoreCase((CharSequence)httpMethod, (CharSequence)"GET")) {
            requestBuilder.get();
        } else if (Ascii.equalsIgnoreCase((CharSequence)httpMethod, (CharSequence)"DELETE")) {
            requestBuilder.delete();
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + httpMethod);
        }
        return this.executeRequest(requestBuilder.build());
    }

    private void setHeaders(Request.Builder requestBuilder) {
        for (Map.Entry header : ((Map)this.httpOptions.headers().orElse(ImmutableMap.of())).entrySet()) {
            requestBuilder.header((String)header.getKey(), (String)header.getValue());
        }
        if (this.apiKey.isPresent()) {
            requestBuilder.header("x-goog-api-key", (String)this.apiKey.get());
        } else {
            String accessToken;
            GoogleCredentials cred = (GoogleCredentials)this.credentials.orElseThrow(() -> new IllegalStateException("credentials is required"));
            try {
                cred.refreshIfExpired();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials.", e);
            }
            try {
                accessToken = cred.getAccessToken().getTokenValue();
            }
            catch (NullPointerException e) {
                if (e.getMessage().contains("because the return value of \"com.google.auth.oauth2.GoogleCredentials.getAccessToken()\" is null")) {
                    accessToken = "";
                }
                throw e;
            }
            requestBuilder.header("Authorization", "Bearer " + accessToken);
            if (cred.getQuotaProjectId() != null) {
                requestBuilder.header("x-goog-user-project", cred.getQuotaProjectId());
            }
        }
    }

    private ApiResponse executeRequest(Request request) {
        try {
            Response response = this.httpClient.newCall(request).execute();
            return new HttpApiResponse(response);
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to execute HTTP request.", e);
        }
    }
}

