/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.sessions.GetSessionConfig;
import com.google.adk.sessions.ListEventsResponse;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public interface BaseSessionService {
    public Single<Session> createSession(String var1, String var2, @Nullable ConcurrentMap<String, Object> var3, @Nullable String var4);

    default public Single<Session> createSession(String appName, String userId) {
        return this.createSession(appName, userId, null, null);
    }

    public Maybe<Session> getSession(String var1, String var2, String var3, Optional<GetSessionConfig> var4);

    public Single<ListSessionsResponse> listSessions(String var1, String var2);

    public Completable deleteSession(String var1, String var2, String var3);

    public Single<ListEventsResponse> listEvents(String var1, String var2, String var3);

    default public Completable closeSession(Session session) {
        return Completable.complete();
    }

    @CanIgnoreReturnValue
    default public Single<Event> appendEvent(Session session, Event event) {
        List<Event> sessionEvents;
        ConcurrentMap<String, Object> sessionState;
        ConcurrentMap<String, Object> stateDelta;
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(event, "event cannot be null");
        if (event.partial().orElse(false).booleanValue()) {
            return Single.just((Object)event);
        }
        EventActions actions = event.actions();
        if (actions != null && (stateDelta = actions.stateDelta()) != null && !stateDelta.isEmpty() && (sessionState = session.state()) != null) {
            stateDelta.forEach((key, value) -> {
                if (!key.startsWith("temp:")) {
                    sessionState.put((String)key, value);
                }
            });
        }
        if ((sessionEvents = session.events()) != null) {
            sessionEvents.add(event);
        }
        return Single.just((Object)event);
    }
}

