/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.adk.JsonBaseModel;
import com.google.adk.models.AutoValue_LlmResponse;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateContentResponsePromptFeedback;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.GroundingMetadata;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LlmResponse
extends JsonBaseModel {
    LlmResponse() {
    }

    @JsonProperty(value="content")
    public abstract Optional<Content> content();

    @JsonProperty(value="groundingMetadata")
    public abstract Optional<GroundingMetadata> groundingMetadata();

    @JsonProperty(value="partial")
    public abstract Optional<Boolean> partial();

    @JsonProperty(value="turnComplete")
    public abstract Optional<Boolean> turnComplete();

    @JsonProperty(value="errorCode")
    public abstract Optional<FinishReason> errorCode();

    @JsonProperty(value="errorMessage")
    public abstract Optional<String> errorMessage();

    @JsonProperty(value="interrupted")
    public abstract Optional<Boolean> interrupted();

    @JsonProperty(value="usageMetadata")
    public abstract Optional<GenerateContentResponseUsageMetadata> usageMetadata();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_LlmResponse.Builder();
    }

    public static LlmResponse create(List<Candidate> candidates) {
        GenerateContentResponse response = GenerateContentResponse.builder().candidates(candidates).build();
        return LlmResponse.builder().response(response).build();
    }

    public static LlmResponse create(GenerateContentResponse response) {
        return LlmResponse.builder().response(response).build();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        static Builder jacksonBuilder() {
            return LlmResponse.builder();
        }

        @JsonProperty(value="content")
        public abstract Builder content(Content var1);

        @JsonProperty(value="interrupted")
        public abstract Builder interrupted(@Nullable Boolean var1);

        public abstract Builder interrupted(Optional<Boolean> var1);

        @JsonProperty(value="groundingMetadata")
        public abstract Builder groundingMetadata(@Nullable GroundingMetadata var1);

        public abstract Builder groundingMetadata(Optional<GroundingMetadata> var1);

        @JsonProperty(value="partial")
        public abstract Builder partial(@Nullable Boolean var1);

        public abstract Builder partial(Optional<Boolean> var1);

        @JsonProperty(value="turnComplete")
        public abstract Builder turnComplete(@Nullable Boolean var1);

        public abstract Builder turnComplete(Optional<Boolean> var1);

        @JsonProperty(value="errorCode")
        public abstract Builder errorCode(@Nullable FinishReason var1);

        public abstract Builder errorCode(Optional<FinishReason> var1);

        @JsonProperty(value="errorMessage")
        public abstract Builder errorMessage(@Nullable String var1);

        public abstract Builder errorMessage(Optional<String> var1);

        @JsonProperty(value="usageMetadata")
        public abstract Builder usageMetadata(@Nullable GenerateContentResponseUsageMetadata var1);

        public abstract Builder usageMetadata(Optional<GenerateContentResponseUsageMetadata> var1);

        @CanIgnoreReturnValue
        public final Builder response(GenerateContentResponse response) {
            Optional candidatesOpt = response.candidates();
            if (candidatesOpt.isPresent() && !((List)candidatesOpt.get()).isEmpty()) {
                Candidate candidate = (Candidate)((List)candidatesOpt.get()).get(0);
                if (candidate.content().isPresent()) {
                    this.content((Content)candidate.content().get());
                    this.groundingMetadata(candidate.groundingMetadata());
                } else {
                    candidate.finishReason().ifPresent(this::errorCode);
                    candidate.finishMessage().ifPresent(this::errorMessage);
                }
            } else {
                Optional promptFeedbackOpt = response.promptFeedback();
                if (promptFeedbackOpt.isPresent()) {
                    GenerateContentResponsePromptFeedback promptFeedback = (GenerateContentResponsePromptFeedback)promptFeedbackOpt.get();
                    promptFeedback.blockReason().ifPresent(reason -> this.errorCode(new FinishReason(reason.toString())));
                    promptFeedback.blockReasonMessage().ifPresent(this::errorMessage);
                } else {
                    this.errorCode(new FinishReason("Unknown error."));
                    this.errorMessage("Unknown error.");
                }
            }
            this.usageMetadata(response.usageMetadata());
            return this;
        }

        abstract LlmResponse autoBuild();

        public LlmResponse build() {
            return this.autoBuild();
        }
    }
}

