/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.BaseAgentConfig;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.LlmAgentConfig;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigAgentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAgentUtils.class);

    private ConfigAgentUtils() {
    }

    public static BaseAgent fromConfig(String configPath) throws ConfigurationException {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            logger.error("Config file not found: {}", (Object)configPath);
            throw new ConfigurationException("Config file not found: " + configPath);
        }
        String absolutePath = configFile.getAbsolutePath();
        try {
            BaseAgentConfig baseConfig = ConfigAgentUtils.loadConfigAsType(absolutePath, BaseAgentConfig.class);
            Class<? extends BaseAgent> agentClass = ConfigAgentUtils.resolveAgentClass(baseConfig.agentClass());
            Class<? extends BaseAgentConfig> configClass = ConfigAgentUtils.getConfigClassForAgent(agentClass);
            BaseAgentConfig config = ConfigAgentUtils.loadConfigAsType(absolutePath, configClass);
            logger.info("agentClass value = '{}'", (Object)config.agentClass());
            Method fromConfigMethod = agentClass.getDeclaredMethod("fromConfig", configClass, String.class);
            return (BaseAgent)fromConfigMethod.invoke(null, config, absolutePath);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create agent from config: " + configPath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends BaseAgentConfig> T loadConfigAsType(String configPath, Class<T> configClass) throws ConfigurationException {
        try (FileInputStream inputStream = new FileInputStream(configPath);){
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            BaseAgentConfig baseAgentConfig = (BaseAgentConfig)mapper.readValue((InputStream)inputStream, configClass);
            return (T)baseAgentConfig;
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load or parse config file: " + configPath, e);
        }
    }

    private static Class<? extends BaseAgent> resolveAgentClass(String agentClassName) throws ConfigurationException {
        if (Strings.isNullOrEmpty((String)agentClassName) || agentClassName.equals("LlmAgent")) {
            return LlmAgent.class;
        }
        throw new ConfigurationException("agentClass '" + agentClassName + "' is not supported. It must be a subclass of BaseAgent.");
    }

    private static Class<? extends BaseAgentConfig> getConfigClassForAgent(Class<? extends BaseAgent> agentClass) {
        if (agentClass == LlmAgent.class) {
            return LlmAgentConfig.class;
        }
        return BaseAgentConfig.class;
    }

    public static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

