/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.RunConfig;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Modality;
import com.google.genai.types.SpeechConfig;
import org.jspecify.annotations.Nullable;

final class AutoValue_RunConfig
extends RunConfig {
    private final @Nullable SpeechConfig speechConfig;
    private final ImmutableList<Modality> responseModalities;
    private final boolean saveInputBlobsAsArtifacts;
    private final RunConfig.StreamingMode streamingMode;
    private final @Nullable AudioTranscriptionConfig outputAudioTranscription;
    private final int maxLlmCalls;

    private AutoValue_RunConfig(@Nullable SpeechConfig speechConfig, ImmutableList<Modality> responseModalities, boolean saveInputBlobsAsArtifacts, RunConfig.StreamingMode streamingMode, @Nullable AudioTranscriptionConfig outputAudioTranscription, int maxLlmCalls) {
        this.speechConfig = speechConfig;
        this.responseModalities = responseModalities;
        this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
        this.streamingMode = streamingMode;
        this.outputAudioTranscription = outputAudioTranscription;
        this.maxLlmCalls = maxLlmCalls;
    }

    @Override
    public @Nullable SpeechConfig speechConfig() {
        return this.speechConfig;
    }

    @Override
    public ImmutableList<Modality> responseModalities() {
        return this.responseModalities;
    }

    @Override
    public boolean saveInputBlobsAsArtifacts() {
        return this.saveInputBlobsAsArtifacts;
    }

    @Override
    public RunConfig.StreamingMode streamingMode() {
        return this.streamingMode;
    }

    @Override
    public @Nullable AudioTranscriptionConfig outputAudioTranscription() {
        return this.outputAudioTranscription;
    }

    @Override
    public int maxLlmCalls() {
        return this.maxLlmCalls;
    }

    public String toString() {
        return "RunConfig{speechConfig=" + this.speechConfig + ", responseModalities=" + this.responseModalities + ", saveInputBlobsAsArtifacts=" + this.saveInputBlobsAsArtifacts + ", streamingMode=" + this.streamingMode + ", outputAudioTranscription=" + this.outputAudioTranscription + ", maxLlmCalls=" + this.maxLlmCalls + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RunConfig) {
            RunConfig that = (RunConfig)o;
            return (this.speechConfig == null ? that.speechConfig() == null : this.speechConfig.equals(that.speechConfig())) && this.responseModalities.equals(that.responseModalities()) && this.saveInputBlobsAsArtifacts == that.saveInputBlobsAsArtifacts() && this.streamingMode.equals((Object)that.streamingMode()) && (this.outputAudioTranscription == null ? that.outputAudioTranscription() == null : this.outputAudioTranscription.equals(that.outputAudioTranscription())) && this.maxLlmCalls == that.maxLlmCalls();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.speechConfig == null ? 0 : this.speechConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.responseModalities.hashCode();
        h$ *= 1000003;
        h$ ^= this.saveInputBlobsAsArtifacts ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.streamingMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputAudioTranscription == null ? 0 : this.outputAudioTranscription.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxLlmCalls;
    }

    static final class Builder
    extends RunConfig.Builder {
        private @Nullable SpeechConfig speechConfig;
        private @Nullable ImmutableList<Modality> responseModalities;
        private boolean saveInputBlobsAsArtifacts;
        private @Nullable RunConfig.StreamingMode streamingMode;
        private @Nullable AudioTranscriptionConfig outputAudioTranscription;
        private int maxLlmCalls;
        private byte set$0;

        Builder() {
        }

        @Override
        public RunConfig.Builder setSpeechConfig(SpeechConfig speechConfig) {
            this.speechConfig = speechConfig;
            return this;
        }

        @Override
        public RunConfig.Builder setResponseModalities(Iterable<Modality> responseModalities) {
            this.responseModalities = ImmutableList.copyOf(responseModalities);
            return this;
        }

        @Override
        public RunConfig.Builder setSaveInputBlobsAsArtifacts(boolean saveInputBlobsAsArtifacts) {
            this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public RunConfig.Builder setStreamingMode(RunConfig.StreamingMode streamingMode) {
            if (streamingMode == null) {
                throw new NullPointerException("Null streamingMode");
            }
            this.streamingMode = streamingMode;
            return this;
        }

        @Override
        public RunConfig.Builder setOutputAudioTranscription(AudioTranscriptionConfig outputAudioTranscription) {
            this.outputAudioTranscription = outputAudioTranscription;
            return this;
        }

        @Override
        public RunConfig.Builder setMaxLlmCalls(int maxLlmCalls) {
            this.maxLlmCalls = maxLlmCalls;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        RunConfig autoBuild() {
            if (this.set$0 != 3 || this.responseModalities == null || this.streamingMode == null) {
                StringBuilder missing = new StringBuilder();
                if (this.responseModalities == null) {
                    missing.append(" responseModalities");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" saveInputBlobsAsArtifacts");
                }
                if (this.streamingMode == null) {
                    missing.append(" streamingMode");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxLlmCalls");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RunConfig(this.speechConfig, this.responseModalities, this.saveInputBlobsAsArtifacts, this.streamingMode, this.outputAudioTranscription, this.maxLlmCalls);
        }
    }
}

