/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.maven.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.LiveRequest;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.InMemoryArtifactService;
import com.google.adk.artifacts.ListArtifactsResponse;
import com.google.adk.events.Event;
import com.google.adk.maven.AgentLoader;
import com.google.adk.maven.web.AgentGraphGenerator;
import com.google.adk.runner.Runner;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.InMemorySessionService;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Modality;
import com.google.genai.types.Part;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.springframework.web.util.UriComponentsBuilder;

@SpringBootApplication
@ConfigurationPropertiesScan
public class AdkWebServer
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AdkWebServer.class);
    @Value(value="${adk.web.ui.dir:#{null}}")
    private String webUiDir;
    @Value(value="${adk.agent.hotReloadingEnabled:true}")
    private boolean hotReloadingEnabled;

    @Bean
    public BaseSessionService sessionService() {
        log.info("Using InMemorySessionService");
        return new InMemorySessionService();
    }

    @Bean
    public BaseArtifactService artifactService() {
        log.info("Using InMemoryArtifactService");
        return new InMemoryArtifactService();
    }

    @Bean
    public ObjectMapper objectMapper() {
        return JsonBaseModel.getMapper();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.webUiDir != null && !this.webUiDir.isEmpty()) {
            Object location = this.webUiDir.replace("\\", "/");
            if (!((String)location).startsWith("file:")) {
                location = "file:" + (String)location;
            }
            if (!((String)location).endsWith("/")) {
                location = (String)location + "/";
            }
            log.debug("Mapping URL path /** to static resources at location: {}", location);
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{location}).setCachePeriod(Integer.valueOf(0)).resourceChain(true);
        } else {
            log.debug("System property 'adk.web.ui.dir' or config 'adk.web.ui.dir' is not set. Mapping URL path /** to classpath:/browser/");
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/browser/"}).setCachePeriod(Integer.valueOf(0)).resourceChain(true);
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/dev-ui");
        registry.addViewController("/dev-ui").setViewName("forward:/index.html");
        registry.addViewController("/dev-ui/").setViewName("forward:/index.html");
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.tomcat.websocket.DEFAULT_BUFFER_SIZE", String.valueOf(0xA00000));
        SpringApplication.run(AdkWebServer.class, (String[])args);
        log.info("AdkWebServer application started successfully.");
    }

    @Component
    public static class LiveWebSocketHandler
    extends TextWebSocketHandler {
        private static final Logger log = LoggerFactory.getLogger(LiveWebSocketHandler.class);
        private static final String LIVE_REQUEST_QUEUE_ATTR = "liveRequestQueue";
        private static final String LIVE_SUBSCRIPTION_ATTR = "liveSubscription";
        private static final int WEBSOCKET_MAX_BYTES_FOR_REASON = 123;
        private final ObjectMapper objectMapper;
        private final BaseSessionService sessionService;
        private final RunnerService runnerService;

        @Autowired
        public LiveWebSocketHandler(ObjectMapper objectMapper, BaseSessionService sessionService, RunnerService runnerService) {
            this.objectMapper = objectMapper;
            this.sessionService = sessionService;
            this.runnerService = runnerService;
        }

        public void afterConnectionEstablished(WebSocketSession wsSession) throws Exception {
            Runner runner;
            Session session;
            URI uri = wsSession.getUri();
            if (uri == null) {
                log.warn("WebSocket session URI is null, cannot establish connection.");
                wsSession.close(CloseStatus.SERVER_ERROR.withReason("Invalid URI"));
                return;
            }
            String path = uri.getPath();
            log.info("WebSocket connection established: {} from {}", (Object)wsSession.getId(), (Object)uri);
            MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)uri).build().getQueryParams();
            String appName = (String)queryParams.getFirst((Object)"app_name");
            String userId = (String)queryParams.getFirst((Object)"user_id");
            String sessionId = (String)queryParams.getFirst((Object)"session_id");
            if (appName == null || appName.trim().isEmpty()) {
                log.warn("WebSocket connection for session {} rejected: app_name query parameter is required and cannot be empty. URI: {}", (Object)wsSession.getId(), (Object)uri);
                wsSession.close(CloseStatus.POLICY_VIOLATION.withReason("app_name query parameter is required and cannot be empty"));
                return;
            }
            if (sessionId == null || sessionId.trim().isEmpty()) {
                log.warn("WebSocket connection for session {} rejected: session_id query parameter is required and cannot be empty. URI: {}", (Object)wsSession.getId(), (Object)uri);
                wsSession.close(CloseStatus.POLICY_VIOLATION.withReason("session_id query parameter is required and cannot be empty"));
                return;
            }
            log.debug("Extracted params for WebSocket session {}: appName={}, userId={}, sessionId={},", new Object[]{wsSession.getId(), appName, userId, sessionId});
            RunConfig runConfig = RunConfig.builder().setResponseModalities((Iterable)ImmutableList.of((Object)new Modality(Modality.Known.AUDIO))).setStreamingMode(RunConfig.StreamingMode.BIDI).build();
            try {
                session = (Session)this.sessionService.getSession(appName, userId, sessionId, Optional.empty()).blockingGet();
                if (session == null) {
                    log.warn("Session not found for WebSocket: app={}, user={}, id={}. Closing connection.", new Object[]{appName, userId, sessionId});
                    wsSession.close(new CloseStatus(1002, "Session not found"));
                    return;
                }
            }
            catch (Exception e) {
                log.error("Error retrieving session for WebSocket: app={}, user={}, id={}", new Object[]{appName, userId, sessionId, e});
                wsSession.close(CloseStatus.SERVER_ERROR.withReason("Failed to retrieve session"));
                return;
            }
            LiveRequestQueue liveRequestQueue = new LiveRequestQueue();
            wsSession.getAttributes().put(LIVE_REQUEST_QUEUE_ATTR, liveRequestQueue);
            try {
                runner = this.runnerService.getRunner(appName);
            }
            catch (ResponseStatusException e) {
                log.error("Failed to get runner for app {} during WebSocket connection: {}", (Object)appName, (Object)e.getMessage());
                wsSession.close(CloseStatus.SERVER_ERROR.withReason("Runner unavailable: " + e.getReason()));
                return;
            }
            Flowable eventStream = runner.runLive(session, liveRequestQueue, runConfig);
            Disposable disposable = eventStream.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(event -> {
                try {
                    String jsonEvent = this.objectMapper.writeValueAsString(event);
                    log.debug("Sending event via WebSocket session {}: {}", (Object)wsSession.getId(), (Object)jsonEvent);
                    wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)jsonEvent));
                }
                catch (JsonProcessingException e) {
                    log.error("Error serializing event to JSON for WebSocket session {}", (Object)wsSession.getId(), (Object)e);
                }
                catch (IOException e) {
                    log.error("IOException sending message via WebSocket session {}", (Object)wsSession.getId(), (Object)e);
                    try {
                        wsSession.close(CloseStatus.SERVER_ERROR.withReason("Error sending message"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, error -> {
                log.error("Error in run_live stream for WebSocket session {}: {}", new Object[]{wsSession.getId(), error.getMessage(), error});
                String reason = error.getMessage() != null ? error.getMessage() : "Unknown error";
                try {
                    wsSession.close(new CloseStatus(1011, reason.substring(0, Math.min(reason.length(), 123))));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }, () -> {
                log.debug("run_live stream completed for WebSocket session {}", (Object)wsSession.getId());
                try {
                    wsSession.close(CloseStatus.NORMAL);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            wsSession.getAttributes().put(LIVE_SUBSCRIPTION_ATTR, disposable);
            log.debug("Live run started for WebSocket session {}", (Object)wsSession.getId());
        }

        protected void handleTextMessage(WebSocketSession wsSession, TextMessage message) throws Exception {
            LiveRequestQueue liveRequestQueue = (LiveRequestQueue)wsSession.getAttributes().get(LIVE_REQUEST_QUEUE_ATTR);
            if (liveRequestQueue == null) {
                log.warn("Received message on WebSocket session {} but LiveRequestQueue is not available (null). Message: {}", (Object)wsSession.getId(), message.getPayload());
                return;
            }
            try {
                String payload = (String)message.getPayload();
                log.debug("Received text message on WebSocket session {}: {}", (Object)wsSession.getId(), (Object)payload);
                JsonNode rootNode = this.objectMapper.readTree(payload);
                LiveRequest.Builder liveRequestBuilder = LiveRequest.builder();
                if (rootNode.has("content")) {
                    Content content = (Content)this.objectMapper.treeToValue((TreeNode)rootNode.get("content"), Content.class);
                    liveRequestBuilder.content(content);
                }
                if (rootNode.has("blob")) {
                    String mimeType;
                    JsonNode blobNode = rootNode.get("blob");
                    Blob.Builder blobBuilder = Blob.builder();
                    if (blobNode.has("displayName")) {
                        blobBuilder.displayName(blobNode.get("displayName").asText());
                    }
                    if (blobNode.has("data")) {
                        blobBuilder.data(blobNode.get("data").binaryValue());
                    }
                    String string = blobNode.has("mimeType") ? blobNode.get("mimeType").asText() : (mimeType = blobNode.has("mime_type") ? blobNode.get("mime_type").asText() : null);
                    if (mimeType != null) {
                        blobBuilder.mimeType(mimeType);
                    }
                    liveRequestBuilder.blob(blobBuilder.build());
                }
                LiveRequest liveRequest = liveRequestBuilder.build();
                liveRequestQueue.send(liveRequest);
            }
            catch (JsonProcessingException e) {
                log.error("Error deserializing LiveRequest from WebSocket message for session {}: {}", new Object[]{wsSession.getId(), message.getPayload(), e});
                wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("{\"error\":\"Invalid JSON format for LiveRequest\", \"details\":\"" + e.getMessage() + "\"}")));
            }
            catch (Exception e) {
                log.error("Unexpected error processing text message for WebSocket session {}: {}", new Object[]{wsSession.getId(), message.getPayload(), e});
                String reason = e.getMessage() != null ? e.getMessage() : "Error processing message";
                wsSession.close(new CloseStatus(1011, reason.substring(0, Math.min(reason.length(), 123))));
            }
        }

        public void handleTransportError(WebSocketSession wsSession, Throwable exception) throws Exception {
            log.error("WebSocket transport error for session {}: {}", new Object[]{wsSession.getId(), exception.getMessage(), exception});
            this.cleanupSession(wsSession);
            if (wsSession.isOpen()) {
                String reason = exception.getMessage() != null ? exception.getMessage() : "Transport error";
                wsSession.close(CloseStatus.PROTOCOL_ERROR.withReason(reason.substring(0, Math.min(reason.length(), 123))));
            }
        }

        public void afterConnectionClosed(WebSocketSession wsSession, CloseStatus status) throws Exception {
            log.info("WebSocket connection closed: {} with status {}", (Object)wsSession.getId(), (Object)status.toString());
            this.cleanupSession(wsSession);
        }

        private void cleanupSession(WebSocketSession wsSession) {
            Disposable disposable;
            LiveRequestQueue liveRequestQueue = (LiveRequestQueue)wsSession.getAttributes().remove(LIVE_REQUEST_QUEUE_ATTR);
            if (liveRequestQueue != null) {
                liveRequestQueue.close();
                log.debug("Called close() on LiveRequestQueue for session {}", (Object)wsSession.getId());
            }
            if ((disposable = (Disposable)wsSession.getAttributes().remove(LIVE_SUBSCRIPTION_ATTR)) != null && !disposable.isDisposed()) {
                disposable.dispose();
            }
            log.debug("Cleaned up resources for WebSocket session {}", (Object)wsSession.getId());
        }
    }

    @Configuration
    @EnableWebSocket
    public static class WebSocketConfig
    implements WebSocketConfigurer {
        private final LiveWebSocketHandler liveWebSocketHandler;

        @Autowired
        public WebSocketConfig(LiveWebSocketHandler liveWebSocketHandler) {
            this.liveWebSocketHandler = liveWebSocketHandler;
        }

        public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
            registry.addHandler((WebSocketHandler)this.liveWebSocketHandler, new String[]{"/run_live"}).setAllowedOrigins(new String[]{"*"});
        }
    }

    @RestController
    public static class AgentController {
        private static final Logger log = LoggerFactory.getLogger(AgentController.class);
        private static final String EVAL_SESSION_ID_PREFIX = "ADK_EVAL_";
        private final BaseSessionService sessionService;
        private final BaseArtifactService artifactService;
        private final AgentLoader agentProvider;
        private final ApiServerSpanExporter apiServerSpanExporter;
        private final RunnerService runnerService;
        private final ExecutorService sseExecutor = Executors.newCachedThreadPool();

        @Autowired
        public AgentController(BaseSessionService sessionService, BaseArtifactService artifactService, @Qualifier(value="agentLoader") AgentLoader agentProvider, ApiServerSpanExporter apiServerSpanExporter, RunnerService runnerService) {
            this.sessionService = sessionService;
            this.artifactService = artifactService;
            this.agentProvider = agentProvider;
            this.apiServerSpanExporter = apiServerSpanExporter;
            this.runnerService = runnerService;
            ImmutableList<String> agentNames = agentProvider.listAgents();
            log.info("AgentController initialized with {} dynamic agents: {}", (Object)agentNames.size(), agentNames);
            if (agentNames.isEmpty()) {
                log.warn("Agent registry is empty. Check 'adk.agents.source-dir' property and compilation logs.");
            }
        }

        private Session findSessionOrThrow(String appName, String userId, String sessionId) {
            Maybe maybeSession = this.sessionService.getSession(appName, userId, sessionId, Optional.empty());
            Session session = (Session)maybeSession.blockingGet();
            if (session == null) {
                log.warn("Session not found for appName={}, userId={}, sessionId={}", new Object[]{appName, userId, sessionId});
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, String.format("Session not found: appName=%s, userId=%s, sessionId=%s", appName, userId, sessionId));
            }
            if (!Objects.equals(session.appName(), appName) || !Objects.equals(session.userId(), userId)) {
                log.warn("Session ID {} found but appName/userId mismatch (Expected: {}/{}, Found: {}/{}) - Treating as not found.", new Object[]{sessionId, appName, userId, session.appName(), session.userId()});
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session found but belongs to a different app/user.");
            }
            log.debug("Found session: {}", (Object)sessionId);
            return session;
        }

        @GetMapping(value={"/list-apps"})
        public List<String> listApps() {
            ImmutableList<String> agentNames = this.agentProvider.listAgents();
            log.info("Listing apps from dynamic registry. Found: {}", agentNames);
            return agentNames.stream().sorted().collect(Collectors.toList());
        }

        @GetMapping(value={"/debug/trace/{eventId}"})
        public ResponseEntity<?> getTraceDict(@PathVariable String eventId) {
            log.info("Request received for GET /debug/trace/{}", (Object)eventId);
            Map<String, Object> traceData = this.apiServerSpanExporter.getEventTraceAttributes(eventId);
            if (traceData == null) {
                log.warn("Trace not found for eventId: {}", (Object)eventId);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Collections.singletonMap("message", "Trace not found for eventId: " + eventId));
            }
            log.info("Returning trace data for eventId: {}", (Object)eventId);
            return ResponseEntity.ok(traceData);
        }

        @GetMapping(value={"/debug/trace/session/{sessionId}"})
        public ResponseEntity<Object> getSessionTrace(@PathVariable String sessionId) {
            log.info("Request received for GET /debug/trace/session/{}", (Object)sessionId);
            List<String> traceIdsForSession = this.apiServerSpanExporter.getSessionToTraceIdsMap().get(sessionId);
            if (traceIdsForSession == null || traceIdsForSession.isEmpty()) {
                log.warn("No trace IDs found for session ID: {}", (Object)sessionId);
                return ResponseEntity.ok(Collections.emptyList());
            }
            ArrayList<SpanData> allSpansSnapshot = new ArrayList<SpanData>(this.apiServerSpanExporter.getAllExportedSpans());
            if (allSpansSnapshot.isEmpty()) {
                log.warn("No spans have been exported yet overall.");
                return ResponseEntity.ok(Collections.emptyList());
            }
            HashSet<String> relevantTraceIds = new HashSet<String>(traceIdsForSession);
            ArrayList resultSpans = new ArrayList();
            for (SpanData span : allSpansSnapshot) {
                if (!relevantTraceIds.contains(span.getSpanContext().getTraceId())) continue;
                HashMap<String, Object> spanMap = new HashMap<String, Object>();
                spanMap.put("name", span.getName());
                spanMap.put("span_id", span.getSpanContext().getSpanId());
                spanMap.put("trace_id", span.getSpanContext().getTraceId());
                spanMap.put("start_time", span.getStartEpochNanos());
                spanMap.put("end_time", span.getEndEpochNanos());
                HashMap attributesMap = new HashMap();
                span.getAttributes().forEach((key, value) -> attributesMap.put(key.getKey(), value));
                spanMap.put("attributes", attributesMap);
                String parentSpanId = span.getParentSpanId();
                if (SpanId.isValid((CharSequence)parentSpanId)) {
                    spanMap.put("parent_span_id", parentSpanId);
                } else {
                    spanMap.put("parent_span_id", null);
                }
                resultSpans.add(spanMap);
            }
            log.info("Returning {} spans for session ID: {}", (Object)resultSpans.size(), (Object)sessionId);
            return ResponseEntity.ok(resultSpans);
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
        public Session getSession(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
            log.info("Request received for GET /apps/{}/users/{}/sessions/{}", new Object[]{appName, userId, sessionId});
            return this.findSessionOrThrow(appName, userId, sessionId);
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions"})
        public List<Session> listSessions(@PathVariable String appName, @PathVariable String userId) {
            log.info("Request received for GET /apps/{}/users/{}/sessions", (Object)appName, (Object)userId);
            Single sessionsResponseSingle = this.sessionService.listSessions(appName, userId);
            ListSessionsResponse response = (ListSessionsResponse)sessionsResponseSingle.blockingGet();
            if (response == null || response.sessions() == null) {
                log.warn("Received null response or null sessions list for listSessions({}, {})", (Object)appName, (Object)userId);
                return Collections.emptyList();
            }
            List<Session> filteredSessions = response.sessions().stream().filter(s -> !s.id().startsWith(EVAL_SESSION_ID_PREFIX)).collect(Collectors.toList());
            log.info("Found {} non-evaluation sessions for app={}, user={}", new Object[]{filteredSessions.size(), appName, userId});
            return filteredSessions;
        }

        @PostMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
        public Session createSessionWithId(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @RequestBody(required=false) Map<String, Object> state) {
            log.info("Request received for POST /apps/{}/users/{}/sessions/{} with state: {}", new Object[]{appName, userId, sessionId, state});
            try {
                this.findSessionOrThrow(appName, userId, sessionId);
                log.warn("Attempted to create session with existing ID: {}", (Object)sessionId);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Session already exists: " + sessionId);
            }
            catch (ResponseStatusException e) {
                if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                    throw e;
                }
                log.info("Session {} not found, proceeding with creation.", (Object)sessionId);
                Map<String, Object> initialState = state != null ? state : Collections.emptyMap();
                try {
                    Session createdSession = (Session)this.sessionService.createSession(appName, userId, new ConcurrentHashMap<String, Object>(initialState), sessionId).blockingGet();
                    if (createdSession == null) {
                        log.error("Session creation call completed without error but returned null session for {}", (Object)sessionId);
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create session (null result)");
                    }
                    log.info("Session created successfully with id: {}", (Object)createdSession.id());
                    return createdSession;
                }
                catch (Exception e2) {
                    log.error("Error creating session with id {}", (Object)sessionId, (Object)e2);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating session", (Throwable)e2);
                }
            }
        }

        @PostMapping(value={"/apps/{appName}/users/{userId}/sessions"})
        public Session createSession(@PathVariable String appName, @PathVariable String userId, @RequestBody(required=false) Map<String, Object> state) {
            log.info("Request received for POST /apps/{}/users/{}/sessions (service generates ID) with state: {}", new Object[]{appName, userId, state});
            Map<String, Object> initialState = state != null ? state : Collections.emptyMap();
            try {
                Session createdSession = (Session)this.sessionService.createSession(appName, userId, new ConcurrentHashMap<String, Object>(initialState), null).blockingGet();
                if (createdSession == null) {
                    log.error("Session creation call completed without error but returned null session for user {}", (Object)userId);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create session (null result)");
                }
                log.info("Session created successfully with generated id: {}", (Object)createdSession.id());
                return createdSession;
            }
            catch (Exception e) {
                log.error("Error creating session for user {}", (Object)userId, (Object)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating session", (Throwable)e);
            }
        }

        @DeleteMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
        public ResponseEntity<Void> deleteSession(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
            log.info("Request received for DELETE /apps/{}/users/{}/sessions/{}", new Object[]{appName, userId, sessionId});
            try {
                this.sessionService.deleteSession(appName, userId, sessionId).blockingAwait();
                log.info("Session deleted successfully: {}", (Object)sessionId);
                return ResponseEntity.noContent().build();
            }
            catch (Exception e) {
                log.error("Error deleting session {}", (Object)sessionId, (Object)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error deleting session", (Throwable)e);
            }
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}"})
        public Part loadArtifact(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName, @RequestParam(required=false) Integer version) {
            String versionStr = version == null ? "latest" : String.valueOf(version);
            log.info("Request received to load artifact: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionStr});
            Maybe artifactMaybe = this.artifactService.loadArtifact(appName, userId, sessionId, artifactName, Optional.ofNullable(version));
            Part artifact = (Part)artifactMaybe.blockingGet();
            if (artifact == null) {
                log.warn("Artifact not found: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionStr});
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Artifact not found");
            }
            log.debug("Artifact {} version {} loaded successfully.", (Object)artifactName, (Object)versionStr);
            return artifact;
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}/versions/{versionId}"})
        public Part loadArtifactVersion(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName, @PathVariable int versionId) {
            log.info("Request received to load artifact version: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionId});
            Maybe artifactMaybe = this.artifactService.loadArtifact(appName, userId, sessionId, artifactName, Optional.of(versionId));
            Part artifact = (Part)artifactMaybe.blockingGet();
            if (artifact == null) {
                log.warn("Artifact version not found: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionId});
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Artifact version not found");
            }
            log.debug("Artifact {} version {} loaded successfully.", (Object)artifactName, (Object)versionId);
            return artifact;
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts"})
        public List<String> listArtifactNames(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
            log.info("Request received to list artifact names for app={}, user={}, session={}", new Object[]{appName, userId, sessionId});
            Single responseSingle = this.artifactService.listArtifactKeys(appName, userId, sessionId);
            ListArtifactsResponse response = (ListArtifactsResponse)responseSingle.blockingGet();
            ImmutableList filenames = response != null && response.filenames() != null ? response.filenames() : Collections.emptyList();
            log.info("Found {} artifact names for session {}", (Object)filenames.size(), (Object)sessionId);
            return filenames;
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}/versions"})
        public List<Integer> listArtifactVersions(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName) {
            log.info("Request received to list versions for artifact: app={}, user={}, session={}, artifact={}", new Object[]{appName, userId, sessionId, artifactName});
            Single versionsSingle = this.artifactService.listVersions(appName, userId, sessionId, artifactName);
            ImmutableList versions = (ImmutableList)versionsSingle.blockingGet();
            log.info("Found {} versions for artifact {}", (Object)(versions != null ? versions.size() : 0), (Object)artifactName);
            return versions != null ? versions : Collections.emptyList();
        }

        @DeleteMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}"})
        public ResponseEntity<Void> deleteArtifact(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName) {
            log.info("Request received to delete artifact: app={}, user={}, session={}, artifact={}", new Object[]{appName, userId, sessionId, artifactName});
            try {
                this.artifactService.deleteArtifact(appName, userId, sessionId, artifactName);
                log.info("Artifact deleted successfully: {}", (Object)artifactName);
                return ResponseEntity.noContent().build();
            }
            catch (Exception e) {
                log.error("Error deleting artifact {}", (Object)artifactName, (Object)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error deleting artifact", (Throwable)e);
            }
        }

        @PostMapping(value={"/run"})
        public List<Event> agentRun(@RequestBody AgentRunRequest request) {
            if (request.appName == null || request.appName.trim().isEmpty()) {
                log.warn("appName cannot be null or empty in POST /run request.");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty");
            }
            if (request.sessionId == null || request.sessionId.trim().isEmpty()) {
                log.warn("sessionId cannot be null or empty in POST /run request.");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "sessionId cannot be null or empty");
            }
            log.info("Request received for POST /run for session: {}", (Object)request.sessionId);
            Runner runner = this.runnerService.getRunner(request.appName);
            try {
                RunConfig runConfig = RunConfig.builder().setStreamingMode(RunConfig.StreamingMode.NONE).build();
                Flowable eventStream = runner.runAsync(request.userId, request.sessionId, request.newMessage, runConfig);
                ArrayList events = Lists.newArrayList((Iterable)eventStream.blockingIterable());
                log.info("Agent run for session {} generated {} events.", (Object)request.sessionId, (Object)events.size());
                return events;
            }
            catch (Exception e) {
                log.error("Error during agent run for session {}", (Object)request.sessionId, (Object)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent run failed", (Throwable)e);
            }
        }

        @PostMapping(value={"/run_sse"}, produces={"text/event-stream"})
        public SseEmitter agentRunSse(@RequestBody AgentRunRequest request) {
            SseEmitter emitter = new SseEmitter();
            if (request.appName == null || request.appName.trim().isEmpty()) {
                log.warn("appName cannot be null or empty in SseEmitter request for appName: {}, session: {}", (Object)request.appName, (Object)request.sessionId);
                emitter.completeWithError((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty"));
                return emitter;
            }
            if (request.sessionId == null || request.sessionId.trim().isEmpty()) {
                log.warn("sessionId cannot be null or empty in SseEmitter request for appName: {}, session: {}", (Object)request.appName, (Object)request.sessionId);
                emitter.completeWithError((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "sessionId cannot be null or empty"));
                return emitter;
            }
            log.info("SseEmitter Request received for POST /run_sse_emitter for session: {}", (Object)request.sessionId);
            String sessionId = request.sessionId;
            this.sseExecutor.execute(() -> {
                Runner runner;
                try {
                    runner = this.runnerService.getRunner(request.appName);
                }
                catch (ResponseStatusException e) {
                    log.warn("Setup failed for SseEmitter request for session {}: {}", (Object)sessionId, (Object)e.getMessage());
                    try {
                        emitter.completeWithError((Throwable)e);
                    }
                    catch (Exception ex) {
                        log.warn("Error completing emitter after setup failure for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                    }
                    return;
                }
                RunConfig runConfig = RunConfig.builder().setStreamingMode(request.getStreaming() ? RunConfig.StreamingMode.SSE : RunConfig.StreamingMode.NONE).build();
                Flowable eventFlowable = runner.runAsync(request.userId, request.sessionId, request.newMessage, runConfig);
                Disposable disposable = eventFlowable.observeOn(Schedulers.io()).subscribe(event -> {
                    try {
                        log.debug("SseEmitter: Sending event {} for session {}", (Object)event.id(), (Object)sessionId);
                        emitter.send(SseEmitter.event().data((Object)event.toJson()));
                    }
                    catch (IOException e) {
                        log.error("SseEmitter: IOException sending event for session {}: {}", (Object)sessionId, (Object)e.getMessage());
                        throw new RuntimeException("Failed to send event", e);
                    }
                    catch (Exception e) {
                        log.error("SseEmitter: Unexpected error sending event for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
                        throw new RuntimeException("Unexpected error sending event", e);
                    }
                }, error -> {
                    log.error("SseEmitter: Stream error for session {}: {}", new Object[]{sessionId, error.getMessage(), error});
                    try {
                        emitter.completeWithError(error);
                    }
                    catch (Exception ex) {
                        log.warn("Error completing emitter after stream error for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                    }
                }, () -> {
                    log.debug("SseEmitter: Stream completed normally for session: {}", (Object)sessionId);
                    try {
                        emitter.complete();
                    }
                    catch (Exception ex) {
                        log.warn("Error completing emitter after normal completion for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                    }
                });
                emitter.onCompletion(() -> {
                    log.debug("SseEmitter: onCompletion callback for session: {}. Disposing subscription.", (Object)sessionId);
                    if (!disposable.isDisposed()) {
                        disposable.dispose();
                    }
                });
                emitter.onTimeout(() -> {
                    log.debug("SseEmitter: onTimeout callback for session: {}. Disposing subscription and completing.", (Object)sessionId);
                    if (!disposable.isDisposed()) {
                        disposable.dispose();
                    }
                    emitter.complete();
                });
            });
            log.debug("SseEmitter: Returning emitter for session: {}", (Object)sessionId);
            return emitter;
        }

        @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/events/{eventId}/graph"})
        public ResponseEntity<GraphResponse> getEventGraph(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String eventId) {
            BaseAgent currentAppAgent;
            log.info("Request received for GET /apps/{}/users/{}/sessions/{}/events/{}/graph", new Object[]{appName, userId, sessionId, eventId});
            try {
                currentAppAgent = this.agentProvider.loadAgent(appName);
            }
            catch (NoSuchElementException e2) {
                log.warn("Agent app '{}' not found for graph generation.", (Object)appName);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new GraphResponse("Agent app not found: " + appName));
            }
            catch (IllegalStateException e3) {
                log.warn("Agent app '{}' failed to load for graph generation: {}", (Object)appName, (Object)e3.getMessage());
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new GraphResponse("Agent app failed to load: " + appName));
            }
            Session session = this.findSessionOrThrow(appName, userId, sessionId);
            Event event = session.events().stream().filter(e -> Objects.equals(e.id(), eventId)).findFirst().orElse(null);
            if (event == null) {
                log.warn("Event {} not found in session {}", (Object)eventId, (Object)sessionId);
                return ResponseEntity.ok((Object)new GraphResponse(null));
            }
            log.debug("Found event {} for graph generation.", (Object)eventId);
            ArrayList<List<String>> highlightPairs = new ArrayList<List<String>>();
            String eventAuthor = event.author();
            ImmutableList functionCalls = event.functionCalls();
            ImmutableList functionResponses = event.functionResponses();
            if (!functionCalls.isEmpty()) {
                log.debug("Processing {} function calls for highlighting.", (Object)functionCalls.size());
                for (FunctionCall fc : functionCalls) {
                    Optional toolName = fc.name();
                    if (!toolName.isPresent() || ((String)toolName.get()).isEmpty()) continue;
                    highlightPairs.add((List<String>)ImmutableList.of((Object)eventAuthor, (Object)((String)toolName.get())));
                    log.trace("Adding function call highlight: {} -> {}", (Object)eventAuthor, toolName.get());
                }
            } else if (!functionResponses.isEmpty()) {
                log.debug("Processing {} function responses for highlighting.", (Object)functionResponses.size());
                for (FunctionResponse fr : functionResponses) {
                    Optional toolName = fr.name();
                    if (!toolName.isPresent() || ((String)toolName.get()).isEmpty()) continue;
                    highlightPairs.add((List<String>)ImmutableList.of((Object)((String)toolName.get()), (Object)eventAuthor));
                    log.trace("Adding function response highlight: {} -> {}", toolName.get(), (Object)eventAuthor);
                }
            } else {
                log.debug("Processing simple event, highlighting author: {}", (Object)eventAuthor);
                highlightPairs.add((List<String>)ImmutableList.of((Object)eventAuthor, (Object)eventAuthor));
            }
            Optional<String> dotSourceOpt = AgentGraphGenerator.getAgentGraphDotSource(currentAppAgent, highlightPairs);
            if (dotSourceOpt.isPresent()) {
                log.debug("Successfully generated graph DOT source for event {}", (Object)eventId);
                return ResponseEntity.ok((Object)new GraphResponse(dotSourceOpt.get()));
            }
            log.warn("Failed to generate graph DOT source for event {} with agent {}", (Object)eventId, (Object)currentAppAgent.name());
            return ResponseEntity.ok((Object)new GraphResponse("Could not generate graph for this event."));
        }

        @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}"})
        public ResponseEntity<Object> createEvalSet(@PathVariable String appName, @PathVariable String evalSetId) {
            log.warn("Endpoint /apps/{}/eval_sets/{} (POST) is not implemented", (Object)appName, (Object)evalSetId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Eval set creation not implemented"));
        }

        @GetMapping(value={"/apps/{appName}/eval_sets"})
        public List<String> listEvalSets(@PathVariable String appName) {
            log.warn("Endpoint /apps/{}/eval_sets (GET) is not implemented", (Object)appName);
            return Collections.emptyList();
        }

        @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/add-session"})
        public ResponseEntity<Object> addSessionToEvalSet(@PathVariable String appName, @PathVariable String evalSetId, @RequestBody AddSessionToEvalSetRequest req) {
            log.warn("Endpoint /apps/{}/eval_sets/{}/add-session is not implemented. Request details: evalId={}, sessionId={}, userId={}", new Object[]{appName, evalSetId, req.getEvalId(), req.getSessionId(), req.getUserId()});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Adding session to eval set not implemented"));
        }

        @GetMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/evals"})
        public List<String> listEvalsInEvalSet(@PathVariable String appName, @PathVariable String evalSetId) {
            log.warn("Endpoint /apps/{}/eval_sets/{}/evals is not implemented", (Object)appName, (Object)evalSetId);
            return Collections.emptyList();
        }

        @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/run-eval"})
        public List<RunEvalResult> runEval(@PathVariable String appName, @PathVariable String evalSetId, @RequestBody RunEvalRequest req) {
            log.warn("Endpoint /apps/{}/eval_sets/{}/run-eval is not implemented. Request details: evalIds={}, evalMetrics={}", new Object[]{appName, evalSetId, req.getEvalIds(), req.getEvalMetrics()});
            return Collections.emptyList();
        }

        @GetMapping(value={"/apps/{appName}/eval_results/{evalResultId}"})
        public ResponseEntity<Object> getEvalResult(@PathVariable String appName, @PathVariable String evalResultId) {
            log.warn("Endpoint /apps/{}/eval_results/{} (GET) is not implemented", (Object)appName, (Object)evalResultId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Get evaluation result not implemented"));
        }

        @GetMapping(value={"/apps/{appName}/eval_results"})
        public List<String> listEvalResults(@PathVariable String appName) {
            log.warn("Endpoint /apps/{}/eval_results (GET) is not implemented", (Object)appName);
            return Collections.emptyList();
        }
    }

    public static class GraphResponse {
        @JsonProperty(value="dotSrc")
        public String dotSrc;

        public GraphResponse(String dotSrc) {
            this.dotSrc = dotSrc;
        }

        public GraphResponse() {
        }

        public String getDotSrc() {
            return this.dotSrc;
        }
    }

    public static class RunEvalResult
    extends JsonBaseModel {
        @JsonProperty(value="appName")
        public String appName;
        @JsonProperty(value="evalSetId")
        public String evalSetId;
        @JsonProperty(value="evalId")
        public String evalId;
        @JsonProperty(value="finalEvalStatus")
        public String finalEvalStatus;
        @JsonProperty(value="evalMetricResults")
        public List<List<Object>> evalMetricResults;
        @JsonProperty(value="sessionId")
        public String sessionId;

        public RunEvalResult(String appName, String evalSetId, String evalId, String finalEvalStatus, List<List<Object>> evalMetricResults, String sessionId) {
            this.appName = appName;
            this.evalSetId = evalSetId;
            this.evalId = evalId;
            this.finalEvalStatus = finalEvalStatus;
            this.evalMetricResults = evalMetricResults;
            this.sessionId = sessionId;
        }

        public RunEvalResult() {
        }
    }

    public static class RunEvalRequest {
        @JsonProperty(value="evalIds")
        public List<String> evalIds;
        @JsonProperty(value="evalMetrics")
        public List<String> evalMetrics;

        public List<String> getEvalIds() {
            return this.evalIds;
        }

        public List<String> getEvalMetrics() {
            return this.evalMetrics;
        }
    }

    public static class AddSessionToEvalSetRequest {
        @JsonProperty(value="evalId")
        public String evalId;
        @JsonProperty(value="sessionId")
        public String sessionId;
        @JsonProperty(value="userId")
        public String userId;

        public String getEvalId() {
            return this.evalId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getUserId() {
            return this.userId;
        }
    }

    public static class AgentRunRequest {
        @JsonProperty(value="appName")
        public String appName;
        @JsonProperty(value="userId")
        public String userId;
        @JsonProperty(value="sessionId")
        public String sessionId;
        @JsonProperty(value="newMessage")
        public Content newMessage;
        @JsonProperty(value="streaming")
        public boolean streaming = false;

        public String getAppName() {
            return this.appName;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Content getNewMessage() {
            return this.newMessage;
        }

        public boolean getStreaming() {
            return this.streaming;
        }
    }

    public static class ApiServerSpanExporter
    implements SpanExporter {
        private static final Logger exporterLog = LoggerFactory.getLogger(ApiServerSpanExporter.class);
        private final Map<String, Map<String, Object>> eventIdTraceStorage = new ConcurrentHashMap<String, Map<String, Object>>();
        private final Map<String, List<String>> sessionToTraceIdsMap = new ConcurrentHashMap<String, List<String>>();
        private final List<SpanData> allExportedSpans = Collections.synchronizedList(new ArrayList());

        public Map<String, Object> getEventTraceAttributes(String eventId) {
            return this.eventIdTraceStorage.get(eventId);
        }

        public Map<String, List<String>> getSessionToTraceIdsMap() {
            return this.sessionToTraceIdsMap;
        }

        public List<SpanData> getAllExportedSpans() {
            return this.allExportedSpans;
        }

        public CompletableResultCode export(Collection<SpanData> spans) {
            exporterLog.debug("ApiServerSpanExporter received {} spans to export.", (Object)spans.size());
            ArrayList<SpanData> currentBatch = new ArrayList<SpanData>(spans);
            this.allExportedSpans.addAll(currentBatch);
            for (SpanData span : currentBatch) {
                String spanName = span.getName();
                if ("call_llm".equals(spanName) || "send_data".equals(spanName) || spanName != null && spanName.startsWith("tool_response")) {
                    String eventId = (String)span.getAttributes().get(AttributeKey.stringKey((String)"gcp.vertex.agent.event_id"));
                    if (eventId != null && !eventId.isEmpty()) {
                        HashMap<String, String> attributesMap = new HashMap<String, String>();
                        span.getAttributes().forEach((key, value) -> attributesMap.put(key.getKey(), (String)value));
                        attributesMap.put("trace_id", span.getSpanContext().getTraceId());
                        attributesMap.put("span_id", span.getSpanContext().getSpanId());
                        attributesMap.putIfAbsent("gcp.vertex.agent.event_id", eventId);
                        exporterLog.debug("Storing event-based trace attributes for event_id: {}", (Object)eventId);
                        this.eventIdTraceStorage.put(eventId, attributesMap);
                    } else {
                        exporterLog.trace("Span {} for event-based trace did not have 'gcp.vertex.agent.event_id' attribute or it was empty.", (Object)spanName);
                    }
                }
                if (!"call_llm".equals(spanName)) continue;
                String sessionId = (String)span.getAttributes().get(AttributeKey.stringKey((String)"gcp.vertex.agent.session_id"));
                if (sessionId != null && !sessionId.isEmpty()) {
                    String traceId = span.getSpanContext().getTraceId();
                    this.sessionToTraceIdsMap.computeIfAbsent(sessionId, k -> Collections.synchronizedList(new ArrayList())).add(traceId);
                    exporterLog.trace("Associated trace_id {} with session_id {} for session tracing", (Object)traceId, (Object)sessionId);
                    continue;
                }
                exporterLog.trace("Span {} for session trace did not have 'gcp.vertex.agent.session_id' attribute.", (Object)spanName);
            }
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode shutdown() {
            exporterLog.debug("Shutting down ApiServerSpanExporter.");
            return CompletableResultCode.ofSuccess();
        }
    }

    @Configuration
    public static class OpenTelemetryConfig {
        private static final Logger otelLog = LoggerFactory.getLogger(OpenTelemetryConfig.class);

        @Bean
        public ApiServerSpanExporter apiServerSpanExporter() {
            return new ApiServerSpanExporter();
        }

        @Bean(destroyMethod="shutdown")
        public SdkTracerProvider sdkTracerProvider(ApiServerSpanExporter apiServerSpanExporter) {
            otelLog.debug("Configuring SdkTracerProvider with ApiServerSpanExporter.");
            Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"adk-web-server")));
            return SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)apiServerSpanExporter)).setResource(resource).build();
        }

        @Bean
        public OpenTelemetry openTelemetrySdk(SdkTracerProvider sdkTracerProvider) {
            otelLog.debug("Configuring OpenTelemetrySdk and registering globally.");
            OpenTelemetrySdk otelSdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).buildAndRegisterGlobal();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((OpenTelemetrySdk)otelSdk).close()));
            return otelSdk;
        }
    }

    @Component
    public static class RunnerService {
        private static final Logger log = LoggerFactory.getLogger(RunnerService.class);
        private final AgentLoader agentProvider;
        private final BaseArtifactService artifactService;
        private final BaseSessionService sessionService;
        private final Map<String, Runner> runnerCache = new ConcurrentHashMap<String, Runner>();

        @Autowired
        public RunnerService(@Qualifier(value="agentLoader") AgentLoader agentProvider, BaseArtifactService artifactService, BaseSessionService sessionService) {
            this.agentProvider = agentProvider;
            this.artifactService = artifactService;
            this.sessionService = sessionService;
        }

        public Runner getRunner(String appName) {
            return this.runnerCache.computeIfAbsent(appName, key -> {
                try {
                    BaseAgent agent = this.agentProvider.loadAgent((String)key);
                    log.info("RunnerService: Creating Runner for appName: {}, using agent definition: {}", (Object)appName, (Object)agent.name());
                    return new Runner(agent, appName, this.artifactService, this.sessionService);
                }
                catch (NoSuchElementException e) {
                    log.error("Agent/App named '{}' not found in registry. Available apps: {}", key, this.agentProvider.listAgents());
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Agent/App not found: " + key);
                }
                catch (IllegalStateException e) {
                    log.error("Agent '{}' exists but failed to load: {}", key, (Object)e.getMessage());
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent failed to load: " + key, (Throwable)e);
                }
            });
        }

        public void onAgentUpdated(String agentName) {
            Runner removed = this.runnerCache.remove(agentName);
            if (removed != null) {
                log.info("Cleared cached Runner for updated agent: {}", (Object)agentName);
            } else {
                log.debug("No cached Runner found for agent: {}", (Object)agentName);
            }
        }
    }
}

