/*
 * Decompiled with CFR 0.152.
 */
package io.testcontainers.arangodb.containers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ArangoContainer
extends GenericContainer<ArangoContainer> {
    public static final String LATEST = "latest";
    public static final Integer DEFAULT_PORT = 8529;
    public static final String DEFAULT_USER = "root";
    private static final String IMAGE = "arangodb";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"arangodb");
    private static final String ARANGO_NO_AUTH = "ARANGO_NO_AUTH";
    private static final String ARANGO_ROOT_PASSWORD = "ARANGO_ROOT_PASSWORD";
    private static final String ARANGO_RANDOM_ROOT_PASSWORD = "ARANGO_RANDOM_ROOT_PASSWORD";
    private String password;

    public ArangoContainer(String version) {
        this(DockerImageName.parse((String)IMAGE).withTag(version));
    }

    public ArangoContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(DEFAULT_PORT);
        this.withLogConsumer(this.getOutputConsumer());
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*is ready for business. Have fun!.*", (int)1));
    }

    protected Consumer<OutputFrame> getOutputConsumer() {
        return new Slf4jLogConsumer(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
    }

    public ArangoContainer withPassword(String password) {
        if (this.getEnvMap().containsKey(ARANGO_NO_AUTH) || this.getEnvMap().containsKey(ARANGO_RANDOM_ROOT_PASSWORD)) {
            this.throwAuthException();
        }
        this.withEnv(ARANGO_ROOT_PASSWORD, password);
        this.password = password;
        return (ArangoContainer)this.self();
    }

    public ArangoContainer withoutAuth() {
        if (this.getEnvMap().containsKey(ARANGO_ROOT_PASSWORD) || this.getEnvMap().containsKey(ARANGO_RANDOM_ROOT_PASSWORD)) {
            this.throwAuthException();
        }
        this.withEnv(ARANGO_NO_AUTH, "1");
        return (ArangoContainer)this.self();
    }

    public ArangoContainer withRandomPassword() {
        if (this.getEnvMap().containsKey(ARANGO_ROOT_PASSWORD) || this.getEnvMap().containsKey(ARANGO_NO_AUTH)) {
            this.throwAuthException();
        }
        this.withEnv(ARANGO_RANDOM_ROOT_PASSWORD, "1");
        return (ArangoContainer)this.self();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return DEFAULT_USER;
    }

    public Integer getPort() {
        return this.getMappedPort(DEFAULT_PORT);
    }

    public ArangoContainer withFixedPort(int port) {
        this.setExposedPorts(new ArrayList<Integer>());
        this.addFixedExposedPort(port, DEFAULT_PORT);
        return (ArangoContainer)this.self();
    }

    private void throwAuthException() {
        throw new IllegalArgumentException("Random or without authentication is enable, please review your configuration");
    }

    public void setExposedPorts(List<Integer> exposedPorts) {
        this.setPortBindings(new ArrayList());
        super.setExposedPorts(exposedPorts);
    }

    public void addExposedPorts(int ... ports) {
        this.setPortBindings(new ArrayList());
        super.addExposedPorts(ports);
    }

    public void addExposedPort(Integer port) {
        this.setPortBindings(new ArrayList());
        super.addExposedPort(port);
    }
}

