/*
 * Decompiled with CFR 0.152.
 */
package io.testcontainers.arangodb.cluster;

import io.testcontainers.arangodb.containers.ArangoContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class ArangoClusterContainer
extends ArangoContainer {
    private String alias;
    private String endpoint;
    private NodeType type;

    protected ArangoClusterContainer(String version) {
        super(version);
    }

    @Override
    protected Consumer<OutputFrame> getOutputConsumer() {
        return new Slf4jLogConsumer(LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + " [" + (Object)((Object)this.type) + "]")));
    }

    protected ArangoClusterContainer withAgentEndpoints(Collection<String> agentEndpoints) {
        String prefix = NodeType.AGENT.equals((Object)this.type) || NodeType.AGENT_LEADER.equals((Object)this.type) ? "--agency.endpoint" : "--cluster.agency-endpoint";
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(this.getCommandParts()));
        agentEndpoints.forEach(agentEndpoint -> {
            cmd.add(prefix);
            cmd.add((String)agentEndpoint);
        });
        this.setCommand(cmd.toArray(new String[0]));
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public NodeType getType() {
        return this.type;
    }

    protected static ArangoClusterContainer agent(String alias, int port, String version, int totalAgentNodes, boolean leader, boolean expose) {
        String endpoint = ArangoClusterContainer.getEndpoint(alias);
        List<String> cmd = ArangoClusterContainer.getCommonCommand(alias);
        cmd.add("--agency.my-address " + endpoint);
        cmd.add("--agency.activate true");
        cmd.add("--agency.size " + totalAgentNodes);
        cmd.add("--agency.supervision true");
        ArangoClusterContainer container = ArangoClusterContainer.build(version, cmd, alias, port, expose);
        container.type = leader ? NodeType.AGENT_LEADER : NodeType.AGENT;
        container.endpoint = endpoint;
        container.alias = alias;
        container.setNetworkAliases(Collections.singletonList(alias));
        return container;
    }

    protected static ArangoClusterContainer dbserver(String alias, int port, String version, boolean expose) {
        String endpoint = ArangoClusterContainer.getEndpoint(alias);
        List<String> cmd = ArangoClusterContainer.getCommonCommand(alias);
        cmd.add("--cluster.my-local-info " + alias);
        cmd.add("--cluster.my-role DBSERVER");
        cmd.add("--cluster.my-address " + endpoint);
        ArangoClusterContainer container = ArangoClusterContainer.build(version, cmd, alias, port, expose);
        container.endpoint = endpoint;
        container.type = NodeType.DBSERVER;
        container.alias = alias;
        container.setNetworkAliases(Collections.singletonList(alias));
        return container;
    }

    protected static ArangoClusterContainer coordinator(String alias, int port, String version) {
        String endpoint = ArangoClusterContainer.getEndpoint(alias);
        List<String> cmd = ArangoClusterContainer.getCommonCommand(alias);
        cmd.add("--cluster.my-local-info " + alias);
        cmd.add("--cluster.my-role COORDINATOR");
        cmd.add("--cluster.my-address " + endpoint);
        ArangoClusterContainer container = ArangoClusterContainer.build(version, cmd, alias, port, true);
        container.endpoint = endpoint;
        container.type = NodeType.COORDINATOR;
        container.alias = alias;
        container.setNetworkAliases(Collections.singletonList(alias));
        return container;
    }

    private static List<String> getCommonCommand(String alias) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("arangod");
        cmd.add("--server.authentication=false");
        cmd.add("--server.endpoint tcp://0.0.0.0:" + ArangoContainer.DEFAULT_PORT);
        return cmd;
    }

    private static String getEndpoint(String alias) {
        return "tcp://" + alias + ":" + ArangoContainer.DEFAULT_PORT;
    }

    private static ArangoClusterContainer build(String version, List<String> commandArguments, String networkAliasName, int port, boolean expose) {
        String cmd = (String)commandArguments.stream().reduce((s1, s2) -> s1 + " " + s2).orElseThrow(() -> new IllegalArgumentException("No Args"));
        ArangoClusterContainer container = (ArangoClusterContainer)((ArangoContainer)new ArangoClusterContainer(version).withoutAuth().withNetworkAliases(new String[]{networkAliasName})).withCommand(cmd);
        return expose ? (ArangoClusterContainer)container.withFixedPort(port) : container;
    }

    public String getContainerName() {
        return this.alias;
    }

    public static enum NodeType {
        AGENT_LEADER("agentLeader"),
        AGENT("agent"),
        DBSERVER("dbserver"),
        COORDINATOR("coordinator");

        private final String alias;

        private NodeType(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getAlias(int number) {
            return this.equals((Object)AGENT_LEADER) ? this.alias : this.alias + number;
        }
    }
}

