/*
 * Decompiled with CFR 0.152.
 */
package com.gluehome.common.data.log;

import com.gluehome.common.data.log.LoggerExtraInfo;
import com.sematext.logseneandroid.Logsene;
import com.sematext.logseneandroid.Utils;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/gluehome/common/data/log/SematextTree;", "Ltimber/log/Timber$Tree;", "logsene", "Lcom/sematext/logseneandroid/Logsene;", "loggerExtraInfo", "Lcom/gluehome/common/data/log/LoggerExtraInfo;", "(Lcom/sematext/logseneandroid/Logsene;Lcom/gluehome/common/data/log/LoggerExtraInfo;)V", "log", "", "priority", "", "tag", "", "message", "t", "", "mapPriorityToText", "logger_release"})
public final class SematextTree
extends Timber.Tree {
    private final Logsene logsene;
    private final LoggerExtraInfo loggerExtraInfo;

    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Map<String, Object> extra;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Map fullInfo = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"level", (Object)this.mapPriorityToText(priority)), TuplesKt.to((Object)"message", (Object)message)});
        if (priority == 6 && t != null) {
            String string = t.getClass().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"t.javaClass.toString()");
            fullInfo.put("exception", string);
            String string2 = t.getMessage();
            if (string2 == null) {
                string2 = "empty error message";
            }
            fullInfo.put("message", string2);
            String string3 = t.getLocalizedMessage();
            if (string3 == null) {
                string3 = "empty localizedMessage";
            }
            fullInfo.put("localized_message", string3);
            String string4 = Utils.getStackTrace((Throwable)t);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Utils.getStackTrace(t)");
            fullInfo.put("stacktrace", string4);
        }
        Map<String, Object> $this$forEach$iv = extra = this.loggerExtraInfo.getAll();
        boolean $i$f$forEach = false;
        Map<String, Object> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> it = element$iv = iterator.next();
            boolean bl2 = false;
            fullInfo.put(it.getKey(), it.getValue());
        }
        Map map2 = fullInfo;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        this.logsene.event(new JSONObject(map2));
    }

    private final String mapPriorityToText(int priority) {
        String string;
        switch (priority) {
            case 4: {
                string = "info";
                break;
            }
            case 5: {
                string = "warn";
                break;
            }
            case 6: {
                string = "error";
                break;
            }
            default: {
                string = "debug";
            }
        }
        return string;
    }

    public SematextTree(@NotNull Logsene logsene, @NotNull LoggerExtraInfo loggerExtraInfo) {
        Intrinsics.checkParameterIsNotNull((Object)logsene, (String)"logsene");
        Intrinsics.checkParameterIsNotNull((Object)loggerExtraInfo, (String)"loggerExtraInfo");
        this.logsene = logsene;
        this.loggerExtraInfo = loggerExtraInfo;
    }
}

