/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.List;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import sharpen.core.AbstractNestedClassBuilder;
import sharpen.core.CSharpBuilder;
import sharpen.core.csharp.ast.CSBaseExpression;
import sharpen.core.csharp.ast.CSConstructor;
import sharpen.core.csharp.ast.CSConstructorInvocationExpression;
import sharpen.core.csharp.ast.CSField;
import sharpen.core.csharp.ast.CSReferenceExpression;
import sharpen.core.csharp.ast.CSTypeDeclaration;
import sharpen.core.csharp.ast.CSVariableDeclaration;
import sharpen.core.csharp.ast.CSVisibility;

public class NonStaticNestedClassBuilder
extends AbstractNestedClassBuilder {
    private TypeDeclaration _nestedType;
    private CSTypeDeclaration _convertedType;
    private CSField _enclosingField;

    public NonStaticNestedClassBuilder(CSharpBuilder other, TypeDeclaration nestedType) {
        super(other);
        this._nestedType = nestedType;
        this._convertedType = this.processTypeDeclaration((AbstractTypeDeclaration)this._nestedType);
        this._enclosingField = this.createEnclosingField();
        this.patchConstructors();
        this._convertedType.addMember(this._enclosingField);
    }

    private void patchConstructors() {
        List<CSConstructor> ctors = this._convertedType.constructors();
        if (ctors.isEmpty()) {
            this.introduceConstructor();
        } else {
            for (CSConstructor ctor : ctors) {
                this.patchConstructor(ctor);
            }
        }
    }

    private void patchConstructor(CSConstructor ctor) {
        ctor.addParameter(0, new CSVariableDeclaration(this._enclosingField.name(), this._enclosingField.type()));
        ctor.body().addStatement(0, this.createFieldAssignment(this._enclosingField.name(), this._enclosingField.name()));
        ITypeBinding superClass = this.nestedTypeBinding().getSuperclass();
        if (superClass != null && this.isNonStaticNestedType(superClass)) {
            CSConstructorInvocationExpression cie = new CSConstructorInvocationExpression(new CSBaseExpression());
            cie.addArgument(new CSReferenceExpression(this._enclosingField.name()));
            ctor.chainedConstructorInvocation(cie);
        }
    }

    private void introduceConstructor() {
        CSConstructor ctor = new CSConstructor();
        ctor.visibility(CSVisibility.Internal);
        this.patchConstructor(ctor);
        this._convertedType.addMember(ctor);
    }

    @Override
    protected ITypeBinding nestedTypeBinding() {
        return this._nestedType.resolveBinding();
    }
}

