/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.lang.reflect.Constructor;
import sharpen.core.Configuration;
import sharpen.core.DefaultConfiguration;

public class ConfigurationFactory {
    public static final String DEFAULT_RUNTIME_TYPE_NAME = "Sharpen.Runtime";

    private ConfigurationFactory() {
    }

    public static Configuration defaultConfiguration() {
        return ConfigurationFactory.newConfiguration(null);
    }

    public static Configuration newConfiguration(String configurationClass) {
        return ConfigurationFactory.newConfiguration(configurationClass, DEFAULT_RUNTIME_TYPE_NAME);
    }

    public static Configuration newConfiguration(String configurationClass, String runtimeTypeName) {
        if (runtimeTypeName == null) {
            runtimeTypeName = DEFAULT_RUNTIME_TYPE_NAME;
        }
        if (configurationClass == null) {
            return new DefaultConfiguration(runtimeTypeName);
        }
        try {
            Constructor<?> ctor = Class.forName(configurationClass).getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            return (Configuration)ctor.newInstance(runtimeTypeName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate configuration class: " + configurationClass, e);
        }
    }
}

