/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.start;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.hjq.permissions.start.IStartActivityDelegate;
import com.hjq.permissions.tools.PermissionUtils;

public final class StartActivityDelegateByContext
implements IStartActivityDelegate {
    @NonNull
    private final Context mContext;

    public StartActivityDelegateByContext(@NonNull Context context) {
        this.mContext = context;
    }

    @Override
    public void startActivity(@NonNull Intent intent) {
        Activity activity = PermissionUtils.findActivity(this.mContext);
        if (activity != null) {
            activity.startActivity(intent);
            return;
        }
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    @Override
    public void startActivityForResult(@NonNull Intent intent, @IntRange(from=1L, to=65535L) int requestCode) {
        Activity activity = PermissionUtils.findActivity(this.mContext);
        if (activity != null) {
            activity.startActivityForResult(intent, requestCode);
            return;
        }
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }
}

