/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class UseFullScreenIntentPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.USE_FULL_SCREEN_INTENT";
    public static final Parcelable.Creator<UseFullScreenIntentPermission> CREATOR = new Parcelable.Creator<UseFullScreenIntentPermission>(){

        public UseFullScreenIntentPermission createFromParcel(Parcel source) {
            return new UseFullScreenIntentPermission(source);
        }

        public UseFullScreenIntentPermission[] newArray(int size) {
            return new UseFullScreenIntentPermission[size];
        }
    };

    public UseFullScreenIntentPermission() {
    }

    private UseFullScreenIntentPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 34;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid14()) {
            return true;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (notificationManager == null) {
            return false;
        }
        return notificationManager.canUseFullScreenIntent();
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (PermissionVersion.isAndroid14()) {
            intent = new Intent("android.settings.MANAGE_APP_USE_FULL_SCREEN_INTENT");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
        }
        if (DeviceOs.isHyperOs() || DeviceOs.isMiui()) {
            intent = this.getAndroidSettingIntent();
            intentList.add(intent);
            return intentList;
        }
        if (PermissionVersion.isAndroid8()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = UseFullScreenIntentPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = UseFullScreenIntentPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        if (!PermissionUtils.containsPermission(requestList, "android.permission.NOTIFICATION_SERVICE") && !PermissionUtils.containsPermission(requestList, "android.permission.POST_NOTIFICATIONS")) {
            throw new IllegalArgumentException("The \"" + this.getPermissionName() + "\" needs to be used together with the notification permission. (\"" + "android.permission.NOTIFICATION_SERVICE" + "\" or \"" + "android.permission.POST_NOTIFICATIONS" + "\")");
        }
        int thisPermissionIndex = -1;
        int notificationServicePermissionIndex = -1;
        int postNotificationsPermissionIndex = -1;
        for (int i = 0; i < requestList.size(); ++i) {
            IPermission permission2 = requestList.get(i);
            if (PermissionUtils.equalsPermission(permission2, this.getPermissionName())) {
                thisPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
                notificationServicePermissionIndex = i;
                continue;
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) continue;
            postNotificationsPermissionIndex = i;
        }
        if (notificationServicePermissionIndex != -1 && notificationServicePermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the " + this.getPermissionName() + "\" permission after the \"" + "android.permission.NOTIFICATION_SERVICE" + "\" permission");
        }
        if (postNotificationsPermissionIndex != -1 && postNotificationsPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.POST_NOTIFICATIONS" + "\" permission");
        }
    }
}

