/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class ScheduleExactAlarmPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.SCHEDULE_EXACT_ALARM";
    public static final Parcelable.Creator<ScheduleExactAlarmPermission> CREATOR = new Parcelable.Creator<ScheduleExactAlarmPermission>(){

        public ScheduleExactAlarmPermission createFromParcel(Parcel source) {
            return new ScheduleExactAlarmPermission(source);
        }

        public ScheduleExactAlarmPermission[] newArray(int size) {
            return new ScheduleExactAlarmPermission[size];
        }
    };

    public ScheduleExactAlarmPermission() {
    }

    private ScheduleExactAlarmPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 31;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid12()) {
            return true;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService(AlarmManager.class);
        if (alarmManager == null) {
            return false;
        }
        return alarmManager.canScheduleExactAlarms();
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (PermissionVersion.isAndroid12()) {
            intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = ScheduleExactAlarmPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = ScheduleExactAlarmPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return false;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        String useExactAlarmPermissionName = PermissionVersion.isAndroid13() ? "android.permission.USE_EXACT_ALARM" : "android.permission.USE_EXACT_ALARM";
        if (PermissionVersion.getTargetVersion((Context)activity) >= 33 && ScheduleExactAlarmPermission.findPermissionInfoByList(permissionInfoList, useExactAlarmPermissionName) != null) {
            ScheduleExactAlarmPermission.checkPermissionRegistrationStatus(permissionInfoList, this.getPermissionName(), 32);
            return;
        }
        ScheduleExactAlarmPermission.checkPermissionRegistrationStatus(permissionInfoList, this.getPermissionName());
    }
}

