/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ActivityManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class PictureInPicturePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.PICTURE_IN_PICTURE";
    public static final Parcelable.Creator<PictureInPicturePermission> CREATOR = new Parcelable.Creator<PictureInPicturePermission>(){

        public PictureInPicturePermission createFromParcel(Parcel source) {
            return new PictureInPicturePermission(source);
        }

        public PictureInPicturePermission[] newArray(int size) {
            return new PictureInPicturePermission[size];
        }
    };

    public PictureInPicturePermission() {
    }

    private PictureInPicturePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 26;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid8()) {
            return true;
        }
        return PictureInPicturePermission.checkOpPermission(context, "android:picture_in_picture", true);
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (PermissionVersion.isAndroid8()) {
            String action = "android.settings.PICTURE_IN_PICTURE_SETTINGS";
            intent = new Intent(action);
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent(action);
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = PictureInPicturePermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = PictureInPicturePermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        List<ActivityManifestInfo> activityInfoList = manifestInfo.activityInfoList;
        for (int i = 0; i < activityInfoList.size(); ++i) {
            boolean supportsPictureInPicture = activityInfoList.get((int)i).supportsPictureInPicture;
            if (!supportsPictureInPicture) continue;
            return;
        }
        throw new IllegalArgumentException("No Activity was found to have registered the android:supportsPictureInPicture=\"true\" property, Please register this property to " + activity.getClass().getName() + " class by AndroidManifest.xml file, otherwise it will lead to can't apply for the permission");
    }
}

