/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission;

import android.accessibilityservice.AccessibilityService;
import android.app.admin.DeviceAdminReceiver;
import android.service.notification.NotificationListenerService;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.dangerous.AccessBackgroundLocationPermission;
import com.hjq.permissions.permission.dangerous.AccessMediaLocationPermission;
import com.hjq.permissions.permission.dangerous.BluetoothAdvertisePermission;
import com.hjq.permissions.permission.dangerous.BluetoothConnectPermission;
import com.hjq.permissions.permission.dangerous.BluetoothScanPermission;
import com.hjq.permissions.permission.dangerous.BodySensorsBackgroundPermission;
import com.hjq.permissions.permission.dangerous.BodySensorsPermission;
import com.hjq.permissions.permission.dangerous.GetInstalledAppsPermission;
import com.hjq.permissions.permission.dangerous.NearbyWifiDevicesPermission;
import com.hjq.permissions.permission.dangerous.PostNotificationsPermission;
import com.hjq.permissions.permission.dangerous.ReadExternalStoragePermission;
import com.hjq.permissions.permission.dangerous.ReadHealthDataHistoryPermission;
import com.hjq.permissions.permission.dangerous.ReadHealthDataInBackgroundPermission;
import com.hjq.permissions.permission.dangerous.ReadHealthRatePermission;
import com.hjq.permissions.permission.dangerous.ReadMediaAudioPermission;
import com.hjq.permissions.permission.dangerous.ReadMediaImagesPermission;
import com.hjq.permissions.permission.dangerous.ReadMediaVideoPermission;
import com.hjq.permissions.permission.dangerous.ReadMediaVisualUserSelectedPermission;
import com.hjq.permissions.permission.dangerous.ReadPhoneNumbersPermission;
import com.hjq.permissions.permission.dangerous.StandardDangerousPermission;
import com.hjq.permissions.permission.dangerous.StandardFitnessAndWellnessDataPermission;
import com.hjq.permissions.permission.dangerous.StandardHealthRecordsPermission;
import com.hjq.permissions.permission.dangerous.WriteExternalStoragePermission;
import com.hjq.permissions.permission.special.AccessNotificationPolicyPermission;
import com.hjq.permissions.permission.special.BindAccessibilityServicePermission;
import com.hjq.permissions.permission.special.BindDeviceAdminPermission;
import com.hjq.permissions.permission.special.BindNotificationListenerServicePermission;
import com.hjq.permissions.permission.special.BindVpnServicePermission;
import com.hjq.permissions.permission.special.ManageExternalStoragePermission;
import com.hjq.permissions.permission.special.ManageMediaPermission;
import com.hjq.permissions.permission.special.NotificationServicePermission;
import com.hjq.permissions.permission.special.PackageUsageStatsPermission;
import com.hjq.permissions.permission.special.PictureInPicturePermission;
import com.hjq.permissions.permission.special.RequestIgnoreBatteryOptimizationsPermission;
import com.hjq.permissions.permission.special.RequestInstallPackagesPermission;
import com.hjq.permissions.permission.special.ScheduleExactAlarmPermission;
import com.hjq.permissions.permission.special.SystemAlertWindowPermission;
import com.hjq.permissions.permission.special.UseFullScreenIntentPermission;
import com.hjq.permissions.permission.special.WriteSettingsPermission;
import com.hjq.permissions.tools.PermissionVersion;

public final class PermissionLists {
    private static final int PERMISSION_COUNT = 151;
    private static final LruCache<String, IPermission> PERMISSION_CACHE_MAP = new LruCache(151);

    private PermissionLists() {
    }

    @Nullable
    private static IPermission getCachePermission(@NonNull String permissionName) {
        return (IPermission)PERMISSION_CACHE_MAP.get((Object)permissionName);
    }

    private static IPermission putCachePermission(@NonNull IPermission permission) {
        PERMISSION_CACHE_MAP.put((Object)permission.getPermissionName(), (Object)permission);
        return permission;
    }

    @NonNull
    public static IPermission getGetInstalledAppsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("com.android.permission.GET_INSTALLED_APPS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new GetInstalledAppsPermission());
    }

    @NonNull
    public static IPermission getUseFullScreenIntentPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.USE_FULL_SCREEN_INTENT");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new UseFullScreenIntentPermission());
    }

    @NonNull
    public static IPermission getScheduleExactAlarmPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.SCHEDULE_EXACT_ALARM");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ScheduleExactAlarmPermission());
    }

    @NonNull
    public static IPermission getManageMediaPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.MANAGE_MEDIA");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ManageMediaPermission());
    }

    @NonNull
    public static IPermission getManageExternalStoragePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.MANAGE_EXTERNAL_STORAGE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ManageExternalStoragePermission());
    }

    @NonNull
    public static IPermission getRequestInstallPackagesPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.REQUEST_INSTALL_PACKAGES");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new RequestInstallPackagesPermission());
    }

    @NonNull
    public static IPermission getPictureInPicturePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.PICTURE_IN_PICTURE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new PictureInPicturePermission());
    }

    @NonNull
    public static IPermission getSystemAlertWindowPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.SYSTEM_ALERT_WINDOW");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new SystemAlertWindowPermission());
    }

    @NonNull
    public static IPermission getWriteSettingsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.WRITE_SETTINGS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new WriteSettingsPermission());
    }

    @NonNull
    public static IPermission getRequestIgnoreBatteryOptimizationsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new RequestIgnoreBatteryOptimizationsPermission());
    }

    @NonNull
    public static IPermission getAccessNotificationPolicyPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.ACCESS_NOTIFICATION_POLICY");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new AccessNotificationPolicyPermission());
    }

    @NonNull
    public static IPermission getPackageUsageStatsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.PACKAGE_USAGE_STATS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new PackageUsageStatsPermission());
    }

    @NonNull
    public static IPermission getBindNotificationListenerServicePermission(@NonNull Class<? extends NotificationListenerService> notificationListenerServiceClass) {
        return new BindNotificationListenerServicePermission(notificationListenerServiceClass);
    }

    @NonNull
    public static IPermission getBindVpnServicePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BIND_VPN_SERVICE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BindVpnServicePermission());
    }

    @NonNull
    public static IPermission getNotificationServicePermission(@NonNull String channelId) {
        return new NotificationServicePermission(channelId);
    }

    @NonNull
    public static IPermission getNotificationServicePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.NOTIFICATION_SERVICE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new NotificationServicePermission());
    }

    @NonNull
    public static IPermission getBindAccessibilityServicePermission(@NonNull Class<? extends AccessibilityService> accessibilityServiceClass) {
        return new BindAccessibilityServicePermission(accessibilityServiceClass);
    }

    @NonNull
    public static IPermission getBindDeviceAdminPermission(@NonNull Class<? extends DeviceAdminReceiver> deviceAdminReceiverClass, @Nullable String extraAddExplanation) {
        return new BindDeviceAdminPermission(deviceAdminReceiverClass, extraAddExplanation);
    }

    @NonNull
    public static IPermission getBindDeviceAdminPermission(@NonNull Class<? extends DeviceAdminReceiver> deviceAdminReceiverClass) {
        return new BindDeviceAdminPermission(deviceAdminReceiverClass, null);
    }

    @NonNull
    public static IPermission getReadMediaVisualUserSelectedPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_MEDIA_VISUAL_USER_SELECTED");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadMediaVisualUserSelectedPermission());
    }

    @NonNull
    public static IPermission getPostNotificationsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.POST_NOTIFICATIONS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new PostNotificationsPermission());
    }

    @NonNull
    public static IPermission getNearbyWifiDevicesPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.NEARBY_WIFI_DEVICES");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new NearbyWifiDevicesPermission());
    }

    @NonNull
    public static IPermission getBodySensorsBackgroundPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BODY_SENSORS_BACKGROUND");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BodySensorsBackgroundPermission());
    }

    @NonNull
    public static IPermission getReadMediaImagesPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_MEDIA_IMAGES");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadMediaImagesPermission());
    }

    @NonNull
    public static IPermission getReadMediaVideoPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_MEDIA_VIDEO");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadMediaVideoPermission());
    }

    @NonNull
    public static IPermission getReadMediaAudioPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_MEDIA_AUDIO");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadMediaAudioPermission());
    }

    @NonNull
    public static IPermission getBluetoothScanPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BLUETOOTH_SCAN");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BluetoothScanPermission());
    }

    @NonNull
    public static IPermission getBluetoothConnectPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BLUETOOTH_CONNECT");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BluetoothConnectPermission());
    }

    @NonNull
    public static IPermission getBluetoothAdvertisePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BLUETOOTH_ADVERTISE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BluetoothAdvertisePermission());
    }

    @NonNull
    public static IPermission getAccessBackgroundLocationPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.ACCESS_BACKGROUND_LOCATION");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new AccessBackgroundLocationPermission());
    }

    @NonNull
    public static IPermission getActivityRecognitionPermission() {
        String permissionName = "android.permission.ACTIVITY_RECOGNITION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, 29));
    }

    @NonNull
    public static IPermission getAccessMediaLocationPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.ACCESS_MEDIA_LOCATION");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new AccessMediaLocationPermission());
    }

    @NonNull
    public static IPermission getAcceptHandoverPermission() {
        String permissionName = "android.permission.ACCEPT_HANDOVER";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 28));
    }

    @NonNull
    public static IPermission getReadPhoneNumbersPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_PHONE_NUMBERS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadPhoneNumbersPermission());
    }

    @NonNull
    public static IPermission getAnswerPhoneCallsPermission() {
        String permissionName = "android.permission.ANSWER_PHONE_CALLS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 26));
    }

    @NonNull
    public static IPermission getReadExternalStoragePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.READ_EXTERNAL_STORAGE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadExternalStoragePermission());
    }

    @NonNull
    public static IPermission getWriteExternalStoragePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.WRITE_EXTERNAL_STORAGE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new WriteExternalStoragePermission());
    }

    @NonNull
    public static IPermission getCameraPermission() {
        String permissionName = "android.permission.CAMERA";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, 23));
    }

    @NonNull
    public static IPermission getRecordAudioPermission() {
        String permissionName = "android.permission.RECORD_AUDIO";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, 23));
    }

    @NonNull
    public static IPermission getAccessFineLocationPermission() {
        String permissionName = "android.permission.ACCESS_FINE_LOCATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "location_group", 23));
    }

    @NonNull
    public static IPermission getAccessCoarseLocationPermission() {
        String permissionName = "android.permission.ACCESS_COARSE_LOCATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "location_group", 23));
    }

    @NonNull
    public static IPermission getReadContactsPermission() {
        String permissionName = "android.permission.READ_CONTACTS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "contacts_group", 23));
    }

    @NonNull
    public static IPermission getWriteContactsPermission() {
        String permissionName = "android.permission.WRITE_CONTACTS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "contacts_group", 23));
    }

    @NonNull
    public static IPermission getGetAccountsPermission() {
        String permissionName = "android.permission.GET_ACCOUNTS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "contacts_group", 23));
    }

    @NonNull
    public static IPermission getReadCalendarPermission() {
        String permissionName = "android.permission.READ_CALENDAR";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "calendar_group", 23));
    }

    @NonNull
    public static IPermission getWriteCalendarPermission() {
        String permissionName = "android.permission.WRITE_CALENDAR";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "calendar_group", 23));
    }

    @NonNull
    public static IPermission getReadPhoneStatePermission() {
        String permissionName = "android.permission.READ_PHONE_STATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 23));
    }

    @NonNull
    public static IPermission getCallPhonePermission() {
        String permissionName = "android.permission.CALL_PHONE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 23));
    }

    @NonNull
    public static IPermission getReadCallLogPermission() {
        String permissionName = "android.permission.READ_CALL_LOG";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        String permissionGroup = PermissionVersion.isAndroid9() ? "call_log_group" : "phone_group";
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, permissionGroup, 23));
    }

    @NonNull
    public static IPermission getWriteCallLogPermission() {
        String permissionName = "android.permission.WRITE_CALL_LOG";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        String permissionGroup = PermissionVersion.isAndroid9() ? "call_log_group" : "phone_group";
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, permissionGroup, 23));
    }

    @NonNull
    public static IPermission getAddVoicemailPermission() {
        String permissionName = "com.android.voicemail.permission.ADD_VOICEMAIL";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 23));
    }

    @NonNull
    public static IPermission getUseSipPermission() {
        String permissionName = "android.permission.USE_SIP";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "phone_group", 23));
    }

    @NonNull
    public static IPermission getProcessOutgoingCallsPermission() {
        String permissionName = "android.permission.PROCESS_OUTGOING_CALLS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        String permissionGroup = PermissionVersion.isAndroid9() ? "call_log_group" : "phone_group";
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, permissionGroup, 23));
    }

    @NonNull
    public static IPermission getBodySensorsPermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.BODY_SENSORS");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new BodySensorsPermission());
    }

    @NonNull
    public static IPermission getSendSmsPermission() {
        String permissionName = "android.permission.SEND_SMS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "sms_group", 23));
    }

    @NonNull
    public static IPermission getReceiveSmsPermission() {
        String permissionName = "android.permission.RECEIVE_SMS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "sms_group", 23));
    }

    @NonNull
    public static IPermission getReadSmsPermission() {
        String permissionName = "android.permission.READ_SMS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "sms_group", 23));
    }

    @NonNull
    public static IPermission getReceiveWapPushPermission() {
        String permissionName = "android.permission.RECEIVE_WAP_PUSH";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "sms_group", 23));
    }

    @NonNull
    public static IPermission getReceiveMmsPermission() {
        String permissionName = "android.permission.RECEIVE_MMS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardDangerousPermission(permissionName, "sms_group", 23));
    }

    @NonNull
    public static IPermission getReadHealthDataInBackgroundPermission() {
        String permissionName = "android.permission.health.READ_HEALTH_DATA_IN_BACKGROUND";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadHealthDataInBackgroundPermission());
    }

    @NonNull
    public static IPermission getReadHealthDataHistoryPermission() {
        String permissionName = "android.permission.health.READ_HEALTH_DATA_HISTORY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadHealthDataHistoryPermission());
    }

    @NonNull
    public static IPermission getReadActiveCaloriesBurnedPermission() {
        String permissionName = "android.permission.health.READ_ACTIVE_CALORIES_BURNED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteActiveCaloriesBurnedPermission() {
        String permissionName = "android.permission.health.WRITE_ACTIVE_CALORIES_BURNED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadActivityIntensityPermission() {
        String permissionName = "android.permission.health.READ_ACTIVITY_INTENSITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getWriteActivityIntensityPermission() {
        String permissionName = "android.permission.health.WRITE_ACTIVITY_INTENSITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadBasalBodyTemperaturePermission() {
        String permissionName = "android.permission.health.READ_BASAL_BODY_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBasalBodyTemperaturePermission() {
        String permissionName = "android.permission.health.WRITE_BASAL_BODY_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBasalMetabolicRatePermission() {
        String permissionName = "android.permission.health.READ_BASAL_METABOLIC_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBasalMetabolicRatePermission() {
        String permissionName = "android.permission.health.WRITE_BASAL_METABOLIC_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBloodGlucosePermission() {
        String permissionName = "android.permission.health.READ_BLOOD_GLUCOSE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBloodGlucosePermission() {
        String permissionName = "android.permission.health.WRITE_BLOOD_GLUCOSE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBloodPressurePermission() {
        String permissionName = "android.permission.health.READ_BLOOD_PRESSURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBloodPressurePermission() {
        String permissionName = "android.permission.health.WRITE_BLOOD_PRESSURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBodyFatPermission() {
        String permissionName = "android.permission.health.READ_BODY_FAT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBodyFatPermission() {
        String permissionName = "android.permission.health.WRITE_BODY_FAT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBodyTemperaturePermission() {
        String permissionName = "android.permission.health.READ_BODY_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBodyTemperaturePermission() {
        String permissionName = "android.permission.health.WRITE_BODY_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBodyWaterMassPermission() {
        String permissionName = "android.permission.health.READ_BODY_WATER_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBodyWaterMassPermission() {
        String permissionName = "android.permission.health.WRITE_BODY_WATER_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadBoneMassPermission() {
        String permissionName = "android.permission.health.READ_BONE_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteBoneMassPermission() {
        String permissionName = "android.permission.health.WRITE_BONE_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadCervicalMucusPermission() {
        String permissionName = "android.permission.health.READ_CERVICAL_MUCUS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteCervicalMucusPermission() {
        String permissionName = "android.permission.health.WRITE_CERVICAL_MUCUS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadDistancePermission() {
        String permissionName = "android.permission.health.READ_DISTANCE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteDistancePermission() {
        String permissionName = "android.permission.health.WRITE_DISTANCE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadElevationGainedPermission() {
        String permissionName = "android.permission.health.READ_ELEVATION_GAINED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteElevationGainedPermission() {
        String permissionName = "android.permission.health.WRITE_ELEVATION_GAINED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadExercisePermission() {
        String permissionName = "android.permission.health.READ_EXERCISE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteExercisePermission() {
        String permissionName = "android.permission.health.WRITE_EXERCISE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadExerciseRoutesPermission() {
        String permissionName = "android.permission.health.READ_EXERCISE_ROUTES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getWriteExerciseRoutePermission() {
        String permissionName = "android.permission.health.WRITE_EXERCISE_ROUTE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getReadFloorsClimbedPermission() {
        String permissionName = "android.permission.health.READ_FLOORS_CLIMBED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteFloorsClimbedPermission() {
        String permissionName = "android.permission.health.WRITE_FLOORS_CLIMBED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadHeartRatePermission() {
        IPermission permission2 = PermissionLists.getCachePermission("android.permission.health.READ_HEART_RATE");
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new ReadHealthRatePermission());
    }

    @NonNull
    public static IPermission getWriteHeartRatePermission() {
        String permissionName = "android.permission.health.WRITE_HEART_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadHeartRateVariabilityPermission() {
        String permissionName = "android.permission.health.READ_HEART_RATE_VARIABILITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteHeartRateVariabilityPermission() {
        String permissionName = "android.permission.health.WRITE_HEART_RATE_VARIABILITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadHeightPermission() {
        String permissionName = "android.permission.health.READ_HEIGHT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteHeightPermission() {
        String permissionName = "android.permission.health.WRITE_HEIGHT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadHydrationPermission() {
        String permissionName = "android.permission.health.READ_HYDRATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteHydrationPermission() {
        String permissionName = "android.permission.health.WRITE_HYDRATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadIntermenstrualBleedingPermission() {
        String permissionName = "android.permission.health.READ_INTERMENSTRUAL_BLEEDING";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteIntermenstrualBleedingPermission() {
        String permissionName = "android.permission.health.WRITE_INTERMENSTRUAL_BLEEDING";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadLeanBodyMassPermission() {
        String permissionName = "android.permission.health.READ_LEAN_BODY_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteLeanBodyMassPermission() {
        String permissionName = "android.permission.health.WRITE_LEAN_BODY_MASS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadMenstruationPermission() {
        String permissionName = "android.permission.health.READ_MENSTRUATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteMenstruationPermission() {
        String permissionName = "android.permission.health.WRITE_MENSTRUATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadMindfulnessPermission() {
        String permissionName = "android.permission.health.READ_MINDFULNESS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getWriteMindfulnessPermission() {
        String permissionName = "android.permission.health.WRITE_MINDFULNESS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadNutritionPermission() {
        String permissionName = "android.permission.health.READ_NUTRITION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteNutritionPermission() {
        String permissionName = "android.permission.health.WRITE_NUTRITION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadOvulationTestPermission() {
        String permissionName = "android.permission.health.READ_OVULATION_TEST";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteOvulationTestPermission() {
        String permissionName = "android.permission.health.WRITE_OVULATION_TEST";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadOxygenSaturationPermission() {
        String permissionName = "android.permission.health.READ_OXYGEN_SATURATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteOxygenSaturationPermission() {
        String permissionName = "android.permission.health.WRITE_OXYGEN_SATURATION";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadPlannedExercisePermission() {
        String permissionName = "android.permission.health.READ_PLANNED_EXERCISE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getWritePlannedExercisePermission() {
        String permissionName = "android.permission.health.WRITE_PLANNED_EXERCISE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getReadPowerPermission() {
        String permissionName = "android.permission.health.READ_POWER";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWritePowerPermission() {
        String permissionName = "android.permission.health.WRITE_POWER";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadRespiratoryRatePermission() {
        String permissionName = "android.permission.health.READ_RESPIRATORY_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteRespiratoryRatePermission() {
        String permissionName = "android.permission.health.WRITE_RESPIRATORY_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadRestingHeartRatePermission() {
        String permissionName = "android.permission.health.READ_RESTING_HEART_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteRestingHeartRatePermission() {
        String permissionName = "android.permission.health.WRITE_RESTING_HEART_RATE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadSexualActivityPermission() {
        String permissionName = "android.permission.health.READ_SEXUAL_ACTIVITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteSexualActivityPermission() {
        String permissionName = "android.permission.health.WRITE_SEXUAL_ACTIVITY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadSkinTemperaturePermission() {
        String permissionName = "android.permission.health.READ_SKIN_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getWriteSkinTemperaturePermission() {
        String permissionName = "android.permission.health.WRITE_SKIN_TEMPERATURE";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 35));
    }

    @NonNull
    public static IPermission getReadSleepPermission() {
        String permissionName = "android.permission.health.READ_SLEEP";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteSleepPermission() {
        String permissionName = "android.permission.health.WRITE_SLEEP";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadSpeedPermission() {
        String permissionName = "android.permission.health.READ_SPEED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteSpeedPermission() {
        String permissionName = "android.permission.health.WRITE_SPEED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadStepsPermission() {
        String permissionName = "android.permission.health.READ_STEPS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteStepsPermission() {
        String permissionName = "android.permission.health.WRITE_STEPS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadTotalCaloriesBurnedPermission() {
        String permissionName = "android.permission.health.READ_TOTAL_CALORIES_BURNED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteTotalCaloriesBurnedPermission() {
        String permissionName = "android.permission.health.WRITE_TOTAL_CALORIES_BURNED";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadVo2MaxPermission() {
        String permissionName = "android.permission.health.READ_VO2_MAX";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteVo2MaxPermission() {
        String permissionName = "android.permission.health.WRITE_VO2_MAX";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadWeightPermission() {
        String permissionName = "android.permission.health.READ_WEIGHT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteWeightPermission() {
        String permissionName = "android.permission.health.WRITE_WEIGHT";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadWheelchairPushesPermission() {
        String permissionName = "android.permission.health.READ_WHEELCHAIR_PUSHES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getWriteWheelchairPushesPermission() {
        String permissionName = "android.permission.health.WRITE_WHEELCHAIR_PUSHES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardFitnessAndWellnessDataPermission(permissionName, 34));
    }

    @NonNull
    public static IPermission getReadMedicalDataAllergiesIntolerancesPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_ALLERGIES_INTOLERANCES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataConditionsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_CONDITIONS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataLaboratoryResultsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_LABORATORY_RESULTS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataMedicationsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_MEDICATIONS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataPersonalDetailsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_PERSONAL_DETAILS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataPractitionerDetailsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_PRACTITIONER_DETAILS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataPregnancyPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_PREGNANCY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataProceduresPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_PROCEDURES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataSocialHistoryPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_SOCIAL_HISTORY";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataVaccinesPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_VACCINES";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataVisitsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_VISITS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getReadMedicalDataVitalSignsPermission() {
        String permissionName = "android.permission.health.READ_MEDICAL_DATA_VITAL_SIGNS";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }

    @NonNull
    public static IPermission getWriteMedicalDataPermission() {
        String permissionName = "android.permission.health.WRITE_MEDICAL_DATA";
        IPermission permission2 = PermissionLists.getCachePermission(permissionName);
        if (permission2 != null) {
            return permission2;
        }
        return PermissionLists.putCachePermission(new StandardHealthRecordsPermission(permissionName, 36));
    }
}

