/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.core.PermissionChannelImpl;
import com.hjq.permissions.fragment.IFragmentMethod;
import com.hjq.permissions.manager.AlreadyRequestPermissionsManager;
import com.hjq.permissions.manager.PermissionRequestCodeManager;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class PermissionChannelImplByRequestPermissions
extends PermissionChannelImpl {
    public PermissionChannelImplByRequestPermissions(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        super(fragmentMethod);
    }

    @Override
    protected void startPermissionRequest(@NonNull Activity activity, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (!PermissionVersion.isAndroid6()) {
            this.sendTask(this::handlerPermissionCallback, 0L);
            return;
        }
        this.requestPermissions(PermissionUtils.convertPermissionArray((Context)activity, permissions), requestCode);
        AlreadyRequestPermissionsManager.addAlreadyRequestPermissions(permissions);
    }

    @Override
    public void onFragmentRequestPermissionsResult(int requestCode, @Nullable String[] permissions, @Nullable int[] grantResults) {
        if (requestCode != this.getPermissionRequestCode()) {
            return;
        }
        PermissionRequestCodeManager.releaseRequestCode(requestCode);
        this.notificationPermissionCallback();
    }
}

