/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class NotificationServicePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.NOTIFICATION_SERVICE";
    private static final String OP_POST_NOTIFICATION_FIELD_NAME = "OP_POST_NOTIFICATION";
    private static final int OP_POST_NOTIFICATION_DEFAULT_VALUE = 11;
    public static final Parcelable.Creator<NotificationServicePermission> CREATOR = new Parcelable.Creator<NotificationServicePermission>(){

        public NotificationServicePermission createFromParcel(Parcel source) {
            return new NotificationServicePermission(source);
        }

        public NotificationServicePermission[] newArray(int size) {
            return new NotificationServicePermission[size];
        }
    };
    @Nullable
    private final String mChannelId;

    public NotificationServicePermission() {
        this((String)null);
    }

    public NotificationServicePermission(@Nullable String channelId) {
        this.mChannelId = channelId;
    }

    private NotificationServicePermission(Parcel in) {
        this(in.readString());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mChannelId);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 19;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid4_4()) {
            return true;
        }
        if (!PermissionVersion.isAndroid7()) {
            return NotificationServicePermission.checkOpPermission(context, OP_POST_NOTIFICATION_FIELD_NAME, 11, true);
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (notificationManager == null) {
            return NotificationServicePermission.checkOpPermission(context, OP_POST_NOTIFICATION_FIELD_NAME, 11, true);
        }
        if (!notificationManager.areNotificationsEnabled()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mChannelId) || !PermissionVersion.isAndroid8()) {
            return true;
        }
        NotificationChannel notificationChannel = notificationManager.getNotificationChannel(this.mChannelId);
        return notificationChannel != null && notificationChannel.getImportance() != 0;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(8);
        if (PermissionVersion.isAndroid8()) {
            intent = new Intent("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
            NotificationChannel notificationChannel = null;
            if (notificationManager != null && !TextUtils.isEmpty((CharSequence)this.mChannelId)) {
                notificationChannel = notificationManager.getNotificationChannel(this.mChannelId);
            }
            if (notificationChannel != null && notificationManager.areNotificationsEnabled()) {
                intent.setAction("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.CHANNEL_ID", notificationChannel.getId());
                if (PermissionVersion.isAndroid11()) {
                    intent.putExtra("android.provider.extra.CONVERSATION_ID", notificationChannel.getConversationId());
                }
                intentList.add(intent);
            }
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            intentList.add(intent);
        }
        if (PermissionVersion.isAndroid5()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
            intentList.add(intent);
        }
        if (PermissionVersion.isAndroid13()) {
            intent = new Intent("android.settings.ALL_APPS_NOTIFICATION_SETTINGS");
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = NotificationServicePermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = NotificationServicePermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Nullable
    public String getChannelId() {
        return this.mChannelId;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        if (PermissionVersion.getTargetVersion((Context)activity) >= 33) {
            PermissionManifestInfo postNotificationsPermission = NotificationServicePermission.findPermissionInfoByList(permissionInfoList, "android.permission.POST_NOTIFICATIONS");
            NotificationServicePermission.checkPermissionRegistrationStatus(postNotificationsPermission, "android.permission.POST_NOTIFICATIONS", Integer.MAX_VALUE);
        }
    }
}

