/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.IntentFilterManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.manifest.node.ServiceManifestInfo;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class BindVpnServicePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.BIND_VPN_SERVICE";
    public static final Parcelable.Creator<BindVpnServicePermission> CREATOR = new Parcelable.Creator<BindVpnServicePermission>(){

        public BindVpnServicePermission createFromParcel(Parcel source) {
            return new BindVpnServicePermission(source);
        }

        public BindVpnServicePermission[] newArray(int size) {
            return new BindVpnServicePermission[size];
        }
    };

    public BindVpnServicePermission() {
    }

    private BindVpnServicePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        if (DeviceOs.isColorOs() && PermissionVersion.isAndroid15()) {
            return PermissionPageType.OPAQUE_ACTIVITY;
        }
        return VpnService.prepare((Context)context) != null ? PermissionPageType.TRANSPARENT_ACTIVITY : PermissionPageType.OPAQUE_ACTIVITY;
    }

    @Override
    public int getFromAndroidVersion() {
        return 14;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        return VpnService.prepare((Context)context) == null;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2);
        intentList.add(VpnService.prepare((Context)context));
        intentList.add(this.getAndroidSettingIntent());
        return intentList;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        List<ServiceManifestInfo> serviceInfoList = manifestInfo.serviceInfoList;
        for (int i = 0; i < serviceInfoList.size(); ++i) {
            ServiceManifestInfo serviceInfo = serviceInfoList.get(i);
            String permission2 = serviceInfo.permission;
            if (permission2 == null || !PermissionUtils.equalsPermission((IPermission)this, permission2)) continue;
            String action = "android.net.VpnService";
            boolean registeredVpnServiceAction = false;
            List<IntentFilterManifestInfo> intentFilterInfoList = serviceInfo.intentFilterInfoList;
            if (intentFilterInfoList != null) {
                for (IntentFilterManifestInfo intentFilterInfo : intentFilterInfoList) {
                    if (!intentFilterInfo.actionList.contains(action)) continue;
                    registeredVpnServiceAction = true;
                    break;
                }
            }
            if (registeredVpnServiceAction) {
                return;
            }
            String xmlCode = "\t\t<intent-filter>\n\t\t    <action android:name=\"" + action + "\" />\n\t\t</intent-filter>";
            throw new IllegalArgumentException("Please add an intent filter for \"" + serviceInfo.name + "\" in the AndroidManifest.xml file.\n" + xmlCode);
        }
        throw new IllegalArgumentException("No Service was found to have registered the android:permission=\"" + this.getPermissionName() + "\" property, Please register this property to VpnService subclass by AndroidManifest.xml file, otherwise it will lead to can't apply for the permission");
    }
}

