/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class AccessMediaLocationPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.ACCESS_MEDIA_LOCATION";
    public static final Parcelable.Creator<AccessMediaLocationPermission> CREATOR = new Parcelable.Creator<AccessMediaLocationPermission>(){

        public AccessMediaLocationPermission createFromParcel(Parcel source) {
            return new AccessMediaLocationPermission(source);
        }

        public AccessMediaLocationPermission[] newArray(int size) {
            return new AccessMediaLocationPermission[size];
        }
    };

    public AccessMediaLocationPermission() {
    }

    private AccessMediaLocationPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 29;
    }

    @Override
    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        return this.isGrantedReadMediaPermission(context, skipRequest) && super.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    @Override
    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return PermissionLists.getReadExternalStoragePermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        return this.isGrantedReadMediaPermission((Context)activity, true) && super.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return PermissionLists.getReadExternalStoragePermission().isDoNotAskAgainPermission(activity);
    }

    private boolean isGrantedReadMediaPermission(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid13() && PermissionVersion.getTargetVersion(context) >= 33) {
            return PermissionLists.getReadMediaImagesPermission().isGrantedPermission(context, skipRequest) || PermissionLists.getReadMediaVideoPermission().isGrantedPermission(context, skipRequest) || PermissionLists.getManageExternalStoragePermission().isGrantedPermission(context, skipRequest);
        }
        if (PermissionVersion.isAndroid11() && PermissionVersion.getTargetVersion(context) >= 30) {
            return PermissionLists.getReadExternalStoragePermission().isGrantedPermission(context, skipRequest) || PermissionLists.getManageExternalStoragePermission().isGrantedPermission(context, skipRequest);
        }
        return PermissionLists.getReadExternalStoragePermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        int thisPermissionIndex = -1;
        int readMediaImagesPermissionIndex = -1;
        int readMediaVideoPermissionIndex = -1;
        int readMediaVisualUserSelectedPermissionIndex = -1;
        int manageExternalStoragePermissionIndex = -1;
        int readExternalStoragePermissionIndex = -1;
        int writeExternalStoragePermissionIndex = -1;
        for (int i = 0; i < requestList.size(); ++i) {
            IPermission permission2 = requestList.get(i);
            if (PermissionUtils.equalsPermission(permission2, this)) {
                thisPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES")) {
                readMediaImagesPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO")) {
                readMediaVideoPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VISUAL_USER_SELECTED")) {
                readMediaVisualUserSelectedPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                manageExternalStoragePermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_EXTERNAL_STORAGE")) {
                readExternalStoragePermissionIndex = i;
                continue;
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) continue;
            writeExternalStoragePermissionIndex = i;
        }
        if (readMediaImagesPermissionIndex != -1 && readMediaImagesPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the " + this.getPermissionName() + "\" permission after the \"" + "android.permission.READ_MEDIA_IMAGES" + "\" permission");
        }
        if (readMediaVideoPermissionIndex != -1 && readMediaVideoPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.READ_MEDIA_VIDEO" + "\" permission");
        }
        if (readMediaVisualUserSelectedPermissionIndex != -1 && readMediaVisualUserSelectedPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.READ_MEDIA_VISUAL_USER_SELECTED" + "\" permission");
        }
        if (manageExternalStoragePermissionIndex != -1 && manageExternalStoragePermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.MANAGE_EXTERNAL_STORAGE" + "\" permission");
        }
        if (readExternalStoragePermissionIndex != -1 && readExternalStoragePermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.READ_EXTERNAL_STORAGE" + "\" permission");
        }
        if (writeExternalStoragePermissionIndex != -1 && writeExternalStoragePermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.WRITE_EXTERNAL_STORAGE" + "\" permission");
        }
        if (PermissionVersion.getTargetVersion((Context)activity) >= 33) {
            if (PermissionUtils.containsPermission(requestList, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestList, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestList, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                return;
            }
            throw new IllegalArgumentException("You must add \"android.permission.READ_MEDIA_IMAGES\" or \"android.permission.READ_MEDIA_VIDEO\" or \"android.permission.MANAGE_EXTERNAL_STORAGE\" rights to apply for \"" + this.getPermissionName() + "\" rights");
        }
        if (PermissionUtils.containsPermission(requestList, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestList, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            return;
        }
        throw new IllegalArgumentException("You must add \"android.permission.READ_EXTERNAL_STORAGE\" or \"android.permission.MANAGE_EXTERNAL_STORAGE\" rights to apply for \"" + this.getPermissionName() + "\" rights");
    }
}

