/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.base;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class BasePermission
implements IPermission {
    public static final int MODE_UNKNOWN = -1;

    protected BasePermission() {
    }

    protected BasePermission(Parcel in) {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
    }

    @NonNull
    public String toString() {
        return this.getPermissionName();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IPermission) {
            return PermissionUtils.equalsPermission((IPermission)this, (IPermission)obj);
        }
        if (obj instanceof String) {
            return PermissionUtils.equalsPermission((IPermission)this, (String)obj);
        }
        return false;
    }

    @NonNull
    protected Uri getPackageNameUri(@NonNull Context context) {
        return PermissionUtils.getPackageNameUri(context);
    }

    @NonNull
    protected Intent getApplicationDetailsSettingIntent(@NonNull Context context) {
        return PermissionSettingPage.getApplicationDetailsSettingsIntent(context, this);
    }

    @NonNull
    protected static Intent getManageApplicationSettingIntent() {
        return PermissionSettingPage.getManageApplicationSettingsIntent();
    }

    @NonNull
    protected static Intent getApplicationSettingIntent() {
        return PermissionSettingPage.getApplicationSettingsIntent();
    }

    @NonNull
    protected Intent getAndroidSettingIntent() {
        return PermissionSettingPage.getAndroidSettingsIntent();
    }

    @Override
    public void checkCompliance(@NonNull Activity activity, @NonNull List<IPermission> requestList, @Nullable AndroidManifestInfo androidManifestInfo) {
        this.checkSelfByTargetSdkVersion((Context)activity);
        if (androidManifestInfo != null) {
            List<PermissionManifestInfo> permissionInfoList = androidManifestInfo.permissionInfoList;
            PermissionManifestInfo currentPermissionInfo = BasePermission.findPermissionInfoByList(permissionInfoList, this.getPermissionName());
            this.checkSelfByManifestFile(activity, requestList, androidManifestInfo, permissionInfoList, currentPermissionInfo);
        }
        this.checkSelfByRequestPermissions(activity, requestList);
    }

    protected void checkSelfByTargetSdkVersion(@NonNull Context context) {
        int minTargetSdkVersion = this.getMinTargetSdkVersion();
        if (PermissionVersion.getTargetVersion(context) >= minTargetSdkVersion) {
            return;
        }
        throw new IllegalStateException("Request \"" + this.getPermissionName() + "\" permission, The targetSdkVersion SDK must be " + minTargetSdkVersion + " or more, if you do not want to upgrade targetSdkVersion, please apply with the old permission");
    }

    protected abstract boolean isRegisterPermissionByManifestFile();

    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        if (!this.isRegisterPermissionByManifestFile()) {
            return;
        }
        BasePermission.checkPermissionRegistrationStatus(currentPermissionInfo, this.getPermissionName());
    }

    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
    }

    protected static void checkPermissionRegistrationStatus(@Nullable PermissionManifestInfo permissionManifestInfo, @NonNull String checkPermission) {
        BasePermission.checkPermissionRegistrationStatus(permissionManifestInfo, checkPermission, Integer.MAX_VALUE);
    }

    protected static void checkPermissionRegistrationStatus(@Nullable List<PermissionManifestInfo> permissionInfoList, @NonNull String checkPermission) {
        BasePermission.checkPermissionRegistrationStatus(permissionInfoList, checkPermission, Integer.MAX_VALUE);
    }

    protected static void checkPermissionRegistrationStatus(@Nullable List<PermissionManifestInfo> permissionInfoList, @NonNull String checkPermission, int lowestMaxSdkVersion) {
        PermissionManifestInfo permissionManifestInfo = null;
        if (permissionInfoList != null) {
            permissionManifestInfo = BasePermission.findPermissionInfoByList(permissionInfoList, checkPermission);
        }
        BasePermission.checkPermissionRegistrationStatus(permissionManifestInfo, checkPermission, lowestMaxSdkVersion);
    }

    protected static void checkPermissionRegistrationStatus(@Nullable PermissionManifestInfo permissionManifestInfo, @NonNull String checkPermission, int lowestMaxSdkVersion) {
        if (permissionManifestInfo == null) {
            throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" />");
        }
        int manifestMaxSdkVersion = permissionManifestInfo.maxSdkVersion;
        if (manifestMaxSdkVersion < lowestMaxSdkVersion) {
            throw new IllegalArgumentException("The AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" /> does not meet the requirements, " + (lowestMaxSdkVersion != Integer.MAX_VALUE ? "the minimum requirement for maxSdkVersion is " + lowestMaxSdkVersion : "please delete the android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" attribute"));
        }
    }

    protected static int getMinSdkVersion(@NonNull Context context, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (PermissionVersion.isAndroid7()) {
            return context.getApplicationInfo().minSdkVersion;
        }
        if (androidManifestInfo == null || androidManifestInfo.usesSdkManifestInfo == null) {
            return 17;
        }
        return androidManifestInfo.usesSdkManifestInfo.minSdkVersion;
    }

    @Nullable
    public static PermissionManifestInfo findPermissionInfoByList(@NonNull List<PermissionManifestInfo> permissionInfoList, @NonNull String permissionName) {
        PermissionManifestInfo permissionManifestInfo = null;
        for (PermissionManifestInfo info : permissionInfoList) {
            if (!PermissionUtils.equalsPermission(info.name, permissionName)) continue;
            permissionManifestInfo = info;
            break;
        }
        return permissionManifestInfo;
    }

    @RequiresApi(value=23)
    public static boolean checkSelfPermission(@NonNull Context context, @NonNull String permission2) {
        return context.checkSelfPermission(permission2) == 0;
    }

    @RequiresApi(value=23)
    public static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionVersion.getCurrentVersion() == 31) {
            try {
                PackageManager packageManager = activity.getApplication().getPackageManager();
                Method method = PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class);
                return (Boolean)method.invoke((Object)packageManager, permission2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return activity.shouldShowRequestPermissionRationale(permission2);
    }

    @RequiresApi(value=19)
    public static boolean checkOpPermission(@NonNull Context context, @NonNull String opName, boolean defaultGranted) {
        int opMode = BasePermission.getOpPermissionMode(context, opName);
        if (opMode == -1) {
            return defaultGranted;
        }
        return opMode == 0;
    }

    @RequiresApi(value=19)
    public static boolean checkOpPermission(Context context, String opFieldName, int opDefaultValue, boolean defaultGranted) {
        int opMode = BasePermission.getOpPermissionMode(context, opFieldName, opDefaultValue);
        if (opMode == -1) {
            return defaultGranted;
        }
        return opMode == 0;
    }

    @RequiresApi(value=19)
    public static int getOpPermissionMode(@NonNull Context context, @NonNull String opName) {
        AppOpsManager appOpsManager = PermissionVersion.isAndroid6() ? (AppOpsManager)context.getSystemService(AppOpsManager.class) : (AppOpsManager)context.getSystemService("appops");
        if (appOpsManager == null) {
            return -1;
        }
        try {
            if (PermissionVersion.isAndroid10()) {
                return appOpsManager.unsafeCheckOpNoThrow(opName, context.getApplicationInfo().uid, context.getPackageName());
            }
            return appOpsManager.checkOpNoThrow(opName, context.getApplicationInfo().uid, context.getPackageName());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return -1;
        }
    }

    @RequiresApi(value=19)
    public static int getOpPermissionMode(Context context, @NonNull String opName, int opDefaultValue) {
        AppOpsManager appOpsManager = PermissionVersion.isAndroid6() ? (AppOpsManager)context.getSystemService(AppOpsManager.class) : (AppOpsManager)context.getSystemService("appops");
        if (appOpsManager == null) {
            return -1;
        }
        try {
            int opValue;
            Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
            try {
                Field opField = appOpsClass.getDeclaredField(opName);
                opValue = (Integer)opField.get(Integer.class);
            }
            catch (NoSuchFieldException e) {
                opValue = opDefaultValue;
            }
            Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
            return (Integer)checkOpNoThrowMethod.invoke((Object)appOpsManager, opValue, context.getApplicationInfo().uid, context.getPackageName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @RequiresApi(value=19)
    public static boolean isExistOpPermission(String opName) {
        try {
            Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
            appOpsClass.getDeclaredField(opName);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

