/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ApplicationManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class WriteExternalStoragePermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.WRITE_EXTERNAL_STORAGE";
    public static final Parcelable.Creator<WriteExternalStoragePermission> CREATOR = new Parcelable.Creator<WriteExternalStoragePermission>(){

        public WriteExternalStoragePermission createFromParcel(Parcel source) {
            return new WriteExternalStoragePermission(source);
        }

        public WriteExternalStoragePermission[] newArray(int size) {
            return new WriteExternalStoragePermission[size];
        }
    };

    public WriteExternalStoragePermission() {
    }

    private WriteExternalStoragePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public String getPermissionGroup() {
        return "storage_group";
    }

    @Override
    public int getFromAndroidVersion() {
        return 23;
    }

    @Override
    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid11() && PermissionVersion.getTargetVersion(context) >= 30) {
            return true;
        }
        if (PermissionVersion.isAndroid10() && PermissionVersion.getTargetVersion(context) >= 29) {
            return Environment.isExternalStorageLegacy();
        }
        return super.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        if (PermissionVersion.isAndroid11() && PermissionVersion.getTargetVersion((Context)activity) >= 30) {
            return false;
        }
        if (PermissionVersion.isAndroid10() && PermissionVersion.getTargetVersion((Context)activity) >= 29 && Environment.isExternalStorageLegacy()) {
            return false;
        }
        return super.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return false;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        ApplicationManifestInfo applicationManifestInfo = androidManifestInfo.applicationManifestInfo;
        if (applicationManifestInfo == null) {
            return;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) < 29) {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionManifestInfoList, this.getPermissionName());
            return;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) >= 30 && WriteExternalStoragePermission.findPermissionInfoByList(permissionManifestInfoList, "android.permission.MANAGE_EXTERNAL_STORAGE") != null) {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionManifestInfoList, this.getPermissionName(), 29);
        } else {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionManifestInfoList, this.getPermissionName(), applicationManifestInfo.requestLegacyExternalStorage ? 29 : 28);
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        int targetSdkVersion = PermissionVersion.getTargetVersion((Context)activity);
        boolean scopedStorage = PermissionUtils.getBooleanByMetaData((Context)activity, "ScopedStorage", false);
        if (targetSdkVersion >= 29 && !applicationManifestInfo.requestLegacyExternalStorage && !scopedStorage) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
        if (targetSdkVersion >= 30 && !scopedStorage) {
            throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use \"android.permission.MANAGE_EXTERNAL_STORAGE\" to apply for permission");
        }
    }
}

