/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.List;

public final class ReadMediaAudioPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.READ_MEDIA_AUDIO";
    public static final Parcelable.Creator<ReadMediaAudioPermission> CREATOR = new Parcelable.Creator<ReadMediaAudioPermission>(){

        public ReadMediaAudioPermission createFromParcel(Parcel source) {
            return new ReadMediaAudioPermission(source);
        }

        public ReadMediaAudioPermission[] newArray(int size) {
            return new ReadMediaAudioPermission[size];
        }
    };

    public ReadMediaAudioPermission() {
    }

    private ReadMediaAudioPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 33;
    }

    @Override
    @NonNull
    public List<IPermission> getOldPermissions(Context context) {
        return PermissionUtils.asArrayList(PermissionLists.getReadExternalStoragePermission());
    }

    @Override
    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return PermissionLists.getReadExternalStoragePermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return PermissionLists.getReadExternalStoragePermission().isDoNotAskAgainPermission(activity);
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        if (this.getFromAndroidVersion() > ReadMediaAudioPermission.getMinSdkVersion((Context)activity, androidManifestInfo)) {
            ReadMediaAudioPermission.checkPermissionRegistrationStatus(permissionManifestInfoList, "android.permission.READ_EXTERNAL_STORAGE", 32);
        }
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions) {
        super.checkSelfByRequestPermissions(activity, requestPermissions);
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("You have added the \"" + this.getPermissionName() + "\" permission, please do not add the \"" + "android.permission.READ_EXTERNAL_STORAGE" + "\" permission, this conflicts with the framework's automatic compatibility policy.");
        }
    }
}

