/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.IFragmentMethod;
import com.hjq.permissions.OnPermissionFlowCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionRequestCodeManager;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.RequestPermissionDelegateImpl;
import java.util.List;

final class RequestPermissionDelegateImplByDangerous
extends RequestPermissionDelegateImpl {
    RequestPermissionDelegateImplByDangerous(@NonNull IFragmentMethod<?, ?> fragmentMethod) {
        super(fragmentMethod);
    }

    @Override
    void startPermissionRequest(@NonNull Activity activity, @NonNull List<String> permissions, int requestCode) {
        String[] permissionArray = permissions.toArray(new String[permissions.size()]);
        if (!AndroidVersionTools.isAndroid6()) {
            int[] grantResults = new int[permissions.size()];
            for (int i = 0; i < grantResults.length; ++i) {
                grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, permissions.get(i)) ? 0 : -1;
            }
            this.onFragmentRequestPermissionsResult(requestCode, permissionArray, grantResults);
            return;
        }
        this.requestPermissions(permissionArray, requestCode);
    }

    @Override
    public void onFragmentRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || permissions.length == 0 || grantResults == null || grantResults.length == 0) {
            return;
        }
        if (requestCode != this.getPermissionRequestCode()) {
            return;
        }
        PermissionRequestCodeManager.releaseRequestCode(requestCode);
        this.sendTask(this::dispatchPermissionCallback, PermissionHelper.getMaxWaitTimeByPermissions(PermissionUtils.asArrayList(permissions)));
    }

    private void dispatchPermissionCallback() {
        if (this.isFragmentUnavailable()) {
            return;
        }
        Activity activity = this.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        OnPermissionFlowCallback callback = this.getCallBack();
        this.setCallback(null);
        if (callback != null) {
            callback.onRequestPermissionFinish();
        }
        this.commitDetach();
    }
}

