/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.PermissionDelegateImplV28;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV29
extends PermissionDelegateImplV28 {
    PermissionDelegateImplV29() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2, boolean skipRequest) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return PermissionUtils.isGrantedPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return this.isGrantedReadMediaPermission(context) && PermissionUtils.isGrantedPermission(context, "android.permission.ACCESS_MEDIA_LOCATION");
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return PermissionUtils.isGrantedPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return true;
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures(context, 30)) {
                return true;
            }
            if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures(context, 29)) {
                return this.isUseDeprecationExternalStorage();
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2, skipRequest);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (!PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return this.isGrantedReadMediaPermission((Context)activity) && PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            if (!AndroidVersionTools.isAndroid10()) {
                return false;
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures((Context)activity, 30)) {
                return false;
            }
            if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures((Context)activity, 29) && this.isUseDeprecationExternalStorage()) {
                return false;
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    private boolean isGrantedReadMediaPermission(@NonNull Context context) {
        if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures(context, 33)) {
            return PermissionUtils.isGrantedPermission(context, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.isGrantedPermission(context, "android.permission.READ_MEDIA_VIDEO") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE", false);
        }
        if (AndroidVersionTools.isAdaptationAndroidVersionNewFeatures(context, 30)) {
            return PermissionUtils.isGrantedPermission(context, "android.permission.READ_EXTERNAL_STORAGE") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE", false);
        }
        return PermissionUtils.isGrantedPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
    }

    @RequiresApi(value=29)
    protected boolean isUseDeprecationExternalStorage() {
        return Environment.isExternalStorageLegacy();
    }
}

