/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.PermissionDelegateImplV23;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV26
extends PermissionDelegateImplV23 {
    PermissionDelegateImplV26() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2, boolean skipRequest) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            return PermissionDelegateImplV26.isGrantedInstallPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            return PermissionDelegateImplV26.isGrantedPictureInPicturePermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
            if (!AndroidVersionTools.isAndroid8()) {
                return PermissionUtils.isGrantedPermission(context, "android.permission.READ_PHONE_STATE");
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ANSWER_PHONE_CALLS")) {
            if (!AndroidVersionTools.isAndroid8()) {
                return true;
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2, skipRequest);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
            if (!AndroidVersionTools.isAndroid8()) {
                return PermissionUtils.isDoNotAskAgainPermission(activity, "android.permission.READ_PHONE_STATE");
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ANSWER_PHONE_CALLS")) {
            if (!AndroidVersionTools.isAndroid8()) {
                return false;
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            return PermissionDelegateImplV26.getInstallPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            return PermissionDelegateImplV26.getPictureInPicturePermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    private static boolean isGrantedInstallPermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid8()) {
            return true;
        }
        return context.getPackageManager().canRequestPackageInstalls();
    }

    private static Intent getInstallPermissionIntent(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid8()) {
            return PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedPictureInPicturePermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid8()) {
            return true;
        }
        return PermissionUtils.checkOpNoThrow(context, "android:picture_in_picture");
    }

    private static Intent getPictureInPicturePermissionIntent(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid8()) {
            return PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        Intent intent = new Intent("android.settings.PICTURE_IN_PICTURE_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

