/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.GetInstalledAppsPermissionCompat;
import com.hjq.permissions.PermissionDelegateImplV21;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import com.hjq.permissions.WindowPermissionCompat;

class PermissionDelegateImplV23
extends PermissionDelegateImplV21 {
    PermissionDelegateImplV23() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2, boolean skipRequest) {
        if (!PermissionHelper.isSpecialPermission(permission2)) {
            if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
                return GetInstalledAppsPermissionCompat.isGrantedPermission(context);
            }
            return PermissionUtils.isGrantedPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.isGrantedPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_SETTINGS")) {
            return PermissionDelegateImplV23.isGrantedSettingPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
            return PermissionDelegateImplV23.isGrantedNotDisturbPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            return PermissionDelegateImplV23.isGrantedIgnoreBatteryPermission(context);
        }
        return super.isGrantedPermission(context, permission2, skipRequest);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (!PermissionHelper.isSpecialPermission(permission2)) {
            if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
                return GetInstalledAppsPermissionCompat.isDoNotAskAgainPermission(activity);
            }
            return PermissionUtils.isDoNotAskAgainPermission(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW") || PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_SETTINGS") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_NOTIFICATION_POLICY") || PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
            return GetInstalledAppsPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_SETTINGS")) {
            return PermissionDelegateImplV23.getSettingPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
            return PermissionDelegateImplV23.getNotDisturbPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            return PermissionDelegateImplV23.getIgnoreBatteryPermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    private static boolean isGrantedSettingPermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid6()) {
            return true;
        }
        return Settings.System.canWrite((Context)context);
    }

    private static Intent getSettingPermissionIntent(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid6()) {
            return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedNotDisturbPermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid6()) {
            return true;
        }
        return ((NotificationManager)context.getSystemService(NotificationManager.class)).isNotificationPolicyAccessGranted();
    }

    private static Intent getNotDisturbPermissionIntent(@NonNull Context context) {
        Intent intent;
        if (!AndroidVersionTools.isAndroid6()) {
            return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        if (AndroidVersionTools.isAndroid10()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_DETAIL_SETTINGS");
            intent.setData(PermissionUtils.getPackageNameUri(context));
            if (PhoneRomUtils.isHarmonyOs() || PhoneRomUtils.isMagicOs()) {
                intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
            }
        } else {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedIgnoreBatteryPermission(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid6()) {
            return true;
        }
        return ((PowerManager)context.getSystemService(PowerManager.class)).isIgnoringBatteryOptimizations(context.getPackageName());
    }

    private static Intent getIgnoreBatteryPermissionIntent(@NonNull Context context) {
        if (!AndroidVersionTools.isAndroid6()) {
            return PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV23.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

