/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.support.annotation.NonNull;
import com.hjq.permissions.IPermissionDelegate;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import java.util.Collections;

class PermissionDelegateImpl
implements IPermissionDelegate {
    PermissionDelegateImpl() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2, boolean skipRequest) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImpl.isGrantedVpnPermission(context);
        }
        return true;
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return false;
        }
        return false;
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImpl.getVpnPermissionIntent(context);
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context, Collections.singletonList(permission2));
    }

    private static boolean isGrantedVpnPermission(@NonNull Context context) {
        return VpnService.prepare((Context)context) == null;
    }

    private static Intent getVpnPermissionIntent(@NonNull Context context) {
        Intent intent = VpnService.prepare((Context)context);
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getApplicationDetailsIntent(@NonNull Context context) {
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }
}

