/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionGroupType;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.RequestDangerousPermissionFragment;
import com.hjq.permissions.RequestSpecialPermissionFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class PermissionHandler {
    @Nullable
    private OnPermissionCallback mCallBack;
    @Nullable
    private OnPermissionInterceptor mInterceptor;
    private final Activity mActivity;
    private final List<String> mAllPermissions;

    public static void request(@NonNull Activity activity, @NonNull List<String> allPermissions, @Nullable OnPermissionCallback callback, @Nullable OnPermissionInterceptor interceptor) {
        PermissionHandler permissionHandler = new PermissionHandler(activity, allPermissions);
        permissionHandler.setOnPermissionInterceptor(interceptor);
        permissionHandler.setOnPermissionCallback(callback);
        permissionHandler.startPermissionRequest();
    }

    public PermissionHandler(@NonNull Activity activity, @NonNull List<String> allPermissions) {
        this.mActivity = activity;
        this.mAllPermissions = allPermissions;
    }

    public void setOnPermissionCallback(@Nullable OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    public void setOnPermissionInterceptor(@Nullable OnPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public void startPermissionRequest() {
        if (this.mAllPermissions.isEmpty()) {
            return;
        }
        ArrayList<String> allDangerousPermissions = new ArrayList<String>();
        ArrayList<String> allSpecialPermissions = new ArrayList<String>();
        for (String permission2 : this.mAllPermissions) {
            if (PermissionApi.isSpecialPermission(permission2)) {
                allSpecialPermissions.add(permission2);
                continue;
            }
            allDangerousPermissions.add(permission2);
        }
        List<String> unauthorizedSpecialPermissions = PermissionHandler.getUnauthorizedSpecialPermissions(this.mActivity, allSpecialPermissions);
        List<List<String>> unauthorizedDangerousPermissions = PermissionHandler.getUnauthorizedDangerousPermissions(this.mActivity, allDangerousPermissions);
        if (PermissionHelper.isSpecialPermission(this.mAllPermissions.get(0))) {
            PermissionHandler.requestAllSpecialPermission(this.mActivity, unauthorizedSpecialPermissions, () -> PermissionHandler.requestAllDangerousPermission(this.mActivity, unauthorizedDangerousPermissions, this::postDelayedHandlerRequestPermissionsResult));
        } else {
            PermissionHandler.requestAllDangerousPermission(this.mActivity, unauthorizedDangerousPermissions, () -> PermissionHandler.requestAllSpecialPermission(this.mActivity, unauthorizedSpecialPermissions, this::postDelayedHandlerRequestPermissionsResult));
        }
    }

    private static List<String> getUnauthorizedSpecialPermissions(@NonNull Activity activity, @NonNull List<String> allSpecialPermissions) {
        ArrayList<String> unauthorizedSpecialPermissions = new ArrayList<String>();
        for (String permission2 : allSpecialPermissions) {
            if (PermissionApi.isGrantedPermission((Context)activity, permission2) || AndroidVersion.getAndroidVersionCode() < PermissionHelper.findAndroidVersionByPermission(permission2)) continue;
            unauthorizedSpecialPermissions.add(permission2);
        }
        return unauthorizedSpecialPermissions;
    }

    private static List<List<String>> getUnauthorizedDangerousPermissions(@NonNull Activity activity, @NonNull List<String> allDangerousPermissions) {
        ArrayList<String> alreadyProcessedDangerousPermissions = new ArrayList<String>();
        ArrayList<List<String>> unauthorizedDangerousPermissions = new ArrayList<List<String>>();
        for (String dangerousPermission : allDangerousPermissions) {
            if (alreadyProcessedDangerousPermissions.contains(dangerousPermission)) continue;
            alreadyProcessedDangerousPermissions.add(dangerousPermission);
            PermissionGroupType permissionGroupType = PermissionHelper.queryDangerousPermissionGroupType(dangerousPermission);
            if (permissionGroupType == null) {
                unauthorizedDangerousPermissions.add(PermissionUtils.asArrayList(dangerousPermission));
                continue;
            }
            ArrayList<String> dangerousPermissionGroup = new ArrayList<String>(PermissionHelper.getDangerousPermissionGroup(permissionGroupType));
            Iterator iterator = dangerousPermissionGroup.iterator();
            while (iterator.hasNext()) {
                String permission2 = (String)iterator.next();
                if (PermissionHelper.findAndroidVersionByPermission(permission2) > AndroidVersion.getAndroidVersionCode()) {
                    iterator.remove();
                    continue;
                }
                if (allDangerousPermissions.contains(permission2)) {
                    alreadyProcessedDangerousPermissions.add(permission2);
                    continue;
                }
                iterator.remove();
            }
            if (dangerousPermissionGroup.isEmpty() || PermissionApi.isGrantedPermissions((Context)activity, dangerousPermissionGroup)) continue;
            String backgroundPermission = PermissionHelper.getBackgroundPermissionByGroup(dangerousPermissionGroup);
            if (!TextUtils.isEmpty((CharSequence)backgroundPermission)) {
                ArrayList<String> foregroundPermissions = new ArrayList<String>(dangerousPermissionGroup);
                foregroundPermissions.remove(backgroundPermission);
                if (!foregroundPermissions.isEmpty() && !PermissionApi.isGrantedPermissions((Context)activity, foregroundPermissions)) {
                    unauthorizedDangerousPermissions.add(foregroundPermissions);
                }
                unauthorizedDangerousPermissions.add(PermissionUtils.asArrayList(backgroundPermission));
                continue;
            }
            unauthorizedDangerousPermissions.add(dangerousPermissionGroup);
        }
        return unauthorizedDangerousPermissions;
    }

    private static void requestAllSpecialPermission(final @NonNull Activity activity, final @NonNull List<String> specialPermissions, final @NonNull Runnable finishRunnable) {
        if (specialPermissions.isEmpty()) {
            finishRunnable.run();
            return;
        }
        final AtomicInteger index = new AtomicInteger();
        PermissionHandler.requestSingleSpecialPermission(activity, specialPermissions.get(index.get()), new Runnable(){

            @Override
            public void run() {
                index.incrementAndGet();
                if (index.get() < specialPermissions.size()) {
                    PermissionHandler.requestSingleSpecialPermission(activity, (String)specialPermissions.get(index.get()), this);
                    return;
                }
                finishRunnable.run();
            }
        });
    }

    private static void requestSingleSpecialPermission(@NonNull Activity activity, @NonNull String specialPermission, final @NonNull Runnable finishRunnable) {
        RequestSpecialPermissionFragment.launch(activity, Collections.singletonList(specialPermission), new OnPermissionPageCallback(){

            @Override
            public void onGranted() {
                finishRunnable.run();
            }

            @Override
            public void onDenied() {
                finishRunnable.run();
            }
        });
    }

    private static void requestAllDangerousPermission(final @NonNull Activity activity, final @NonNull List<List<String>> dangerousPermissions, final @NonNull Runnable finishRunnable) {
        if (!AndroidVersion.isAndroid6()) {
            finishRunnable.run();
            return;
        }
        if (dangerousPermissions.isEmpty()) {
            finishRunnable.run();
            return;
        }
        final AtomicInteger index = new AtomicInteger();
        PermissionHandler.requestSingleDangerousPermission(activity, dangerousPermissions.get(index.get()), new Runnable(){

            @Override
            public void run() {
                index.incrementAndGet();
                if (index.get() < dangerousPermissions.size()) {
                    long delayMillis = 0L;
                    List permissions = (List)dangerousPermissions.get(index.get());
                    if (PermissionHelper.containsBackgroundPermission(permissions)) {
                        long l = delayMillis = AndroidVersion.isAndroid13() ? 150L : 0L;
                    }
                    if (delayMillis == 0L) {
                        PermissionHandler.requestSingleDangerousPermission(activity, permissions, this);
                    } else {
                        PermissionUtils.postDelayed(() -> PermissionHandler.requestSingleDangerousPermission(activity, permissions, this), delayMillis);
                    }
                    return;
                }
                finishRunnable.run();
            }
        });
    }

    private static void requestSingleDangerousPermission(@NonNull Activity activity, @NonNull List<String> dangerousPermissions, @NonNull Runnable finishRunnable) {
        RequestDangerousPermissionFragment.launch(activity, dangerousPermissions, (permissions, grantResults) -> finishRunnable.run());
    }

    private void postDelayedHandlerRequestPermissionsResult() {
        PermissionUtils.postDelayed(this::handlePermissionRequestResult, 300L);
    }

    private void handlePermissionRequestResult() {
        if (this.mInterceptor == null) {
            return;
        }
        OnPermissionCallback callback = this.mCallBack;
        OnPermissionInterceptor interceptor = this.mInterceptor;
        List<String> allPermissions = this.mAllPermissions;
        int[] grantResults = new int[allPermissions.size()];
        for (int i = 0; i < grantResults.length; ++i) {
            String permission2 = allPermissions.get(i);
            grantResults[i] = PermissionApi.isGrantedPermission((Context)this.mActivity, permission2) ? 0 : -1;
            grantResults[i] = PermissionApi.recheckPermissionResult((Context)this.mActivity, permission2, grantResults[i] == 0) ? 0 : -1;
        }
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions(allPermissions, grantResults);
        if (grantedPermissions.size() == allPermissions.size()) {
            interceptor.grantedPermissionRequest(this.mActivity, allPermissions, grantedPermissions, true, callback);
            interceptor.finishPermissionRequest(this.mActivity, allPermissions, false, callback);
            return;
        }
        List<String> deniedPermissions = PermissionApi.getDeniedPermissions(allPermissions, grantResults);
        interceptor.deniedPermissionRequest(this.mActivity, allPermissions, deniedPermissions, PermissionApi.isDoNotAskAgainPermissions(this.mActivity, deniedPermissions), callback);
        if (!grantedPermissions.isEmpty()) {
            interceptor.grantedPermissionRequest(this.mActivity, allPermissions, grantedPermissions, false, callback);
        }
        interceptor.finishPermissionRequest(this.mActivity, allPermissions, false, callback);
    }
}

