/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.support.annotation.NonNull;
import com.hjq.permissions.PermissionUtils;

public abstract class RequestBasePermissionFragment
extends Fragment {
    public static final String REQUEST_PERMISSIONS = "request_permissions";
    private boolean mRequestFlag;
    private boolean mAlreadyRequest;
    private int mScreenOrientation;

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onAttach(Context context) {
        super.onAttach(context);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mScreenOrientation = activity.getRequestedOrientation();
        if (this.mScreenOrientation != -1) {
            return;
        }
        PermissionUtils.lockActivityOrientation(activity);
    }

    public void onDetach() {
        super.onDetach();
        Activity activity = this.getActivity();
        if (activity == null || this.mScreenOrientation != -1 || activity.getRequestedOrientation() == -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachByActivity(this.getActivity());
            return;
        }
        if (this.mAlreadyRequest) {
            return;
        }
        this.mAlreadyRequest = true;
        this.startPermissionRequest();
    }

    public abstract void startPermissionRequest();

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void attachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }
}

