/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV34;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

final class PermissionApi {
    @NonNull
    private static final PermissionDelegate DELEGATE = new PermissionDelegateImplV34();

    PermissionApi() {
    }

    static boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        return DELEGATE.isGrantedPermission(context, permission2);
    }

    static boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        return DELEGATE.isDoNotAskAgainPermission(activity, permission2);
    }

    static Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        return DELEGATE.getPermissionSettingIntent(context, permission2);
    }

    static boolean recheckPermissionResult(@NonNull Context context, @NonNull String permission2, boolean grantResult) {
        return DELEGATE.recheckPermissionResult(context, permission2, grantResult);
    }

    static boolean isSpecialPermission(@NonNull String permission2) {
        return PermissionHelper.isSpecialPermission(permission2);
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (!PermissionApi.isSpecialPermission(permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    static List<String> getGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> grantedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (!PermissionApi.isGrantedPermission(context, permission2)) continue;
            grantedPermission.add(permission2);
        }
        return grantedPermission;
    }

    static List<String> getDeniedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            deniedPermission.add(permission2);
        }
        return deniedPermission;
    }

    static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<String> permissions) {
        for (String permission2 : permissions) {
            if (!PermissionApi.isDoNotAskAgainPermission(activity, permission2)) continue;
            return true;
        }
        return false;
    }

    static List<String> getDeniedPermissions(@NonNull List<String> permissions, @NonNull int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions.get(i));
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(@NonNull List<String> permissions, @NonNull int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions.get(i));
        }
        return grantedPermissions;
    }

    static Intent getSmartPermissionIntent(@NonNull Context context, @Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        if (!PermissionApi.containsSpecialPermission(permissions)) {
            if (permissions.size() == 1) {
                return PermissionApi.getPermissionSettingIntent(context, permissions.get(0));
            }
            return PermissionIntentManager.getApplicationDetailsIntent(context, permissions);
        }
        switch (permissions.size()) {
            case 1: {
                return PermissionApi.getPermissionSettingIntent(context, permissions.get(0));
            }
            case 2: {
                if (AndroidVersion.isAndroid13() || !PermissionUtils.containsPermission(permissions, "android.permission.NOTIFICATION_SERVICE") || !PermissionUtils.containsPermission(permissions, "android.permission.POST_NOTIFICATIONS")) break;
                return PermissionApi.getPermissionSettingIntent(context, "android.permission.NOTIFICATION_SERVICE");
            }
            case 3: {
                if (!AndroidVersion.isAndroid11() || !PermissionUtils.containsPermission(permissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.READ_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.WRITE_EXTERNAL_STORAGE")) break;
                return PermissionApi.getPermissionSettingIntent(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
            }
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }

    static List<String> compatibleOldPermissionByNewPermission(@NonNull List<String> requestPermissions) {
        ArrayList<String> permissions = new ArrayList<String>(requestPermissions);
        for (String permission2 : requestPermissions) {
            String[] oldPermissions;
            if (AndroidVersion.getAndroidVersionCode() >= PermissionHelper.findAndroidVersionByPermission(permission2) || (oldPermissions = PermissionHelper.queryOldPermissionByNewPermission(permission2)) == null) continue;
            for (String oldPermission : oldPermissions) {
                if (PermissionUtils.containsPermission(permissions, oldPermission)) continue;
                permissions.add(oldPermission);
            }
        }
        return permissions;
    }
}

