/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.xtoast;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.xtoast.ActivityLifecycle;
import com.hjq.xtoast.ViewClickWrapper;
import com.hjq.xtoast.ViewLongClickWrapper;
import com.hjq.xtoast.ViewTouchWrapper;
import com.hjq.xtoast.WindowLayout;
import com.hjq.xtoast.draggable.BaseDraggable;
import com.hjq.xtoast.draggable.MovingDraggable;

public class XToast<X extends XToast<?>>
implements Runnable {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private Context mContext;
    private ViewGroup mDecorView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;
    private boolean mShowing;
    private int mDuration;
    private ActivityLifecycle mLifecycle;
    private BaseDraggable mDraggable;
    private OnLifecycle mListener;

    public XToast(Activity activity) {
        this((Context)activity);
        if ((activity.getWindow().getAttributes().flags & 0x400) != 0 || (activity.getWindow().getDecorView().getSystemUiVisibility() & 4) != 0) {
            this.addWindowFlags(1024);
        }
        this.mLifecycle = new ActivityLifecycle(this, activity);
    }

    public XToast(Application application) {
        this((Context)application);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setWindowType(2038);
        } else {
            this.setWindowType(2003);
        }
    }

    private XToast(Context context) {
        this.mContext = context;
        this.mDecorView = new WindowLayout(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mWindowParams = new WindowManager.LayoutParams();
        this.mWindowParams.height = -2;
        this.mWindowParams.width = -2;
        this.mWindowParams.format = -3;
        this.mWindowParams.windowAnimations = 16973828;
        this.mWindowParams.packageName = context.getPackageName();
        this.mWindowParams.flags = 40;
    }

    public X setWidth(int width) {
        View contentView;
        ViewGroup.LayoutParams layoutParams;
        this.mWindowParams.width = width;
        if (this.mDecorView.getChildCount() > 0 && (layoutParams = (contentView = this.mDecorView.getChildAt(0)).getLayoutParams()) != null && layoutParams.width != width) {
            layoutParams.width = width;
            contentView.setLayoutParams(layoutParams);
        }
        this.update();
        return (X)this;
    }

    public X setHeight(int height) {
        View contentView;
        ViewGroup.LayoutParams layoutParams;
        this.mWindowParams.height = height;
        if (this.mDecorView.getChildCount() > 0 && (layoutParams = (contentView = this.mDecorView.getChildAt(0)).getLayoutParams()) != null && layoutParams.height != height) {
            layoutParams.height = height;
            contentView.setLayoutParams(layoutParams);
        }
        this.update();
        return (X)this;
    }

    public X setGravity(int gravity) {
        this.mWindowParams.gravity = gravity;
        this.update();
        return (X)this;
    }

    public X setScreenOrientation(int orientation) {
        this.mWindowParams.screenOrientation = orientation;
        this.update();
        return (X)this;
    }

    public X setXOffset(int x) {
        this.mWindowParams.x = x;
        this.update();
        return (X)this;
    }

    public X setYOffset(int y) {
        this.mWindowParams.y = y;
        this.update();
        return (X)this;
    }

    public X setOutsideTouchable(boolean touchable) {
        int flags = 40;
        if (touchable) {
            this.addWindowFlags(flags);
        } else {
            this.clearWindowFlags(flags);
        }
        this.update();
        return (X)this;
    }

    public X setBackgroundDimAmount(float amount) {
        if (amount < 0.0f || amount > 1.0f) {
            throw new IllegalArgumentException("are you ok?");
        }
        this.mWindowParams.dimAmount = amount;
        int flags = 2;
        if (amount != 0.0f) {
            this.addWindowFlags(flags);
        } else {
            this.clearWindowFlags(flags);
        }
        this.update();
        return (X)this;
    }

    public boolean hasWindowFlags(int flags) {
        return (this.mWindowParams.flags & flags) != 0;
    }

    public X addWindowFlags(int flags) {
        this.mWindowParams.flags |= flags;
        this.update();
        return (X)this;
    }

    public X clearWindowFlags(int flags) {
        this.mWindowParams.flags &= ~flags;
        this.update();
        return (X)this;
    }

    public X setWindowFlags(int flags) {
        this.mWindowParams.flags = flags;
        this.update();
        return (X)this;
    }

    public X setWindowType(int type) {
        this.mWindowParams.type = type;
        this.update();
        return (X)this;
    }

    public X setAnimStyle(int id2) {
        this.mWindowParams.windowAnimations = id2;
        this.update();
        return (X)this;
    }

    public X setSoftInputMode(int mode) {
        this.mWindowParams.softInputMode = mode;
        this.clearWindowFlags(8);
        this.update();
        return (X)this;
    }

    public X setWindowToken(IBinder token) {
        this.mWindowParams.token = token;
        this.update();
        return (X)this;
    }

    public X setWindowAlpha(float alpha) {
        this.mWindowParams.alpha = alpha;
        this.update();
        return (X)this;
    }

    public X setVerticalMargin(float verticalMargin) {
        this.mWindowParams.verticalMargin = verticalMargin;
        this.update();
        return (X)this;
    }

    public X setHorizontalMargin(float horizontalMargin) {
        this.mWindowParams.horizontalMargin = horizontalMargin;
        this.update();
        return (X)this;
    }

    public X setBitmapFormat(int format) {
        this.mWindowParams.format = format;
        this.update();
        return (X)this;
    }

    public X setSystemUiVisibility(int systemUiVisibility) {
        this.mWindowParams.systemUiVisibility = systemUiVisibility;
        this.update();
        return (X)this;
    }

    public X setVerticalWeight(float verticalWeight) {
        this.mWindowParams.verticalWeight = verticalWeight;
        this.update();
        return (X)this;
    }

    public X setLayoutInDisplayCutoutMode(int mode) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.mWindowParams.layoutInDisplayCutoutMode = mode;
            this.update();
        }
        return (X)this;
    }

    public X setPreferredDisplayModeId(int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mWindowParams.preferredDisplayModeId = id2;
            this.update();
        }
        return (X)this;
    }

    public X setWindowTitle(CharSequence title) {
        this.mWindowParams.setTitle(title);
        this.update();
        return (X)this;
    }

    public X setScreenBrightness(float screenBrightness) {
        this.mWindowParams.screenBrightness = screenBrightness;
        this.update();
        return (X)this;
    }

    public X setButtonBrightness(float buttonBrightness) {
        this.mWindowParams.buttonBrightness = buttonBrightness;
        this.update();
        return (X)this;
    }

    public X setPreferredRefreshRate(float preferredRefreshRate) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWindowParams.preferredRefreshRate = preferredRefreshRate;
            this.update();
        }
        return (X)this;
    }

    public X setColorMode(int colorMode) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mWindowParams.setColorMode(colorMode);
            this.update();
        }
        return (X)this;
    }

    public X setBlurBehindRadius(int blurBehindRadius) {
        if (Build.VERSION.SDK_INT >= 31) {
            this.mWindowParams.setBlurBehindRadius(blurBehindRadius);
            this.addWindowFlags(4);
            this.update();
        }
        return (X)this;
    }

    public X setWindowParams(WindowManager.LayoutParams params) {
        this.mWindowParams = params;
        this.update();
        return (X)this;
    }

    public X setDraggable() {
        return this.setDraggable(new MovingDraggable());
    }

    public X setDraggable(BaseDraggable draggable) {
        this.clearWindowFlags(16);
        this.clearWindowFlags(512);
        this.mDraggable = draggable;
        if (this.isShowing()) {
            this.update();
            this.mDraggable.start(this);
        }
        return (X)this;
    }

    public X setDuration(int duration) {
        this.mDuration = duration;
        if (this.isShowing() && this.mDuration != 0) {
            this.removeCallbacks(this);
            this.postDelayed(this, this.mDuration);
        }
        return (X)this;
    }

    public X setOnToastLifecycle(OnLifecycle listener) {
        this.mListener = listener;
        return (X)this;
    }

    public X setDecorView(ViewGroup viewGroup) {
        this.mDecorView = viewGroup;
        return (X)this;
    }

    public X setContentView(int id2) {
        return this.setContentView(LayoutInflater.from((Context)this.mContext).inflate(id2, this.mDecorView, false));
    }

    public X setContentView(View view) {
        if (this.mDecorView.getChildCount() > 0) {
            this.mDecorView.removeAllViews();
        }
        this.mDecorView.addView(view);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            marginLayoutParams.topMargin = 0;
            marginLayoutParams.bottomMargin = 0;
            marginLayoutParams.leftMargin = 0;
            marginLayoutParams.rightMargin = 0;
        }
        if (this.mWindowParams.gravity == 0) {
            int gravity;
            if (layoutParams instanceof FrameLayout.LayoutParams) {
                int gravity2 = ((FrameLayout.LayoutParams)layoutParams).gravity;
                if (gravity2 != -1) {
                    this.mWindowParams.gravity = gravity2;
                }
            } else if (layoutParams instanceof LinearLayout.LayoutParams && (gravity = ((LinearLayout.LayoutParams)layoutParams).gravity) != -1) {
                this.mWindowParams.gravity = gravity;
            }
            if (this.mWindowParams.gravity == 0) {
                this.mWindowParams.gravity = 17;
            }
        }
        if (layoutParams != null) {
            if (this.mWindowParams.width == -2 && this.mWindowParams.height == -2) {
                this.mWindowParams.width = layoutParams.width;
                this.mWindowParams.height = layoutParams.height;
            } else {
                layoutParams.width = this.mWindowParams.width;
                layoutParams.height = this.mWindowParams.height;
            }
        }
        this.update();
        return (X)this;
    }

    public void showAsDropDown(View anchorView) {
        this.showAsDropDown(anchorView, 80);
    }

    public void showAsDropDown(View anchorView, int showGravity) {
        this.showAsDropDown(anchorView, showGravity, 0, 0);
    }

    public void showAsDropDown(View anchorView, int showGravity, int xOff, int yOff) {
        if (this.mDecorView.getChildCount() == 0 || this.mWindowParams == null) {
            throw new IllegalArgumentException("WindowParams and view cannot be empty");
        }
        if (Build.VERSION.SDK_INT >= 17) {
            showGravity = Gravity.getAbsoluteGravity((int)showGravity, (int)anchorView.getResources().getConfiguration().getLayoutDirection());
        }
        int[] anchorViewLocation = new int[2];
        anchorView.getLocationOnScreen(anchorViewLocation);
        Rect windowVisibleRect = new Rect();
        anchorView.getWindowVisibleDisplayFrame(windowVisibleRect);
        this.mWindowParams.gravity = 0x800033;
        this.mWindowParams.x = anchorViewLocation[0] - windowVisibleRect.left + xOff;
        this.mWindowParams.y = anchorViewLocation[1] - windowVisibleRect.top + yOff;
        if ((showGravity & 3) == 3) {
            int rootViewWidth = this.mDecorView.getWidth();
            if (rootViewWidth == 0) {
                rootViewWidth = this.mDecorView.getMeasuredWidth();
            }
            if (rootViewWidth == 0) {
                this.mDecorView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                rootViewWidth = this.mDecorView.getMeasuredWidth();
            }
            this.mWindowParams.x -= rootViewWidth;
        } else if ((showGravity & 5) == 5) {
            this.mWindowParams.x += anchorView.getWidth();
        }
        if ((showGravity & 0x30) == 48) {
            int rootViewHeight = this.mDecorView.getHeight();
            if (rootViewHeight == 0) {
                rootViewHeight = this.mDecorView.getMeasuredHeight();
            }
            if (rootViewHeight == 0) {
                this.mDecorView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                rootViewHeight = this.mDecorView.getMeasuredHeight();
            }
            this.mWindowParams.y -= rootViewHeight;
        } else if ((showGravity & 0x50) == 80) {
            this.mWindowParams.y += anchorView.getHeight();
        }
        this.show();
    }

    public void show() {
        if (this.mDecorView.getChildCount() == 0 || this.mWindowParams == null) {
            throw new IllegalArgumentException("WindowParams and view cannot be empty");
        }
        if (this.mShowing) {
            this.update();
            return;
        }
        if (this.mContext instanceof Activity && (((Activity)this.mContext).isFinishing() || Build.VERSION.SDK_INT >= 17 && ((Activity)this.mContext).isDestroyed())) {
            return;
        }
        try {
            if (this.mDecorView.getParent() != null) {
                this.mWindowManager.removeViewImmediate((View)this.mDecorView);
            }
            this.mWindowManager.addView((View)this.mDecorView, (ViewGroup.LayoutParams)this.mWindowParams);
            this.mShowing = true;
            if (this.mDuration != 0) {
                this.removeCallbacks(this);
                this.postDelayed(this, this.mDuration);
            }
            if (this.mDraggable != null) {
                this.mDraggable.start(this);
            }
            if (this.mLifecycle != null) {
                this.mLifecycle.register();
            }
            if (this.mListener != null) {
                this.mListener.onShow(this);
            }
        }
        catch (WindowManager.BadTokenException | IllegalArgumentException | IllegalStateException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        if (!this.mShowing) {
            return;
        }
        try {
            if (this.mLifecycle != null) {
                this.mLifecycle.unregister();
            }
            this.mWindowManager.removeViewImmediate((View)this.mDecorView);
            this.removeCallbacks(this);
            if (this.mListener != null) {
                this.mListener.onDismiss(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            this.mShowing = false;
        }
    }

    public void update() {
        if (!this.isShowing()) {
            return;
        }
        this.mWindowManager.updateViewLayout((View)this.mDecorView, (ViewGroup.LayoutParams)this.mWindowParams);
    }

    public void recycle() {
        if (this.isShowing()) {
            this.cancel();
        }
        if (this.mListener != null) {
            this.mListener.onRecycler(this);
        }
        this.mListener = null;
        this.mContext = null;
        this.mDecorView = null;
        this.mWindowManager = null;
        this.mWindowParams = null;
        this.mLifecycle = null;
        this.mDraggable = null;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public WindowManager.LayoutParams getWindowParams() {
        return this.mWindowParams;
    }

    public Context getContext() {
        return this.mContext;
    }

    public View getDecorView() {
        return this.mDecorView;
    }

    public View getContentView() {
        if (this.mDecorView.getChildCount() == 0) {
            return null;
        }
        return this.mDecorView.getChildAt(0);
    }

    public <V extends View> V findViewById(int id2) {
        return (V)this.mDecorView.findViewById(id2);
    }

    public void startActivity(Class<? extends Activity> clazz) {
        this.startActivity(new Intent(this.mContext, clazz));
    }

    public void startActivity(Intent intent) {
        if (!(this.mContext instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        this.mContext.startActivity(intent);
    }

    public X setVisibility(int id2, int visibility) {
        this.findViewById(id2).setVisibility(visibility);
        return (X)this;
    }

    public X setText(int id2) {
        return this.setText(16908299, id2);
    }

    public X setText(int viewId, int stringId) {
        return this.setText(viewId, this.mContext.getResources().getString(stringId));
    }

    public X setText(CharSequence text) {
        return this.setText(16908299, text);
    }

    public X setText(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setText(text);
        return (X)this;
    }

    public X setTextColor(int id2, int color) {
        ((TextView)this.findViewById(id2)).setTextColor(color);
        return (X)this;
    }

    public X setHint(int viewId, int stringId) {
        return this.setHint(viewId, this.mContext.getResources().getString(stringId));
    }

    public X setHint(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setHint(text);
        return (X)this;
    }

    public X setHintColor(int id2, int color) {
        ((TextView)this.findViewById(id2)).setHintTextColor(color);
        return (X)this;
    }

    public X setBackground(int viewId, int drawableId) {
        Drawable drawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getDrawable(drawableId) : this.mContext.getResources().getDrawable(drawableId);
        return this.setBackground(viewId, drawable);
    }

    public X setBackground(int id2, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.findViewById(id2).setBackground(drawable);
        } else {
            this.findViewById(id2).setBackgroundDrawable(drawable);
        }
        return (X)this;
    }

    public X setImageDrawable(int viewId, int drawableId) {
        Drawable drawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getDrawable(drawableId) : this.mContext.getResources().getDrawable(drawableId);
        return this.setImageDrawable(viewId, drawable);
    }

    public X setImageDrawable(int viewId, Drawable drawable) {
        ((ImageView)this.findViewById(viewId)).setImageDrawable(drawable);
        return (X)this;
    }

    public Handler getHandler() {
        return HANDLER;
    }

    public boolean post(Runnable runnable) {
        return this.postDelayed(runnable, 0L);
    }

    public boolean postDelayed(Runnable runnable, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.postAtTime(runnable, SystemClock.uptimeMillis() + delayMillis);
    }

    public boolean postAtTime(Runnable runnable, long uptimeMillis) {
        return HANDLER.postAtTime(runnable, (Object)this, uptimeMillis);
    }

    public void removeCallbacks(Runnable runnable) {
        HANDLER.removeCallbacks(runnable);
    }

    public void removeCallbacksAndMessages() {
        HANDLER.removeCallbacksAndMessages((Object)this);
    }

    public X setOnClickListener(OnClickListener<? extends View> listener) {
        return this.setOnClickListener((View)this.mDecorView, listener);
    }

    public X setOnClickListener(int id2, OnClickListener<? extends View> listener) {
        return this.setOnClickListener((View)this.findViewById(id2), listener);
    }

    private X setOnClickListener(View view, OnClickListener<? extends View> listener) {
        this.clearWindowFlags(16);
        view.setClickable(true);
        view.setOnClickListener((View.OnClickListener)new ViewClickWrapper(this, listener));
        return (X)this;
    }

    public X setOnLongClickListener(OnLongClickListener<? extends View> listener) {
        return this.setOnLongClickListener((View)this.mDecorView, listener);
    }

    public X setOnLongClickListener(int id2, OnLongClickListener<? extends View> listener) {
        return this.setOnLongClickListener((View)this.findViewById(id2), listener);
    }

    private X setOnLongClickListener(View view, OnLongClickListener<? extends View> listener) {
        this.clearWindowFlags(16);
        view.setClickable(true);
        view.setOnLongClickListener((View.OnLongClickListener)new ViewLongClickWrapper(this, listener));
        return (X)this;
    }

    public X setOnTouchListener(OnTouchListener<? extends View> listener) {
        return this.setOnTouchListener((View)this.mDecorView, listener);
    }

    public X setOnTouchListener(int id2, OnTouchListener<? extends View> listener) {
        return this.setOnTouchListener((View)this.findViewById(id2), listener);
    }

    private X setOnTouchListener(View view, OnTouchListener<? extends View> listener) {
        this.clearWindowFlags(16);
        view.setEnabled(true);
        view.setOnTouchListener((View.OnTouchListener)new ViewTouchWrapper(this, listener));
        return (X)this;
    }

    @Override
    public void run() {
        this.cancel();
    }

    public static interface OnLifecycle {
        default public void onShow(XToast<?> toast) {
        }

        default public void onDismiss(XToast<?> toast) {
        }

        default public void onRecycler(XToast<?> toast) {
        }
    }

    public static interface OnTouchListener<V extends View> {
        public boolean onTouch(XToast<?> var1, V var2, MotionEvent var3);
    }

    public static interface OnLongClickListener<V extends View> {
        public boolean onLongClick(XToast<?> var1, V var2);
    }

    public static interface OnClickListener<V extends View> {
        public void onClick(XToast<?> var1, V var2);
    }
}

