/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast.style;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewGroup;
import android.widget.TextView;
import com.hjq.toast.config.IToastStyle;

public class BlackToastStyle
implements IToastStyle<TextView> {
    @Override
    public TextView createView(Context context) {
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setGravity(this.getTextGravity(context));
        textView.setTextColor(this.getTextColor(context));
        textView.setTextSize(0, this.getTextSize(context));
        int horizontalPadding = this.getHorizontalPadding(context);
        int verticalPadding = this.getVerticalPadding(context);
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setPaddingRelative(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        } else {
            textView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        }
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        Drawable background = this.getBackgroundDrawable(context);
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground(background);
        } else {
            textView.setBackgroundDrawable(background);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ(this.getTranslationZ(context));
        }
        textView.setMaxLines(this.getMaxLines(context));
        return textView;
    }

    protected int getTextGravity(Context context) {
        return 17;
    }

    protected int getTextColor(Context context) {
        return -285212673;
    }

    protected float getTextSize(Context context) {
        return TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected int getHorizontalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected int getVerticalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected Drawable getBackgroundDrawable(Context context) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(-2013265920);
        drawable.setCornerRadius(TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        return drawable;
    }

    protected float getTranslationZ(Context context) {
        return TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected int getMaxLines(Context context) {
        return 5;
    }
}

